/*******************************************************************************
 * Copyright (c) 1998, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 * Denise Smith - 2.4
 ******************************************************************************/
package org.eclipse.persistence.testing.jaxb.xmlpath;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

import org.eclipse.persistence.oxm.annotations.XmlPath;

@XmlRootElement(name="root")
public class TestObjectToAttributeWithXmlAttribute {
	@XmlAttribute
	@XmlPath("something/@theFlag")
	public boolean theFlag;
		
	public boolean equals(Object obj){
		if(obj instanceof TestObjectToAttributeWithXmlAttribute){
			return theFlag == ((TestObjectToAttributeWithXmlAttribute)obj).theFlag; 
		}
		return false;
	}
}
