/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.AbstractDialog;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryParameter;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryParameterArgument;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QueryParameterDialog;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ArgumentPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleListCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.NameTools;

final class ParameterArgumentPanel
extends ArgumentPanel {
    private PropertyValueModel queryArgumentHolder;

    ParameterArgumentPanel(PropertyValueModel argumentHolder, WorkbenchContextHolder contextHolder, Collection enablingComponents) {
        super(argumentHolder, contextHolder);
        this.initialize(enablingComponents);
    }

    private void initialize(Collection enablingComponents) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JComboBox parameterComboBox = this.buildParameterComboBox();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 2;
        constraints.anchor = 23;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)parameterComboBox, constraints);
        enablingComponents.add(parameterComboBox);
        JButton addButton = this.buildButton("ADD_PARAMETER_BUTTON");
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParameterArgumentPanel.this.addParameter();
            }
        });
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)addButton, constraints);
    }

    private void addParameter() {
        MWQuery query = (MWQuery)this.getQueryHolder().getValue();
        String newName = NameTools.uniqueNameFor((String)"arg", (Iterator)query.parameterNames());
        QueryParameterDialog dialog = new QueryParameterDialog(query, query.typeFor(String.class), newName, (AbstractDialog)this.getWorkbenchContext().getCurrentWindow(), this.getWorkbenchContext(), this.resourceRepository().getString("QUERY_PARAMETER_DIALOG.title"));
        dialog.show();
        if (dialog.wasConfirmed()) {
            MWClass type = dialog.getParameterType();
            String name = dialog.getParameterName();
            MWQueryParameter parameter = query.addParameter(type);
            parameter.setName(name);
            ((MWQueryParameterArgument)this.getArgumentHolder().getValue()).setQueryParameter(parameter);
        }
    }

    private JComboBox buildParameterComboBox() {
        JComboBox comboBox = new JComboBox(new ComboBoxModelAdapter(this.buildParametersCollectionHolder(), this.buildParameterHolder()));
        comboBox.setRenderer(this.buildParametersListCellRenderer());
        return comboBox;
    }

    private ListValueModel buildParametersCollectionHolder() {
        return new ListAspectAdapter(this.getQueryHolder(), "parameters"){

            @Override
            protected ListIterator getValueFromSubject() {
                return ((MWAbstractQuery)this.subject).parameters();
            }

            @Override
            protected int sizeFromSubject() {
                return ((MWAbstractQuery)this.subject).parametersSize();
            }
        };
    }

    private PropertyValueModel buildParameterHolder() {
        return new PropertyAspectAdapter(this.getArgumentHolder(), "queryParameter"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWQueryParameterArgument)this.subject).getQueryParameter();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWQueryParameterArgument)this.subject).setQueryParameter((MWQueryParameter)value);
            }
        };
    }

    @Override
    protected PropertyValueModel buildQueryArgumentHolder(PropertyValueModel argumentHolder) {
        return new FilteringPropertyValueModel(argumentHolder){

            @Override
            protected boolean accept(Object value) {
                return value instanceof MWQueryParameterArgument;
            }
        };
    }

    private ListCellRenderer buildParametersListCellRenderer() {
        return new SimpleListCellRenderer(){

            @Override
            protected String buildText(Object value) {
                return value == null ? ParameterArgumentPanel.this.resourceRepository().getString("NONE_SELECTED") : ((MWQueryParameter)value).getName();
            }
        };
    }
}

