/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWReference;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWManyToManyMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.relational.MWTableReferenceMapping;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.mapping.relational.AbstractTableReferencePanel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;

final class ManyToManyTargetReferencePanel
extends AbstractTableReferencePanel {
    ManyToManyTargetReferencePanel(PropertyValueModel subjectHolder, WorkbenchContextHolder contextHolder) {
        super(subjectHolder, contextHolder);
    }

    @Override
    protected Iterator candidateReferences(MWTableReferenceMapping mapping) {
        return ((MWManyToManyMapping)mapping).candidateRelationTableTargetReferences();
    }

    @Override
    protected PropertyValueModel buildTableReferenceHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "targetReference"){

            @Override
            protected Object getValueFromSubject() {
                return ((MWManyToManyMapping)this.subject).getTargetReference();
            }

            @Override
            protected void setValueOnSubject(Object value) {
                ((MWManyToManyMapping)this.subject).setTargetReference((MWReference)value);
            }
        };
    }

    @Override
    protected void setReference(MWReference reference) {
        MWManyToManyMapping mapping = this.mapping();
        mapping.setTargetReference(reference);
        if (mapping.getRelationTable() == null) {
            mapping.setRelationTable(reference.getSourceTable());
        }
    }

    @Override
    protected List candidateNewReferenceSourceTables() {
        MWTable relationTable = this.mapping().getRelationTable();
        if (relationTable == null) {
            return super.candidateNewReferenceSourceTables();
        }
        return Collections.singletonList(relationTable);
    }

    @Override
    protected MWTable defaultNewReferenceSourceTable() {
        return this.mapping().getRelationTable();
    }

    @Override
    protected MWTable defaultNewReferenceTargetTable() {
        MWRelationalDescriptor descriptor = (MWRelationalDescriptor)this.mapping().getReferenceDescriptor();
        if (descriptor == null) {
            return null;
        }
        Iterator candidateTables = descriptor.candidateTables();
        return candidateTables.hasNext() ? (MWTable)candidateTables.next() : null;
    }

    private MWManyToManyMapping mapping() {
        return (MWManyToManyMapping)this.subject();
    }
}

