/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.framework.internal;

import org.eclipse.persistence.tools.workbench.framework.action.ActionRepository;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.internal.CloseAction;
import org.eclipse.persistence.tools.workbench.framework.internal.CloseAllAction;
import org.eclipse.persistence.tools.workbench.framework.internal.ExitAction;
import org.eclipse.persistence.tools.workbench.framework.internal.FrameworkNodeManager;
import org.eclipse.persistence.tools.workbench.framework.internal.OpenAction;
import org.eclipse.persistence.tools.workbench.framework.internal.SaveAction;
import org.eclipse.persistence.tools.workbench.framework.internal.SaveAllAction;
import org.eclipse.persistence.tools.workbench.framework.internal.SaveAsAction;
import org.eclipse.persistence.tools.workbench.framework.internal.WorkbenchWindow;

final class FrameworkActionRepository
implements ActionRepository {
    private FrameworkNodeManager frameworkNodeManager;
    private WorkbenchContext workbenchContext;

    FrameworkActionRepository(WorkbenchWindow workbenchWindow) {
        this.initialize(workbenchWindow);
    }

    private void initialize(WorkbenchWindow workbenchWindow) {
        this.workbenchContext = workbenchWindow.getContext();
        this.frameworkNodeManager = workbenchWindow.nodeManager();
    }

    @Override
    public FrameworkAction getSaveAction() {
        return new SaveAction(this.workbenchContext, this.frameworkNodeManager);
    }

    @Override
    public FrameworkAction getSaveAsAction() {
        return new SaveAsAction(this.workbenchContext, this.frameworkNodeManager);
    }

    @Override
    public FrameworkAction getCloseAction() {
        return new CloseAction(this.workbenchContext, this.frameworkNodeManager);
    }

    FrameworkAction getOpenAction() {
        return new OpenAction(this.workbenchContext, this.frameworkNodeManager);
    }

    FrameworkAction getCloseAllAction() {
        return new CloseAllAction(this.workbenchContext, this.frameworkNodeManager);
    }

    FrameworkAction getSaveAllAction() {
        return new SaveAllAction(this.workbenchContext, this.frameworkNodeManager);
    }

    FrameworkAction getExitAction() {
        return new ExitAction(this.workbenchContext, this.frameworkNodeManager);
    }
}

