/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import java.io.PrintWriter;
import org.eclipse.persistence.tools.workbench.utility.classfile.Constant;
import org.eclipse.persistence.tools.workbench.utility.classfile.ConstantPool;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class StringConstant
extends Constant {
    private short stringIndex;

    StringConstant(ConstantPool pool, byte tag, ClassFileDataInputStream stream) throws IOException {
        super(pool, tag, stream);
    }

    @Override
    void initialize(ClassFileDataInputStream stream) throws IOException {
        this.stringIndex = stream.readU2();
    }

    @Override
    public void displayStringOn(IndentingPrintWriter writer) {
        super.displayStringOn(writer);
        writer.print(" string: ");
        writer.println(this.string());
    }

    @Override
    public String description() {
        return "String";
    }

    @Override
    public void printFieldInitializationClauseOn(PrintWriter writer) {
        writer.print('\"');
        writer.print(this.string());
        writer.print('\"');
    }

    public String string() {
        return this.utf8String(this.stringIndex);
    }

    public short getStringIndex() {
        return this.stringIndex;
    }

    @Override
    public Object value() {
        return this.string();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

