/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;
import org.eclipse.persistence.tools.workbench.utility.io.FileTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.ArrayIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.CompositeIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;

public class Classpath
implements Serializable {
    private final Entry[] entries;
    private static final long serialVersionUID = 1L;

    public static Classpath bootClasspath() {
        return new Classpath(System.getProperty("sun.boot.class.path"));
    }

    public static Classpath javaExtensionClasspath() {
        File[] dirs = Classpath.javaExtensionDirectories();
        int len = dirs.length;
        ArrayList jarFileNames = new ArrayList();
        for (int i = 0; i < len; ++i) {
            File dir = dirs[i];
            if (!dir.isDirectory()) continue;
            Classpath.addJarFileNamesTo(dir, jarFileNames);
        }
        return new Classpath(jarFileNames);
    }

    public static Classpath javaClasspath() {
        return new Classpath(System.getProperty("java.class.path"));
    }

    public static Classpath completeClasspath() {
        return new Classpath(new Classpath[]{Classpath.bootClasspath(), Classpath.javaExtensionClasspath(), Classpath.javaClasspath()});
    }

    public static Classpath classpathFor(Class javaClass) {
        return new Classpath(Classpath.locationFor(javaClass));
    }

    public static String convertToClassName(String classFileName) {
        String className = FileTools.stripExtension(classFileName);
        className = className.replace('/', '.');
        if (File.separatorChar != '/') {
            className = className.replace(File.separatorChar, '.');
        }
        return className;
    }

    public static String convertToClassName(File classFile) {
        return Classpath.convertToClassName(classFile.getPath());
    }

    public static Class convertToClass(String classFileName) throws ClassNotFoundException {
        return Class.forName(Classpath.convertToClassName(classFileName));
    }

    public static Class convertToClass(File classFile) throws ClassNotFoundException {
        return Classpath.convertToClass(classFile.getPath());
    }

    public static String convertToArchiveEntryNameBase(String className) {
        return className.replace('.', '/');
    }

    public static String convertToArchiveEntryNameBase(Class javaClass) {
        return Classpath.convertToArchiveEntryNameBase(javaClass.getName());
    }

    public static String convertToArchiveClassFileEntryName(String className) {
        return Classpath.convertToArchiveEntryNameBase(className) + ".class";
    }

    public static String convertToArchiveClassFileEntryName(Class javaClass) {
        return Classpath.convertToArchiveClassFileEntryName(javaClass.getName());
    }

    public static String convertToFileNameBase(String className) {
        return className.replace('.', File.separatorChar);
    }

    public static String convertToFileNameBase(Class javaClass) {
        return Classpath.convertToFileNameBase(javaClass.getName());
    }

    public static String convertToClassFileName(String className) {
        return Classpath.convertToFileNameBase(className) + ".class";
    }

    public static String convertToClassFileName(Class javaClass) {
        return Classpath.convertToClassFileName(javaClass.getName());
    }

    public static File convertToClassFile(String className) {
        return new File(Classpath.convertToClassFileName(className));
    }

    public static File convertToClassFile(Class javaClass) {
        return Classpath.convertToClassFile(javaClass.getName());
    }

    public static String convertToJavaFileName(String className) {
        return Classpath.convertToFileNameBase(className) + ".java";
    }

    public static String convertToJavaFileName(Class javaClass) {
        return Classpath.convertToJavaFileName(javaClass.getName());
    }

    public static File convertToJavaFile(String className) {
        return new File(Classpath.convertToJavaFileName(className));
    }

    public static File convertToJavaFile(Class javaClass) {
        return Classpath.convertToJavaFile(javaClass.getName());
    }

    public static String convertToResourceName(Class javaClass) {
        return '/' + Classpath.convertToArchiveClassFileEntryName(javaClass);
    }

    public static URL convertToResource(Class javaClass) {
        return javaClass.getResource(Classpath.convertToResourceName(javaClass));
    }

    public static boolean fileNameIsArchive(String fileName) {
        String ext = FileTools.extension(fileName).toLowerCase();
        return ext.equals(".jar") || ext.equals(".zip");
    }

    public static boolean fileIsArchive(File file) {
        return Classpath.fileNameIsArchive(file.getName());
    }

    public static String rtJarName() {
        return Classpath.locationFor(Object.class);
    }

    public static String locationFor(Class javaClass) {
        String path;
        URL url = Classpath.convertToResource(javaClass);
        try {
            path = FileTools.buildFile(url).getPath();
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        String protocol = url.getProtocol().toLowerCase();
        if (protocol.equals("jar")) {
            return path.substring(0, path.indexOf(33));
        }
        if (protocol.equals("file")) {
            return path.substring(0, path.length() - Classpath.convertToClassFileName(javaClass).length() - 1);
        }
        throw new IllegalStateException(url.toString());
    }

    public static File[] javaExtensionDirectories() {
        return Classpath.convertToFiles(Classpath.javaExtensionDirectoryNames());
    }

    public static String[] javaExtensionDirectoryNames() {
        return System.getProperty("java.ext.dirs").split(File.pathSeparator);
    }

    private static File[] convertToFiles(String[] fileNames) {
        File[] files = new File[fileNames.length];
        int i = fileNames.length;
        while (i-- > 0) {
            files[i] = new File(fileNames[i]);
        }
        return files;
    }

    private static void addJarFileNamesTo(File dir, List jarFileNames) {
        File[] jarFiles = Classpath.jarFilesIn(dir);
        int len = jarFiles.length;
        for (int i = 0; i < len; ++i) {
            jarFileNames.add(FileTools.canonicalFile(jarFiles[i]).getPath());
        }
    }

    private static File[] jarFilesIn(File directory) {
        return directory.listFiles(Classpath.jarFileFilter());
    }

    private static FileFilter jarFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return FileTools.extension(file.getName()).toLowerCase().equals(".jar");
            }
        };
    }

    private Classpath(Entry[] entries) {
        this.entries = entries;
    }

    public Classpath(String[] fileNames) {
        this(Classpath.buildEntries(fileNames));
    }

    private static Entry[] buildEntries(String[] fileNames) {
        int len = fileNames.length;
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (int i = 0; i < len; ++i) {
            String fileName = fileNames[i];
            if (fileName == null || fileName.length() == 0) continue;
            entries.add(new Entry(fileName));
        }
        return entries.toArray(new Entry[entries.size()]);
    }

    public Classpath(String path) {
        this(path.split(File.pathSeparator));
    }

    public Classpath(List fileNames) {
        this(fileNames.toArray(new String[fileNames.size()]));
    }

    public Classpath(Classpath[] classpaths) {
        this(Classpath.consolidateEntries(classpaths));
    }

    private static Entry[] consolidateEntries(Classpath[] classpaths) {
        int len = classpaths.length;
        ArrayList entries = new ArrayList();
        for (int i = 0; i < len; ++i) {
            CollectionTools.addAll(entries, (Object[])classpaths[i].getEntries());
        }
        return entries.toArray(new Entry[entries.size()]);
    }

    public Entry[] getEntries() {
        return this.entries;
    }

    public String path() {
        Entry[] localEntries = this.entries;
        int max = localEntries.length - 1;
        if (max == -1) {
            return "";
        }
        StringBuffer sb = new StringBuffer(2000);
        for (int i = 0; i < max; ++i) {
            sb.append(localEntries[i].fileName());
            sb.append(File.pathSeparatorChar);
        }
        sb.append(localEntries[max].fileName());
        return sb.toString();
    }

    public Entry entryForFileNamed(String shortFileName) {
        Entry[] localEntries = this.entries;
        int len = localEntries.length;
        for (int i = 0; i < len; ++i) {
            if (!localEntries[i].file().getName().equals(shortFileName)) continue;
            return localEntries[i];
        }
        return null;
    }

    public Entry entryForClassNamed(String className) {
        String relativeClassFileName = Classpath.convertToClassFileName(className);
        String archiveEntryName = Classpath.convertToArchiveClassFileEntryName(className);
        Entry[] localEntries = this.entries;
        int len = localEntries.length;
        for (int i = 0; i < len; ++i) {
            if (!localEntries[i].contains(relativeClassFileName, archiveEntryName)) continue;
            return localEntries[i];
        }
        return null;
    }

    public String[] classNames() {
        return this.classNames(Filter.NULL_INSTANCE);
    }

    public String[] classNames(Filter filter) {
        HashSet classNames = new HashSet(10000);
        this.addClassNamesTo(classNames, filter);
        return classNames.toArray(new String[classNames.size()]);
    }

    public void addClassNamesTo(Collection classNames) {
        this.addClassNamesTo(classNames, Filter.NULL_INSTANCE);
    }

    public void addClassNamesTo(Collection classNames, Filter filter) {
        Entry[] localEntries = this.entries;
        int len = localEntries.length;
        for (int i = 0; i < len; ++i) {
            localEntries[i].addClassNamesTo(classNames, filter);
        }
    }

    public Iterator classNamesStream() {
        return this.classNamesStream(Filter.NULL_INSTANCE);
    }

    public Iterator classNamesStream(Filter filter) {
        return new CompositeIterator(this.entryClassNamesStreams(filter));
    }

    private Iterator entryClassNamesStreams(final Filter filter) {
        return new TransformationIterator(new ArrayIterator(this.entries)){

            @Override
            protected Object transform(Object next) {
                return ((Entry)next).classNamesStream(filter);
            }
        };
    }

    public Classpath compressed() {
        return new Classpath((Entry[])CollectionTools.removeDuplicateElements(this.entries));
    }

    public URL[] urls() {
        Entry[] localEntries = this.entries;
        int len = localEntries.length;
        URL[] urls = new URL[len];
        for (int i = 0; i < len; ++i) {
            urls[i] = localEntries[i].url();
        }
        return urls;
    }

    public static class Entry
    implements Serializable {
        private final String fileName;
        private final File file;
        private final File canonicalFile;
        private static final long serialVersionUID = 1L;

        Entry(String fileName) {
            if (fileName == null || fileName.length() == 0) {
                throw new IllegalArgumentException("'fileName' must be non-empty");
            }
            this.fileName = fileName;
            this.file = new File(fileName);
            this.canonicalFile = FileTools.canonicalFile(this.file);
        }

        public String fileName() {
            return this.fileName;
        }

        public File file() {
            return this.file;
        }

        public File canonicalFile() {
            return this.canonicalFile;
        }

        public String canonicalFileName() {
            return this.canonicalFile.getAbsolutePath();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            return ((Entry)o).canonicalFile.equals(this.canonicalFile);
        }

        public int hashCode() {
            return this.canonicalFile.hashCode();
        }

        public URL url() {
            try {
                return this.canonicalFile.toURL();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        public boolean contains(Class javaClass) {
            return this.contains(javaClass.getName());
        }

        public boolean contains(String className) {
            return this.contains(Classpath.convertToClassFileName(className), Classpath.convertToArchiveClassFileEntryName(className));
        }

        boolean contains(String relativeClassFileName, String archiveEntryName) {
            if (!this.canonicalFile.exists()) {
                return false;
            }
            if (this.canonicalFile.isDirectory() && new File(this.canonicalFile, relativeClassFileName).exists()) {
                return true;
            }
            return Classpath.fileIsArchive(this.canonicalFile) && this.archiveContainsEntry(archiveEntryName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean archiveContainsEntry(String zipEntryName) {
            ZipFile zipFile = null;
            ZipEntry zipEntry = null;
            try {
                zipFile = new ZipFile(this.canonicalFile);
                zipEntry = zipFile.getEntry(zipEntryName);
            }
            catch (IOException ex) {
                zipEntry = null;
            }
            finally {
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (IOException ex) {
                    zipEntry = null;
                }
            }
            return zipEntry != null;
        }

        public String[] classNames() {
            return this.classNames(Filter.NULL_INSTANCE);
        }

        public String[] classNames(Filter filter) {
            ArrayList classNames = new ArrayList(2000);
            this.addClassNamesTo(classNames, filter);
            return classNames.toArray(new String[classNames.size()]);
        }

        public void addClassNamesTo(Collection classNames) {
            this.addClassNamesTo(classNames, Filter.NULL_INSTANCE);
        }

        public void addClassNamesTo(Collection classNames, Filter filter) {
            if (this.canonicalFile.exists()) {
                if (this.canonicalFile.isDirectory()) {
                    this.addClassNamesForDirectoryTo(classNames, filter);
                } else if (Classpath.fileIsArchive(this.canonicalFile)) {
                    this.addClassNamesForArchiveTo(classNames, filter);
                }
            }
        }

        private void addClassNamesForDirectoryTo(Collection classNames, Filter filter) {
            int start = this.canonicalFile.getAbsolutePath().length() + 1;
            Iterator stream = this.classFilesForDirectory();
            while (stream.hasNext()) {
                String className = Classpath.convertToClassName(((File)stream.next()).getAbsolutePath().substring(start));
                if (!filter.accept(className)) continue;
                classNames.add(className);
            }
        }

        private Iterator classFilesForDirectory() {
            return new FilteringIterator(FileTools.filesInTree(this.canonicalFile)){

                @Override
                protected boolean accept(Object next) {
                    return Entry.this.fileNameMightBeForClassFile(((File)next).getName());
                }
            };
        }

        private void addClassNamesForArchiveTo(Collection classNames, Filter filter) {
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(this.canonicalFile);
            }
            catch (IOException ex) {
                return;
            }
            Enumeration<? extends ZipEntry> stream = zipFile.entries();
            while (stream.hasMoreElements()) {
                String className;
                ZipEntry zipEntry = stream.nextElement();
                String zipEntryName = zipEntry.getName();
                if (!this.fileNameMightBeForClassFile(zipEntryName) || !filter.accept(className = Classpath.convertToClassName(zipEntryName))) continue;
                classNames.add(className);
            }
            try {
                zipFile.close();
            }
            catch (IOException ex) {
                return;
            }
        }

        boolean fileNameMightBeForClassFile(String name) {
            return FileTools.extension(name).toLowerCase().equals(".class") && name.indexOf(32) == -1;
        }

        public Iterator classNamesStream() {
            return this.classNamesStream(Filter.NULL_INSTANCE);
        }

        public Iterator classNamesStream(Filter filter) {
            if (this.canonicalFile.exists()) {
                if (this.canonicalFile.isDirectory()) {
                    return this.classNamesForDirectory(filter);
                }
                if (Classpath.fileIsArchive(this.canonicalFile)) {
                    return this.classNamesForArchive(filter);
                }
            }
            return NullIterator.instance();
        }

        private Iterator classNamesForDirectory(Filter filter) {
            return new FilteringIterator(this.classNamesForDirectory(), filter);
        }

        private Iterator classNamesForDirectory() {
            final int start = this.canonicalFile.getAbsolutePath().length() + 1;
            return new TransformationIterator(this.classFilesForDirectory()){

                @Override
                protected Object transform(Object next) {
                    return Classpath.convertToClassName(((File)next).getAbsolutePath().substring(start));
                }
            };
        }

        private Iterator classNamesForArchive(Filter filter) {
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(this.canonicalFile);
            }
            catch (IOException ex) {
                return NullIterator.instance();
            }
            HashSet<String> classNames = new HashSet<String>(zipFile.size());
            Enumeration<? extends ZipEntry> stream = zipFile.entries();
            while (stream.hasMoreElements()) {
                String className;
                ZipEntry zipEntry = stream.nextElement();
                String zipEntryName = zipEntry.getName();
                if (!this.fileNameMightBeForClassFile(zipEntryName) || !filter.accept(className = Classpath.convertToClassName(zipEntryName))) continue;
                classNames.add(className);
            }
            try {
                zipFile.close();
            }
            catch (IOException ex) {
                return NullIterator.instance();
            }
            return classNames.iterator();
        }
    }
}

