/*******************************************************************************
 * Copyright (c) 2009, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.iterable;

import java.util.ListIterator;
import org.eclipse.persistence.tools.utility.iterator.ReadOnlyListIterator;

/**
 * A <code>ReadOnlyListIterable</code> wraps another {@link ListIterable}
 * and returns a read-only {@link ListIterator}.
 *
 * @param <E> the type of elements returned by the list iterable's list iterator
 *
 * @see ReadOnlyListIterator
 * @see ReadOnlyIterable
 */
public class ReadOnlyListIterable<E>
	implements ListIterable<E>
{
	private final ListIterable<? extends E> listIterable;


	/**
	 * Construct a list iterable the returns a read-only list iterator on the elements
	 * in the specified list iterable.
	 */
	public ReadOnlyListIterable(ListIterable<? extends E> iterable) {
		super();
		if (iterable == null) {
			throw new NullPointerException();
		}
		this.listIterable = iterable;
	}

	@Override
	public ListIterator<E> iterator() {
		return new ReadOnlyListIterator<E>(this.listIterable);
	}

	@Override
	public String toString() {
		return this.listIterable.toString();
	}
}