/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

/**
 * The external form of an inverse Join column.
 *
 * @see JoinTable
 *
 * @version 2.5
 * @author Pascal Filion
 */
@SuppressWarnings("nls")
final class InverseJoinColumn extends JoinColumn {

	/**
	 * The node name used to store and retrieve the {@link Element} encapsulated by this external form.
	 */
	static final String INVERSE_JOIN_COLUMN = "inverse-join-column";

	/**
	 * Creates a new <code>InverseJoinColumn</code>.
	 *
	 * @param parent The parent of this external form
	 * @param index The position of the external form of the join column in the list of children
	 */
	InverseJoinColumn(JoinTable parent, int index) {
		super(parent, index);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return INVERSE_JOIN_COLUMN;
	}
}