/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm;

/**
 * This interface and describes the configurable properties defined for an entity listener in the
 * ORM xml. Entity listeners may be declared at the root of the ORM, on entities, or individual
 * methods may be declared on an entity itself where the class name is presumed to be the entity.
 * <p>
 * Provisional API: This interface is part of an interim API that is still under development and
 * expected to change significantly before reaching stability. It is available at this early stage
 * to solicit feedback from pioneering adopters on the understanding that any code that uses this
 * API will almost certainly be broken (repeatedly) as the API evolves.<p>
 *
 * @see javax.persistence.EntityListeners
 * @see http://jcp.org/aboutJava/communityprocess/final/jsr220/index.html, persistence specificaton
 *
 * @version 2.5
 * @author John Bracken
 */
public interface ExternalEntityListener extends ExternalForm {

	/**
	 * Returns the class name of this listener or entity.
	 */
	String getClassName();

	/**
	 * Returns the description.
	 */
	String getDescription();

	/**
	 * Returns the position of this entity listener within the list of entity listeners.
	 */
	int getIndex();

	/**
	 * Returns the post-load method name.
	 */
	String getPostLoadMethod();

	/**
	 * Returns the post-load method description
	 */
	String getPostLoadMethodDescription();

	/**
	 * Returns the post-persist method name.
	 */
	String getPostPersistMethod();

	/**
	 * Returns the post-persist method description.
	 */
	String getPostPersistMethodDescription();

	/**
	 * Returns the post-remove method name.
	 */
	String getPostRemoveMethod();

	/**
	 * Returns the post-remove method description.
	 */
	String getPostRemoveMethodDescription();

	/**
	 * Returns the post-update method name.
	 */
	String getPostUpdateMethod();

	/**
	 * Returns the post-update method description.
	 */
	String getPostUpdateMethodDescription();

	/**
	 * Returns the pre-persist method name.
	 */
	String getPrePersistMethod();

	/**
	 * Returns the pre-persist method description.
	 */
	String getPrePersistMethodDescription();

	/**
	 * Returns the pre-remove method name.
	 */
	String getPreRemoveMethod();

	/**
	 * Returns the pre-remove method description.
	 */
	String getPreRemoveMethodDescription();

	/**
	 * Returns the pre-update method name.
	 */
	String getPreUpdateMethod();

	/**
	 * Returns the pre-update method description.
	 */
	String getPreUpdateMethodDescription();

	/**
	 * Sets the class name of this listener.
	 */
	void setClassName(String name);

	/**
	 * Sets the description of this listener.
	 */
	void setDescription(String description);

	/**
	 * Sets the post-load method name.
	 */
	void setPostLoadMethod(String name);

	/**
	 * Sets the post-load method description.
	 */
	void setPostLoadMethodDescription(String name);

	/**
	 * Sets the post-persist method name.
	 */
	void setPostPersistMethod(String name);

	/**
	 * Sets the post-persist method description.
	 */
	void setPostPersistMethodDescription(String name);

	/**
	 * Sets the post-remove method name.
	 */
	void setPostRemoveMethod(String name);

	/**
	 * Sets the post-remove method description.
	 */
	void setPostRemoveMethodDescription(String name);

	/**
	 * Sets the post-update method name.
	 */
	void setPostUpdateMethod(String name);

	/**
	 * Sets the post-update method description.
	 */
	void setPostUpdateMethodDescription(String name);

	/**
	 * Sets the pre-persist method name.
	 */
	void setPrePersistMethod(String name);

	/**
	 * Sets the pre-persist method description.
	 */
	void setPrePersistMethodDescription(String name);

	/**
	 * Sets the pre-remove method name.
	 */
	void setPreRemoveMethod(String name);

	/**
	 * Sets the pre-remove method description.
	 */
	void setPreRemoveMethodDescription(String name);

	/**
	 * Sets the pre-update method name.
	 */
	void setPreUpdateMethod(String name);

	/**
	 * Sets the pre-update method description.
	 */
	void setPreUpdateMethodDescription(String name);
}