/*******************************************************************************
 * Copyright (c) 2010, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.tests.command;

import org.eclipse.persistence.tools.utility.ExceptionHandler;
import org.eclipse.persistence.tools.utility.command.AsynchronousExtendedCommandExecutor;
import org.eclipse.persistence.tools.utility.command.Command;
import org.eclipse.persistence.tools.utility.command.StatefulCommandExecutor;
import org.eclipse.persistence.tools.utility.tests.MultiThreadedTestCase;

public class AsynchronousCommandExecutorTests
	extends MultiThreadedTestCase
{
	public AsynchronousCommandExecutorTests(String name) {
		super(name);
	}

	public void testExecution() throws Exception {
		TestCommand command = new TestCommand();
		AsynchronousExtendedCommandExecutor.SimpleConfig config = new AsynchronousExtendedCommandExecutor.SimpleConfig();
		config.setThreadFactory(this.buildThreadFactory());
		config.setExceptionHandler(ExceptionHandler.Runtime.instance());
		StatefulCommandExecutor commandExecutor = new AsynchronousExtendedCommandExecutor(config);
		commandExecutor.start();
		commandExecutor.execute(command);
		commandExecutor.execute(command);
		commandExecutor.execute(command);
		Thread.sleep(TWO_TICKS);  // wait for the command to execute
		commandExecutor.stop();
		assertEquals(3, command.count);
	}

	static class TestCommand implements Command {
		int count = 0;
		@Override
		public void execute() {
			this.count++;
		}
	}
}