/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.db.relational;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.sessions.Connector;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.tools.db.relational.ELColumn;
import org.eclipse.persistence.tools.db.relational.ELLoginSpec;
import org.eclipse.persistence.tools.db.relational.ELLoginSpecHandle;
import org.eclipse.persistence.tools.db.relational.ELModel;
import org.eclipse.persistence.tools.db.relational.ELTable;
import org.eclipse.persistence.tools.db.relational.handles.MWHandle;
import org.eclipse.persistence.tools.db.relational.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.db.relational.spi.ExternalDatabase;
import org.eclipse.persistence.tools.db.relational.spi.ExternalDatabaseFactory;
import org.eclipse.persistence.tools.db.relational.spi.ExternalTableDescription;
import org.eclipse.persistence.tools.db.relational.spi.jdbc.JDBCExternalDatabaseFactory;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.utility.collection.CollectionTools;
import org.eclipse.persistence.tools.utility.collection.HashBag;
import org.eclipse.persistence.tools.utility.iterable.LiveCloneIterable;
import org.eclipse.persistence.tools.utility.iterator.ArrayIterator;
import org.eclipse.persistence.tools.utility.iterator.TransformationIterator;
import org.eclipse.persistence.tools.utility.node.Node;

public final class ELDatabase
extends ELModel {
    private volatile DatabasePlatform databasePlatform;
    public static final String DATABASE_PLATFORM_PROPERTY = "databasePlatform";
    private Collection<ELLoginSpec> loginSpecs;
    public static final String LOGIN_SPECS_COLLECTION = "loginSpecs";
    private ELLoginSpecHandle deploymentLoginSpecHandle;
    public static final String DEPLOYMENT_LOGIN_SPEC_PROPERTY = "deploymentLoginSpec";
    private ELLoginSpecHandle developmentLoginSpecHandle;
    public static final String DEVELOPMENT_LOGIN_SPEC_PROPERTY = "developmentLoginSpec";
    private Collection<ELTable> tables;
    public static final String TABLES_COLLECTION = "tables";
    private volatile ExternalDatabase externalDatabase;
    private volatile Driver driver;
    private volatile Connection connection;
    public static final String CONNECTED_PROPERTY = "connected";
    private volatile SchemaManager schemaManager;
    private volatile ExternalDatabaseFactory dbFactory;
    private Collection<String> tableNames;
    private static final String TABLE_NAMES_COLLECTION = "tableNames";
    private static final String SUB_DIRECTORY_NAME = "tables";

    public ELDatabase(DatabasePlatform databasePlatform) {
        super(null);
        this.databasePlatform = databasePlatform;
    }

    protected void checkParent(Node parentNode) {
    }

    public void initialize() {
        super.initialize();
        this.tables = new Vector<ELTable>();
    }

    protected void initialize(Node parent) {
        super.initialize(parent);
        this.loginSpecs = new Vector<ELLoginSpec>();
        this.deploymentLoginSpecHandle = new ELLoginSpecHandle(this, MWHandle.NodeReferenceScrubber.NULL_INSTANCE);
        this.developmentLoginSpecHandle = new ELLoginSpecHandle(this, MWHandle.NodeReferenceScrubber.NULL_INSTANCE);
        this.tableNames = new HashSet<String>();
    }

    public Node.Validator getValidator() {
        return new Node.Validator(){

            public void validate() {
            }

            public void resume() {
            }

            public void pause() {
            }
        };
    }

    public DatabasePlatform getDatabasePlatform() {
        return this.databasePlatform;
    }

    public void setDatabasePlatform(DatabasePlatform databasePlatform) {
        if (databasePlatform == null) {
            throw new NullPointerException();
        }
        DatabasePlatform old = this.databasePlatform;
        this.databasePlatform = databasePlatform;
        this.firePropertyChanged(DATABASE_PLATFORM_PROPERTY, (Object)old, (Object)databasePlatform);
        if (this.attributeValueHasChanged((Object)old, (Object)databasePlatform)) {
            this.databasePlatformChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void databasePlatformChanged() {
        Collection<ELTable> collection = this.tables;
        synchronized (collection) {
            for (ELTable table : this.tables) {
                table.databasePlatformChanged();
            }
        }
    }

    public Iterable<ELLoginSpec> loginSpecs() {
        return new LiveCloneIterable<ELLoginSpec>(this.loginSpecs){

            protected void remove(ELLoginSpec current) {
                ELDatabase.this.removeLoginSpec(current);
            }
        };
    }

    public int loginSpecsSize() {
        return this.loginSpecs.size();
    }

    public ELLoginSpec addLoginSpec(String loginSpecName) {
        this.checkLoginSpecName(loginSpecName);
        return this.addLoginSpec(new ELLoginSpec(this, loginSpecName));
    }

    private ELLoginSpec addLoginSpec(ELLoginSpec loginSpec) {
        this.addItemToCollection(loginSpec, this.loginSpecs, LOGIN_SPECS_COLLECTION);
        if (this.loginSpecs.size() == 1) {
            this.setDeploymentLoginSpec(loginSpec);
            this.setDevelopmentLoginSpec(loginSpec);
        }
        return loginSpec;
    }

    public void removeLoginSpec(ELLoginSpec loginSpec) {
        if (this.removeItemFromCollection(loginSpec, this.loginSpecs, LOGIN_SPECS_COLLECTION)) {
            this.loginSpecRemoved(loginSpec);
        }
    }

    public boolean containsLoginSpecNamed(String loginSpecName) {
        return this.loginSpecNamed(loginSpecName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ELLoginSpec loginSpecNamed(String loginSpecName) {
        Collection<ELLoginSpec> collection = this.loginSpecs;
        synchronized (collection) {
            for (ELLoginSpec spec : this.loginSpecs) {
                if (!spec.getName().equals(loginSpecName)) continue;
                return spec;
            }
        }
        return null;
    }

    public Iterator<String> loginSpecNames() {
        return new TransformationIterator<ELLoginSpec, String>(this.loginSpecs()){

            protected String transform(ELLoginSpec next) {
                return next.getName();
            }
        };
    }

    public ELLoginSpec getDeploymentLoginSpec() {
        return this.deploymentLoginSpecHandle.getLoginSpec();
    }

    public void setDeploymentLoginSpec(ELLoginSpec loginSpec) {
        ELLoginSpec old = this.deploymentLoginSpecHandle.getLoginSpec();
        this.deploymentLoginSpecHandle.setLoginSpec(loginSpec);
        this.firePropertyChanged(DEPLOYMENT_LOGIN_SPEC_PROPERTY, old, loginSpec);
    }

    public ELLoginSpec getDevelopmentLoginSpec() {
        return this.developmentLoginSpecHandle.getLoginSpec();
    }

    public void setDevelopmentLoginSpec(ELLoginSpec loginSpec) {
        ELLoginSpec old = this.developmentLoginSpecHandle.getLoginSpec();
        this.developmentLoginSpecHandle.setLoginSpec(loginSpec);
        this.firePropertyChanged(DEVELOPMENT_LOGIN_SPEC_PROPERTY, old, loginSpec);
    }

    public Iterable<ELTable> tables() {
        return new LiveCloneIterable<ELTable>(this.tables){

            protected void remove(ELTable current) {
                ELDatabase.this.removeTable(current);
            }
        };
    }

    public int tablesSize() {
        return this.tables.size();
    }

    public ELTable addTable(String shortName) {
        return this.addTable(null, shortName);
    }

    public ELTable addTable(String schema, String shortName) {
        return this.addTable(null, schema, shortName);
    }

    public ELTable addTable(String catalog, String schema, String shortName) {
        this.checkTableName(catalog, schema, shortName, null);
        return this.addTable(new ELTable(this, catalog, schema, shortName));
    }

    public ELTable addTableWithFullyQualifiedName(String fullyQualifiedName) {
        HashBag strings = CollectionTools.collection((Object[])fullyQualifiedName.split("\\."));
        CollectionTools.removeAllOccurrences((Collection)strings, (Object)"");
        String[] parsedName = strings.toArray(new String[strings.size()]);
        if (parsedName.length == 3) {
            return this.addTable(parsedName[0], parsedName[1], parsedName[2]);
        }
        if (parsedName.length == 2) {
            return this.addTable(parsedName[0], parsedName[1]);
        }
        return this.addTable(parsedName[0]);
    }

    private ELTable addTable(ELTable table) {
        this.addItemToCollection(table, this.tables, "tables");
        return table;
    }

    public void removeTable(ELTable table) {
        this.removeNodeFromCollection(table, this.tables, "tables");
    }

    public boolean containsTableNamed(String catalog, String schema, String shortName) {
        return this.tableNamed(catalog, schema, shortName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ELTable tableNamed(String catalog, String schema, String shortName) {
        Collection<ELTable> collection = this.tables;
        synchronized (collection) {
            for (ELTable table : this.tables) {
                if (!table.nameMatches(catalog, schema, shortName)) continue;
                return table;
            }
        }
        return null;
    }

    public boolean containsTableNamedIgnoreCase(String catalog, String schema, String shortName) {
        return this.tableNamedIgnoreCase(catalog, schema, shortName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ELTable tableNamedIgnoreCase(String catalog, String schema, String shortName) {
        Collection<ELTable> collection = this.tables;
        synchronized (collection) {
            for (ELTable table : this.tables) {
                if (!table.nameMatchesIgnoreCase(catalog, schema, shortName)) continue;
                return table;
            }
        }
        return null;
    }

    public boolean containsTableNamed(String qualifiedName) {
        return this.tableNamed(qualifiedName) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ELTable tableNamed(String qualifiedName) {
        Collection<ELTable> collection = this.tables;
        synchronized (collection) {
            for (ELTable table : this.tables) {
                if (!table.qualifiedName().equals(qualifiedName)) continue;
                return table;
            }
        }
        return null;
    }

    public Iterator<String> tableNames() {
        return new TransformationIterator<ELTable, String>(this.tables()){

            protected String transform(ELTable next) {
                return next.getName();
            }
        };
    }

    public ELColumn columnNamed(String qualifiedName) {
        ELTable table = this.tableNamed(ELColumn.parseTableNameFromQualifiedName(qualifiedName));
        if (table == null) {
            return null;
        }
        return table.columnNamed(ELColumn.parseColumnNameFromQualifiedName(qualifiedName));
    }

    public ExternalDatabase getExternalDatabase() {
        if (this.externalDatabase == null) {
            this.externalDatabase = this.buildExternalDatabase();
        }
        return this.externalDatabase;
    }

    private ExternalDatabase buildExternalDatabase() {
        return this.externalDatabaseFactory().buildDatabase(this.connection);
    }

    private ExternalDatabaseFactory getExternalDatabaseFactory() {
        if (this.dbFactory == null) {
            this.dbFactory = new JDBCExternalDatabaseFactory();
        }
        return this.dbFactory;
    }

    public boolean isConnected() {
        return this.connection != null;
    }

    private SchemaManager getSchemaManager() {
        if (this.schemaManager == null) {
            throw new IllegalStateException("not connected");
        }
        return this.schemaManager;
    }

    private ExternalDatabaseFactory externalDatabaseFactory() {
        return this.getExternalDatabaseFactory();
    }

    boolean supportsIdentityClause() {
        return this.databasePlatform.supportsIdentityClause();
    }

    protected void addTransientAspectNamesTo(Set<String> transientAspectNames) {
        super.addTransientAspectNamesTo(transientAspectNames);
        transientAspectNames.add(CONNECTED_PROPERTY);
    }

    void checkLoginSpecName(String loginSpecName) {
        if (loginSpecName == null || loginSpecName.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (this.containsLoginSpecNamed(loginSpecName)) {
            throw new IllegalArgumentException("duplicate login spec name: " + loginSpecName);
        }
    }

    void checkTableName(String catalog, String schema, String shortName, ELTable table) {
        this.checkTableNameQualifier(catalog);
        this.checkTableNameQualifier(schema);
        if (shortName == null || shortName.length() == 0) {
            throw new IllegalArgumentException();
        }
        ELTable match = this.tableNamed(catalog, schema, shortName);
        if (match != null) {
            throw new IllegalArgumentException("duplicate table name: " + match.qualifiedName());
        }
        ELTable matchIgnoreCase = this.tableNamedIgnoreCase(catalog, schema, shortName);
        if (matchIgnoreCase != null && matchIgnoreCase != table) {
            throw new IllegalArgumentException("duplicate table name: " + matchIgnoreCase.qualifiedName());
        }
    }

    private void checkTableNameQualifier(String qualifier) {
        if (qualifier == null) {
            return;
        }
        if (qualifier.length() == 0) {
            throw new IllegalArgumentException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildrenTo(List<Node> children) {
        super.addChildrenTo(children);
        Collection<ELModel> collection = this.loginSpecs;
        synchronized (collection) {
            children.addAll(this.loginSpecs);
        }
        children.add(this.deploymentLoginSpecHandle);
        children.add(this.developmentLoginSpecHandle);
        collection = this.tables;
        synchronized (collection) {
            children.addAll(this.tables);
        }
    }

    private void loginSpecRemoved(ELLoginSpec loginSpec) {
        if (this.getDeploymentLoginSpec() == loginSpec) {
            this.setDeploymentLoginSpec(null);
        }
        if (this.getDevelopmentLoginSpec() == loginSpec) {
            this.setDevelopmentLoginSpec(null);
        }
    }

    public void nodeRemoved(Node node) {
        if (node.isDescendantOf((Node)this)) {
            super.nodeRemoved(node);
        }
    }

    public void nodeRenamed(Node node) {
        if (node.isDescendantOf((Node)this)) {
            super.nodeRenamed(node);
        }
    }

    public void login() throws SQLException, ClassNotFoundException {
        String password;
        if (this.isConnected()) {
            throw new IllegalStateException("already connected");
        }
        ELLoginSpec loginSpec = this.getDevelopmentLoginSpec();
        if (loginSpec == null) {
            throw new IllegalStateException("missing development login spec");
        }
        try {
            this.driver = loginSpec.buildDriver();
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        String url = loginSpec.getURL();
        if (url == null || url.length() == 0) {
            throw new IllegalStateException("missing database URL");
        }
        Properties props = new Properties();
        String userName = loginSpec.getUserName();
        if (userName != null) {
            props.put("user", userName);
        }
        if ((password = loginSpec.getPassword()) != null) {
            props.put("password", password);
        }
        this.connection = this.driver.connect(url, props);
        this.schemaManager = this.buildSchemaManager();
        this.firePropertyChanged(CONNECTED_PROPERTY, false, true);
    }

    public void logout() throws SQLException {
        if (!this.isConnected()) {
            throw new IllegalStateException("not connected");
        }
        this.connection.close();
        this.schemaManager = null;
        this.connection = null;
        this.driver = null;
        this.externalDatabase = null;
        this.firePropertyChanged(CONNECTED_PROPERTY, true, false);
    }

    private SchemaManager buildSchemaManager() {
        return new SchemaManager(this.buildRuntimeDatabaseSession());
    }

    private DatabaseSession buildRuntimeDatabaseSession() {
        DatabaseSession session = this.buildRuntimeProject().createDatabaseSession();
        session.dontLogMessages();
        session.login();
        return session;
    }

    private Project buildRuntimeProject() {
        return new Project(this.getDevelopmentLoginSpec().buildDevelopmentRuntimeDatabaseLogin());
    }

    Connector buildRuntimeConnector() {
        return new LocalConnectorAdapter(this.connection);
    }

    public Iterator<String> catalogNames() {
        return new ArrayIterator((Object[])this.getExternalDatabase().getCatalogNames());
    }

    public Iterator<String> schemaNames() {
        if (!this.getDatabasePlatform().getName().equals("MySQL")) {
            return new ArrayIterator((Object[])this.getExternalDatabase().getSchemaNames());
        }
        return new ArrayIterator((Object[])this.getExternalDatabase().getCatalogNames());
    }

    public Iterator<String> tableTypeNames() {
        return new ArrayIterator((Object[])this.getExternalDatabase().getTableTypeNames());
    }

    public Iterator<ExternalTableDescription> externalTableDescriptions(String catalog, String schemaPattern, String tableNamePattern, String[] types) {
        return new ArrayIterator((Object[])this.getExternalDatabase().getTableDescriptions(catalog, schemaPattern, tableNamePattern, types));
    }

    public Iterator<ExternalTableDescription> externalTableDescriptions() {
        return new ArrayIterator((Object[])this.getExternalDatabase().getTableDescriptions());
    }

    public void importQualifiedTablesFor(Collection<ExternalTableDescription> externalTableDescriptions) {
        for (ExternalTableDescription externalTableDescription : externalTableDescriptions) {
            this.qualifiedTableFor(externalTableDescription).refreshColumns(externalTableDescription.getTable());
        }
        for (ExternalTableDescription externalTableDescription : externalTableDescriptions) {
            this.qualifiedTableFor(externalTableDescription).refreshReferences(externalTableDescription.getTable());
        }
    }

    public void refreshQualifiedTablesFor(Collection<ExternalTableDescription> externalTableDescriptions) {
        ELTable tableToRefresh;
        for (ExternalTableDescription externalTableDescription : externalTableDescriptions) {
            tableToRefresh = this.tableNamed(externalTableDescription.getQualifiedName());
            if (tableToRefresh == null) {
                tableToRefresh = this.tableNamed(externalTableDescription.getName());
            }
            if (tableToRefresh == null) continue;
            tableToRefresh.refreshColumns(externalTableDescription.getTable());
        }
        for (ExternalTableDescription externalTableDescription : externalTableDescriptions) {
            tableToRefresh = this.tableNamed(externalTableDescription.getQualifiedName());
            if (tableToRefresh == null) {
                tableToRefresh = this.tableNamed(externalTableDescription.getName());
            }
            if (tableToRefresh == null) continue;
            tableToRefresh.refreshReferences(externalTableDescription.getTable());
        }
    }

    private ELTable qualifiedTableFor(ExternalTableDescription externalTableDescription) {
        if (this.getDatabasePlatform().getName().equals("MySQL")) {
            return this.tableNamedForImport(null, externalTableDescription.getCatalogName(), externalTableDescription.getName());
        }
        return this.tableNamedForImport(externalTableDescription.getCatalogName(), externalTableDescription.getSchemaName(), externalTableDescription.getName());
    }

    private ELTable tableNamedForImport(String catalog, String schema, String shortName) {
        ELTable table = this.tableNamed(catalog, schema, shortName);
        if (table == null) {
            table = this.addTable(catalog, schema, shortName);
        }
        return table;
    }

    public void importUnqualifiedTablesFor(Collection<ExternalTableDescription> externalTableDescriptions) {
        for (ExternalTableDescription externalTableDescription : externalTableDescriptions) {
            this.unqualifiedTableFor(externalTableDescription).refreshColumns(externalTableDescription.getTable());
        }
        for (ExternalTableDescription externalTableDescription : externalTableDescriptions) {
            this.unqualifiedTableFor(externalTableDescription).refreshReferences(externalTableDescription.getTable());
        }
    }

    private ELTable unqualifiedTableFor(ExternalTableDescription externalTableDescription) {
        return this.tableNamedForImport(null, null, externalTableDescription.getName());
    }

    public void toString(StringBuffer sb) {
        sb.append(this.getDatabasePlatform().getName());
        sb.append(" : ");
        sb.append(this.tables.size());
        sb.append(" tables");
    }

    @Override
    public String displayString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Database (");
        sb.append(this.getDatabasePlatform().getName());
        sb.append(")");
        return sb.toString();
    }

    public Iterable projectSubFileComponents() {
        return this.tables();
    }

    public void setProjectSubFileComponents(Collection subComponents) {
        this.tables = subComponents;
    }

    public Iterator originalProjectSubFileComponentNames() {
        return this.tableNames.iterator();
    }

    public void setOriginalProjectSubFileComponentNames(Collection originalSubComponentNames) {
        this.tableNames = originalSubComponentNames;
    }

    public boolean hasChangedMainProjectSaveFile() {
        if (this.isDirty()) {
            return true;
        }
        Iterator stream = this.children();
        while (stream.hasNext()) {
            if (!this.childHasChangedTheProjectSaveFile(stream.next())) continue;
            return true;
        }
        return false;
    }

    private boolean childHasChangedTheProjectSaveFile(Object child) {
        if (this.tables.contains(child)) {
            return false;
        }
        return ((Node)child).isDirtyBranch();
    }

    private static class LocalConnectorAdapter
    implements Connector {
        private Connection connection;

        LocalConnectorAdapter(Connection connection) {
            this.connection = connection;
        }

        public Connection connect(Properties properties, Session session) {
            return this.connection;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError();
            }
        }

        public String getConnectionDetails() {
            return "MWDatabase.LocalConnectorAdapter";
        }

        public void toString(PrintWriter writer) {
            writer.print(this.getConnectionDetails());
        }
    }
}

