/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.tools.mapping.orm.ExternalConversionValue;
import org.eclipse.persistence.tools.mapping.orm.dom.AbstractExternalForm;
import org.eclipse.persistence.tools.mapping.orm.dom.ObjectTypeConverter;
import org.w3c.dom.Element;

final class ConversionValue
extends AbstractExternalForm
implements ExternalConversionValue {
    private int index;
    static final String CONVERSION_VALUE = "conversion-value";
    static final String DATA_VALUE = "data-value";
    static final String OBJECT_VALUE = "object-value";

    ConversionValue(ObjectTypeConverter parent, int index) {
        super(parent);
        this.index = index;
    }

    @Override
    protected Element addSelf(String elementName, List<String> elementNamesOrder) {
        if (this.index == -1) {
            return super.addSelf(elementName, elementNamesOrder);
        }
        return this.addChild(this.getParent(), elementName, this.index, elementNamesOrder);
    }

    @Override
    protected List<String> buildAttributeNamesOrder() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(DATA_VALUE);
        names.add(OBJECT_VALUE);
        return names;
    }

    @Override
    public String getDataValue() {
        return this.getAttribute(DATA_VALUE);
    }

    @Override
    public Element getElement() {
        if (this.index == -1) {
            return super.getElement();
        }
        return this.getChild(this.getParent(), this.getElementName(), this.index);
    }

    @Override
    protected String getElementName() {
        return CONVERSION_VALUE;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getObjectValue() {
        return this.getAttribute(OBJECT_VALUE);
    }

    @Override
    public void removeSelf() {
        if (this.index == -1) {
            super.removeSelf();
        } else {
            this.removeChild(this.getParent(), this.getElementName(), this.index);
        }
    }

    @Override
    public void setDataValue(String value) {
        this.setAttribute(DATA_VALUE, value);
    }

    @Override
    public void setIndex(int value) {
        this.index = value;
    }

    @Override
    public void setObjectValue(String value) {
        this.setAttribute(OBJECT_VALUE, value);
    }
}

