/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.model.value;

import org.eclipse.persistence.tools.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.persistence.tools.utility.model.value.PropertyValueModelWrapper;

public class CachingPropertyValueModelWrapper<V>
extends PropertyValueModelWrapper<V>
implements ModifiablePropertyValueModel<V> {
    protected volatile V value;

    public CachingPropertyValueModelWrapper(ModifiablePropertyValueModel<V> valueModel) {
        super(valueModel);
    }

    @Override
    public V getValue() {
        return this.value;
    }

    @Override
    public void setValue(V value) {
        this.value = value;
        this.getValueModel().setValue(value);
    }

    @Override
    protected void wrappedValueChanged(V oldValue, V newValue) {
        V old = this.value;
        this.value = newValue;
        this.firePropertyChanged("value", old, this.value);
    }

    protected ModifiablePropertyValueModel<V> getValueModel() {
        return (ModifiablePropertyValueModel)this.valueModel;
    }

    @Override
    public void toString(StringBuilder sb) {
        sb.append(this.value);
    }

    @Override
    protected void engageModel() {
        super.engageModel();
        this.value = this.valueModel.getValue();
    }

    @Override
    protected void disengageModel() {
        this.value = null;
        super.disengageModel();
    }
}

