/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import junit.framework.Test;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.ComplexQueryResult;
import org.eclipse.persistence.queries.Cursor;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.MethodBaseQueryRedirector;
import org.eclipse.persistence.queries.QueryRedirector;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.ScrollableCursorPolicy;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmployeePopulator;
import org.eclipse.persistence.testing.models.employee.domain.LargeProject;
import org.eclipse.persistence.testing.models.employee.domain.Project;
import org.eclipse.persistence.testing.tests.clientserver.ServerSessionTestAdapter;
import org.eclipse.persistence.testing.tests.queries.BadQueryTest;
import org.eclipse.persistence.testing.tests.queries.CachedUpdateCallsQueryClearTest;
import org.eclipse.persistence.testing.tests.queries.CascadeNoBindingOnQuery;
import org.eclipse.persistence.testing.tests.queries.CascadingAllCacheTest;
import org.eclipse.persistence.testing.tests.queries.CascadingAllNoCacheTest;
import org.eclipse.persistence.testing.tests.queries.CascadingNoneCacheTest;
import org.eclipse.persistence.testing.tests.queries.CascadingNoneNoCacheTest;
import org.eclipse.persistence.testing.tests.queries.CascadingPrivateCacheTest;
import org.eclipse.persistence.testing.tests.queries.CascadingPrivateNoCacheTest;
import org.eclipse.persistence.testing.tests.queries.CollectionReadAllTest;
import org.eclipse.persistence.testing.tests.queries.ConformResultsAcrossOneToManyAcrossOneToOneTest;
import org.eclipse.persistence.testing.tests.queries.ConformResultsAcrossOneToManyTest;
import org.eclipse.persistence.testing.tests.queries.ConformResultsAcrossOneToOneTest;
import org.eclipse.persistence.testing.tests.queries.ConformResultsAcrossWrappedOneToManyTest;
import org.eclipse.persistence.testing.tests.queries.ConformResultsPerformanceTest;
import org.eclipse.persistence.testing.tests.queries.ConformResultsRedirectorTest;
import org.eclipse.persistence.testing.tests.queries.ConformResultsSubclassesTest;
import org.eclipse.persistence.testing.tests.queries.ConformResultsWithMultitableAndJoiningTest;
import org.eclipse.persistence.testing.tests.queries.ConformResultsWithPrimaryKeyExpressionTest;
import org.eclipse.persistence.testing.tests.queries.ConformResultsWithSelectionObjectTest;
import org.eclipse.persistence.testing.tests.queries.ConformingShouldTriggerIndirectionTest;
import org.eclipse.persistence.testing.tests.queries.ConformingThrowConformExceptionsTest;
import org.eclipse.persistence.testing.tests.queries.CursoredStreamAnyOfTest;
import org.eclipse.persistence.testing.tests.queries.CursoredStreamClientSessionTest;
import org.eclipse.persistence.testing.tests.queries.CursoredStreamConformingTest;
import org.eclipse.persistence.testing.tests.queries.CursoredStreamCustomSQLTest;
import org.eclipse.persistence.testing.tests.queries.CursoredStreamDistinctTest;
import org.eclipse.persistence.testing.tests.queries.CursoredStreamReadWriteClientSessionTest;
import org.eclipse.persistence.testing.tests.queries.CursoredStreamReleaseConnectionsTest;
import org.eclipse.persistence.testing.tests.queries.CursoredStreamTest;
import org.eclipse.persistence.testing.tests.queries.CursoredStreamWithUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.queries.CursoredStreamWithUselessConformTest;
import org.eclipse.persistence.testing.tests.queries.DataReadQueryContainerPolicyTest;
import org.eclipse.persistence.testing.tests.queries.DataReadQueryTest1;
import org.eclipse.persistence.testing.tests.queries.DeepDeleteTest;
import org.eclipse.persistence.testing.tests.queries.DeepModifyTest;
import org.eclipse.persistence.testing.tests.queries.DeepRefreshTest;
import org.eclipse.persistence.testing.tests.queries.DeleteAllQueryTest;
import org.eclipse.persistence.testing.tests.queries.DeleteObjectPrivatelyOwningUntriggeredIndirection;
import org.eclipse.persistence.testing.tests.queries.DirectReadQueryTest1;
import org.eclipse.persistence.testing.tests.queries.DoNotRedirectDefaultRedirectorTest;
import org.eclipse.persistence.testing.tests.queries.DoesExistTest;
import org.eclipse.persistence.testing.tests.queries.DontMaintainCacheTest;
import org.eclipse.persistence.testing.tests.queries.FirstResultAndMaxRowsTest;
import org.eclipse.persistence.testing.tests.queries.FourPartialAttributeTestsWithJoinAttribute;
import org.eclipse.persistence.testing.tests.queries.GetTableGetFieldTest;
import org.eclipse.persistence.testing.tests.queries.GetValueFromObject;
import org.eclipse.persistence.testing.tests.queries.IncorrectPartialAttributeTest;
import org.eclipse.persistence.testing.tests.queries.InheritancePrepareTest;
import org.eclipse.persistence.testing.tests.queries.InheritanceViewPrepareTest;
import org.eclipse.persistence.testing.tests.queries.Jdk12ScrollableCursorTest;
import org.eclipse.persistence.testing.tests.queries.MapReadAllTest;
import org.eclipse.persistence.testing.tests.queries.MultipleOrderByWithSameFieldNameNullsFirstTest;
import org.eclipse.persistence.testing.tests.queries.MultipleOrderByWithSameFieldNameTest;
import org.eclipse.persistence.testing.tests.queries.NamedQueriesClientSessionTest;
import org.eclipse.persistence.testing.tests.queries.NamedQueriesDescriptorQueryManagerTest;
import org.eclipse.persistence.testing.tests.queries.NamedQueriesUOWTest;
import org.eclipse.persistence.testing.tests.queries.NamedQueryGetQueryNoArgumentsTest;
import org.eclipse.persistence.testing.tests.queries.NamedQueryNotFoundInUOWTest;
import org.eclipse.persistence.testing.tests.queries.OneToManyMaxRowsSettingTest;
import org.eclipse.persistence.testing.tests.queries.OnlyRefreshIfNewTest;
import org.eclipse.persistence.testing.tests.queries.OrderingByExpressionTest;
import org.eclipse.persistence.testing.tests.queries.OrderingMutipleTableTest;
import org.eclipse.persistence.testing.tests.queries.OrderingSuperClassTest;
import org.eclipse.persistence.testing.tests.queries.OrderingTest;
import org.eclipse.persistence.testing.tests.queries.OrderingWithAnyOfTest;
import org.eclipse.persistence.testing.tests.queries.PartialAttributeDistinctOrderByTest;
import org.eclipse.persistence.testing.tests.queries.PartialAttributeTestWithJoinAttribute;
import org.eclipse.persistence.testing.tests.queries.PartialAttributeWithCustomSQLTest;
import org.eclipse.persistence.testing.tests.queries.PessimisticLockBatchAttributeTest;
import org.eclipse.persistence.testing.tests.queries.PessimisticLockEmptyTransactionTest;
import org.eclipse.persistence.testing.tests.queries.PessimisticLockFineGrainedTest;
import org.eclipse.persistence.testing.tests.queries.PessimisticLockIndirectionJoiningTest;
import org.eclipse.persistence.testing.tests.queries.PessimisticLockInheritanceTest;
import org.eclipse.persistence.testing.tests.queries.PessimisticLockJoinedAttributeTest;
import org.eclipse.persistence.testing.tests.queries.PessimisticLockNoLockJoinedTest;
import org.eclipse.persistence.testing.tests.queries.PessimisticLockOutsideUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.queries.PessimisticLockRefreshTest;
import org.eclipse.persistence.testing.tests.queries.PessimisticLockTest;
import org.eclipse.persistence.testing.tests.queries.PredefinedInQueryReadAllTest;
import org.eclipse.persistence.testing.tests.queries.PredefinedQueryInheritanceTest;
import org.eclipse.persistence.testing.tests.queries.PredefinedQueryLikeIgnoreCaseTest;
import org.eclipse.persistence.testing.tests.queries.PredefinedQueryReadAllTest;
import org.eclipse.persistence.testing.tests.queries.PredefinedQueryReadObjectTest;
import org.eclipse.persistence.testing.tests.queries.PredefinedQueryTest;
import org.eclipse.persistence.testing.tests.queries.PredefinedQueryToUpperOnParameterTest;
import org.eclipse.persistence.testing.tests.queries.PrivateDeleteTest;
import org.eclipse.persistence.testing.tests.queries.PrivateModifyTest;
import org.eclipse.persistence.testing.tests.queries.QBEExcludedValues;
import org.eclipse.persistence.testing.tests.queries.QBEObjectWithAllFieldsFilled;
import org.eclipse.persistence.testing.tests.queries.QBESpecialOperators;
import org.eclipse.persistence.testing.tests.queries.QueryByExampleInUOWTest;
import org.eclipse.persistence.testing.tests.queries.QueryCacheTest;
import org.eclipse.persistence.testing.tests.queries.QueryExceptionStringTest;
import org.eclipse.persistence.testing.tests.queries.QueryExecutionTimeSetOnBuildObjectTest;
import org.eclipse.persistence.testing.tests.queries.QueryTimeoutConnectionReleasedTest;
import org.eclipse.persistence.testing.tests.queries.QueryTimeoutTest;
import org.eclipse.persistence.testing.tests.queries.ReadAllNoDistinctTest;
import org.eclipse.persistence.testing.tests.queries.RedirectQueryOnUOWTest;
import org.eclipse.persistence.testing.tests.queries.RedirectorOnDescriptorTest;
import org.eclipse.persistence.testing.tests.queries.RefreshNoCacheWithNoIdentityMapTest;
import org.eclipse.persistence.testing.tests.queries.RefreshTest;
import org.eclipse.persistence.testing.tests.queries.RefreshWithCheckCacheOnlyTest;
import org.eclipse.persistence.testing.tests.queries.ReloadSelectionObjectTest;
import org.eclipse.persistence.testing.tests.queries.ScrollableCursorAPITest;
import org.eclipse.persistence.testing.tests.queries.ScrollableCursorBackwardReadingTest;
import org.eclipse.persistence.testing.tests.queries.ScrollableCursorForwardOnlyResultSetTest;
import org.eclipse.persistence.testing.tests.queries.ScrollableCursorJoinedAttributeTest;
import org.eclipse.persistence.testing.tests.queries.ScrollableCursorJoiningVerificationTest;
import org.eclipse.persistence.testing.tests.queries.ScrollableCursorNavigationAPITest;
import org.eclipse.persistence.testing.tests.queries.ScrollableCursorStatementCachingReadTest;
import org.eclipse.persistence.testing.tests.queries.ScrollableCursorTest;
import org.eclipse.persistence.testing.tests.queries.ServerClientNamedQueryTest;
import org.eclipse.persistence.testing.tests.queries.SetReferenceClassTest;
import org.eclipse.persistence.testing.tests.queries.ShallowModifyTest;
import org.eclipse.persistence.testing.tests.queries.ShallowRefreshTest;
import org.eclipse.persistence.testing.tests.queries.ShouldRegisterResultsInUnitOfWorkTest;
import org.eclipse.persistence.testing.tests.queries.TranslatedStringsTest;
import org.eclipse.persistence.testing.tests.queries.UOWgetQueryTest;
import org.eclipse.persistence.testing.tests.queries.UpdateAllQueryExpressionMathTest;
import org.eclipse.persistence.testing.tests.queries.UpdateAllQueryRollbackTest;
import org.eclipse.persistence.testing.tests.queries.UpdateAllQueryTest;
import org.eclipse.persistence.testing.tests.queries.UpdateAllQueryUOWTest;
import org.eclipse.persistence.testing.tests.queries.ValueReadQueryTest1;
import org.eclipse.persistence.testing.tests.queries.ZeroPrimaryKeyExistenceCheckTest;
import org.eclipse.persistence.tools.schemaframework.PopulationManager;

public class QueryFrameworkTestSuite
extends TestSuite {
    public QueryFrameworkTestSuite() {
        this.setDescription("This suite tests all of the functionality of the query framework.");
    }

    public QueryFrameworkTestSuite(boolean isSRG) {
        super(isSRG);
        this.setDescription("This suite tests all of the functionality of the query framework.");
    }

    public void addTests() {
        this.addSRGTests();
        this.addTest((Test)new QueryTimeoutTest());
        this.addTest((Test)new ServerSessionTestAdapter(new PessimisticLockNoLockJoinedTest()));
        this.addTest((Test)new ReadAllNoDistinctTest());
        this.addTest((Test)new PartialAttributeTestWithJoinAttribute());
        this.addTest((Test)new PartialAttributeDistinctOrderByTest());
        this.addTest((Test)new FourPartialAttributeTestsWithJoinAttribute());
        this.addTest((Test)this.buildReadOnlyQueryTest());
        this.addTest((Test)this.buildGetSQLTest());
        this.addTest((Test)this.buildJoinSubclassesQueryTest());
        this.addTest((Test)this.buildRecordTest());
        this.addTest((Test)new ConformResultsWithMultitableAndJoiningTest());
        this.addTest((Test)new CachedUpdateCallsQueryClearTest());
        this.addTest((Test)new ZeroPrimaryKeyExistenceCheckTest(true));
        this.addTest((Test)new ZeroPrimaryKeyExistenceCheckTest(false));
        this.addTest((Test)new QueryTimeoutConnectionReleasedTest());
        this.addTest((Test)new QueryExecutionTimeSetOnBuildObjectTest());
        this.addTest((Test)new PartialAttributeWithCustomSQLTest());
        this.addTest((Test)this.buildArgumentValuesTest());
        this.addTest((Test)new ScrollableCursorForwardOnlyResultSetTest());
        this.addTest((Test)new ConformResultsSubclassesTest());
        this.addTest((Test)new ScrollableCursorJoinedAttributeTest());
        this.addTest((Test)new ScrollableCursorJoiningVerificationTest());
        this.addTest((Test)new MultipleOrderByWithSameFieldNameNullsFirstTest());
        this.addTest((Test)new MultipleOrderByWithSameFieldNameTest());
        this.addTest((Test)this.buildUnionTest());
    }

    public void addSRGTests() {
        ReadAllQuery raq2 = new ReadAllQuery();
        raq2.setReferenceClass(Employee.class);
        raq2.useCollectionClass(ArrayList.class);
        this.addTest((Test)new CollectionReadAllTest(Employee.class, 12, raq2));
        ReadAllQuery raq3 = new ReadAllQuery();
        raq3.setReferenceClass(Employee.class);
        raq3.useCollectionClass(Vector.class);
        this.addTest((Test)new CollectionReadAllTest(Employee.class, 12, raq3));
        ReadAllQuery raq4 = new ReadAllQuery();
        raq4.setReferenceClass(Employee.class);
        raq4.useCollectionClass(HashSet.class);
        this.addTest((Test)new CollectionReadAllTest(Employee.class, 12, raq4));
        ReadAllQuery raq6 = new ReadAllQuery();
        raq6.setReferenceClass(Employee.class);
        raq6.useMapClass(HashMap.class, "getFirstName");
        this.addTest((Test)new CollectionReadAllTest(Employee.class, 12, raq6));
        ReadAllQuery raq9 = new ReadAllQuery();
        raq9.setReferenceClass(Employee.class);
        raq9.useMapClass(Hashtable.class, "getId");
        this.addTest((Test)new CollectionReadAllTest(Employee.class, 12, raq9));
        ReadAllQuery raq10 = new ReadAllQuery();
        raq10.setReferenceClass(Employee.class);
        raq10.useCollectionClass(ArrayList.class);
        this.addTest((Test)new CollectionReadAllTest(Employee.class, 12, raq10));
        ReadAllQuery raq20 = new ReadAllQuery();
        raq20.setReferenceClass(Employee.class);
        raq20.useMapClass(Hashtable.class, "getFirstName");
        this.addTest((Test)new MapReadAllTest(Employee.class, 12, raq20));
        ReadAllQuery raq21 = new ReadAllQuery();
        raq21.setReferenceClass(Employee.class);
        raq21.useMapClass(TreeMap.class, "getId");
        this.addTest((Test)new MapReadAllTest(Employee.class, 12, raq21));
        this.addTest((Test)new RefreshNoCacheWithNoIdentityMapTest());
        this.addTest((Test)new ShallowModifyTest());
        this.addTest((Test)new DontMaintainCacheTest());
        this.addTest((Test)new CursoredStreamTest(Employee.class, new ExpressionBuilder().get("address").get("city").equal((Object)"Ottawa")));
        this.addTest((Test)new CursoredStreamTest(Employee.class, new ExpressionBuilder().get("firstName").like("B%")));
        this.addTest((Test)new CursoredStreamTest(LargeProject.class, new ExpressionBuilder().get("teamLeader").get("firstName").like("Sarah%")));
        this.addTest((Test)new CursoredStreamWithUselessConformTest(Employee.class, new ExpressionBuilder().get("address").get("city").equal((Object)"Ottawa")));
        this.addTest((Test)new CursoredStreamWithUselessConformTest(Employee.class, new ExpressionBuilder().get("firstName").like("B%")));
        this.addTest((Test)new CursoredStreamWithUselessConformTest(LargeProject.class, new ExpressionBuilder().get("teamLeader").get("firstName").like("Sarah%")));
        this.addTest((Test)new CursoredStreamCustomSQLTest());
        this.addTest((Test)new CursoredStreamAnyOfTest());
        this.addTest((Test)new CursoredStreamWithUnitOfWorkTest());
        this.addTest((Test)new CursoredStreamDistinctTest());
        this.addTest((Test)new CursoredStreamReleaseConnectionsTest(false));
        this.addTest((Test)new CursoredStreamReleaseConnectionsTest(true));
        this.addTest((Test)new ScrollableCursorTest(Employee.class, new ExpressionBuilder().get("firstName").like("B%")));
        this.addTest((Test)new ScrollableCursorTest(LargeProject.class, new ExpressionBuilder().get("teamLeader").get("firstName").like("Sarah%")));
        this.addTest((Test)new ScrollableCursorAPITest());
        this.addTest((Test)new ScrollableCursorBackwardReadingTest());
        this.addTest((Test)new ScrollableCursorStatementCachingReadTest());
        this.addTest((Test)new ScrollableCursorNavigationAPITest());
        this.addTest((Test)new CursoredStreamConformingTest());
        this.addTest((Test)new CursoredStreamConformingTest(true));
        this.addTest((Test)new ScrollableCursorBackwardReadingTest(true));
        this.addTest((Test)new ScrollableCursorNavigationAPITest(true));
        this.addTest((Test)new OrderingTest());
        this.addTest((Test)new OrderingMutipleTableTest());
        this.addTest((Test)new OrderingSuperClassTest());
        this.addTest((Test)new OrderingByExpressionTest());
        this.addTest((Test)new OrderingWithAnyOfTest());
        this.addTest((Test)new ShallowRefreshTest());
        this.addTest((Test)new RefreshTest());
        this.addTest((Test)new PessimisticLockTest(1));
        this.addTest((Test)new PessimisticLockTest(2));
        this.addTest((Test)new PessimisticLockFineGrainedTest(2));
        this.addTest((Test)new PessimisticLockOutsideUnitOfWorkTest(2));
        this.addTest((Test)new PessimisticLockInheritanceTest(2));
        this.addTest((Test)new ServerSessionTestAdapter(new PessimisticLockJoinedAttributeTest()));
        this.addTest((Test)new ServerSessionTestAdapter(new PessimisticLockBatchAttributeTest()));
        this.addTest((Test)new PessimisticLockEmptyTransactionTest());
        this.addTest((Test)new PessimisticLockIndirectionJoiningTest(2));
        this.addTest((Test)new PessimisticLockRefreshTest(2));
        this.addTest((Test)new OnlyRefreshIfNewTest());
        this.addTest((Test)new DeepRefreshTest());
        this.addTest((Test)new PredefinedQueryReadAllTest(Employee.class, 12));
        this.addTest((Test)new PredefinedInQueryReadAllTest(Employee.class, 1));
        this.addTest((Test)new PredefinedQueryReadObjectTest(PopulationManager.getDefaultManager().getObject(Employee.class, "0001")));
        this.addTest((Test)new PredefinedQueryLikeIgnoreCaseTest());
        this.addTest((Test)this.buildPredefinedObjectComparisonTest());
        this.addTest((Test)this.buildPredefinedInTest());
        this.addTest((Test)this.buildPredefinedEqualNullTest());
        this.addTest((Test)this.buildPredefinedContainsSubStringTest());
        this.addTest((Test)this.buildPredefinedAnyOfObjectComparisonTest());
        this.addTest((Test)this.buildPredefinedObjectTypeTest());
        this.addTest((Test)this.buildPredefinedNestedParameterTest());
        this.addTest((Test)this.buildPredefinedRedirectorTest());
        this.addTest((Test)this.buildPredefinedMethodRedirectorTest());
        this.addTest((Test)new PredefinedQueryInheritanceTest());
        this.addTest((Test)new PredefinedQueryToUpperOnParameterTest(PopulationManager.getDefaultManager().getObject(Employee.class, "0001")));
        this.addTest((Test)new ReloadSelectionObjectTest(new EmployeePopulator().basicEmployeeExample1(), true));
        this.addTest((Test)new ReloadSelectionObjectTest(new EmployeePopulator().basicEmployeeExample1(), false));
        this.addTest((Test)new BadQueryTest());
        this.addTest((Test)new Jdk12ScrollableCursorTest());
        this.addTest((Test)new RefreshWithCheckCacheOnlyTest());
        this.addTest((Test)new CascadingAllCacheTest());
        this.addTest((Test)new CascadingAllNoCacheTest());
        this.addTest((Test)new CascadingNoneCacheTest());
        this.addTest((Test)new CascadingNoneNoCacheTest());
        this.addTest((Test)new CascadingPrivateCacheTest());
        this.addTest((Test)new CascadingPrivateNoCacheTest());
        this.addTest((Test)new DeepModifyTest());
        this.addTest((Test)new PrivateModifyTest());
        this.addTest((Test)new DeepDeleteTest());
        this.addTest((Test)new PrivateDeleteTest());
        this.addTest((Test)new DoesExistTest());
        this.addTest((Test)new DataReadQueryTest1());
        this.addTest((Test)new DirectReadQueryTest1());
        this.addTest((Test)new ValueReadQueryTest1());
        this.addTest((Test)new GetValueFromObject());
        this.addTest((Test)new CursoredStreamClientSessionTest());
        this.addTest((Test)new CursoredStreamReadWriteClientSessionTest());
        this.addTest((Test)new QBEObjectWithAllFieldsFilled());
        this.addTest((Test)new QBESpecialOperators());
        this.addTest((Test)new QBEExcludedValues());
        this.addTest((Test)new ConformingShouldTriggerIndirectionTest());
        this.addTest((Test)new ConformingThrowConformExceptionsTest());
        this.addTest((Test)new ConformResultsAcrossOneToOneTest(ConformResultsAcrossOneToOneTest.EQUAL));
        this.addTest((Test)new ConformResultsAcrossOneToOneTest(ConformResultsAcrossOneToOneTest.NOT_EQUAL));
        this.addTest((Test)new ConformResultsAcrossOneToOneTest(ConformResultsAcrossOneToOneTest.IS_NULL));
        this.addTest((Test)new ConformResultsAcrossOneToOneTest(ConformResultsAcrossOneToOneTest.NOT_NULL));
        this.addTest((Test)new ConformResultsRedirectorTest());
        this.addTest((Test)new ConformResultsWithSelectionObjectTest());
        this.addTests(ConformResultsWithPrimaryKeyExpressionTest.buildTests());
        this.addTest((Test)new ConformResultsAcrossOneToManyAcrossOneToOneTest());
        this.addTest((Test)new ConformResultsAcrossOneToManyTest());
        this.addTest((Test)new ConformResultsAcrossWrappedOneToManyTest());
        this.addTest((Test)new ShouldRegisterResultsInUnitOfWorkTest(false));
        this.addTest((Test)new ShouldRegisterResultsInUnitOfWorkTest(true));
        this.addTest((Test)new ConformResultsPerformanceTest());
        this.addTest((Test)new OneToManyMaxRowsSettingTest());
        this.addTest((Test)new QueryExceptionStringTest());
        this.addTest((Test)new NamedQueriesClientSessionTest());
        this.addTest((Test)new NamedQueriesDescriptorQueryManagerTest());
        this.addTest((Test)new NamedQueriesUOWTest());
        this.addTest((Test)new NamedQueryGetQueryNoArgumentsTest());
        this.addTest((Test)new ServerClientNamedQueryTest());
        this.addTest((Test)new GetTableGetFieldTest());
        this.addTest((Test)new NamedQueryNotFoundInUOWTest());
        this.addTest((Test)new DeleteAllQueryTest());
        this.addTest((Test)new DeleteObjectPrivatelyOwningUntriggeredIndirection());
        this.addTest((Test)new RedirectQueryOnUOWTest());
        this.addTest((Test)new RedirectorOnDescriptorTest());
        this.addTest((Test)new DoNotRedirectDefaultRedirectorTest());
        this.addTest((Test)new SetReferenceClassTest());
        this.addTest((Test)new QueryByExampleInUOWTest());
        this.addTest((Test)new InheritancePrepareTest());
        this.addTest((Test)new InheritanceViewPrepareTest());
        this.addTest((Test)new DataReadQueryContainerPolicyTest());
        this.addTest((Test)new UpdateAllQueryTest());
        this.addTest((Test)new UpdateAllQueryUOWTest());
        this.addTest((Test)new UpdateAllQueryUOWTest(false));
        this.addTest((Test)new UpdateAllQueryExpressionMathTest());
        this.addTest((Test)new UpdateAllQueryRollbackTest());
        this.addTest((Test)new UOWgetQueryTest());
        this.addTest((Test)new CascadeNoBindingOnQuery());
        this.addTest((Test)new IncorrectPartialAttributeTest());
        this.addTest((Test)new FirstResultAndMaxRowsTest(0, 0, 12));
        this.addTest((Test)new FirstResultAndMaxRowsTest(1, 0, 11));
        this.addTest((Test)new FirstResultAndMaxRowsTest(0, 5, 5));
        this.addTest((Test)new FirstResultAndMaxRowsTest(2, 5, 3));
        this.addTest((Test)new QueryCacheTest());
        this.addTest((Test)new TranslatedStringsTest());
    }

    public TestCase buildReadOnlyQueryTest() {
        TestCase test = new TestCase(){

            public void test() {
                UnitOfWork uow = this.getSession().acquireUnitOfWork();
                ReadAllQuery query = new ReadAllQuery(Employee.class);
                query.setIsReadOnly(true);
                List result = (List)uow.executeQuery((DatabaseQuery)query);
                if (((UnitOfWorkImpl)uow).isObjectRegistered(result.get(0))) {
                    this.throwError("Read-only result was registered.");
                }
                ReadObjectQuery objectQuery = new ReadObjectQuery(result.get(0));
                objectQuery.setIsReadOnly(true);
                Employee employee = (Employee)uow.executeQuery((DatabaseQuery)objectQuery);
                if (((UnitOfWorkImpl)uow).isObjectRegistered((Object)employee)) {
                    this.throwError("Read-only result was registered.");
                }
                if (employee != result.get(0)) {
                    this.throwError("Read-only result identity not maintained.");
                }
                employee.getAddress();
            }
        };
        test.setName("ReadOnlyQueryTest");
        return test;
    }

    public TestCase buildUnionTest() {
        TestCase test = new TestCase(){

            public void setup() {
                if (this.getSession().getPlatform().isMySQL() || this.getSession().getPlatform().isSybase() || this.getSession().getPlatform().isSymfoware()) {
                    this.throwWarning("Database does not support INTERSECT");
                }
            }

            public void test() {
                ExpressionBuilder e = new ExpressionBuilder();
                ReadAllQuery query = new ReadAllQuery(Employee.class, e);
                query.setSelectionCriteria(e.get("firstName").equal((Object)"Bob"));
                ExpressionBuilder e2 = new ExpressionBuilder();
                ReportQuery union = new ReportQuery(Employee.class, e2);
                union.addItem("employee", (Expression)e2);
                union.setSelectionCriteria(e2.get("firstName").equal((Object)"Sarah"));
                query.union(union);
                ExpressionBuilder e3 = new ExpressionBuilder();
                ReportQuery unionAll = new ReportQuery(Employee.class, e3);
                unionAll.addItem("employee", (Expression)e3);
                unionAll.setSelectionCriteria(e3.get("firstName").equal((Object)"Sarah"));
                query.addUnionExpression(e.unionAll(e.subQuery(unionAll)));
                ExpressionBuilder e4 = new ExpressionBuilder();
                ReportQuery intersect = new ReportQuery(Employee.class, e4);
                intersect.addItem("employee", (Expression)e4);
                intersect.setSelectionCriteria(e4.get("firstName").equal((Object)"Sarah"));
                query.intersect(intersect);
                ExpressionBuilder e6 = new ExpressionBuilder();
                ReportQuery except = new ReportQuery(Employee.class, e6);
                except.addItem("employee", (Expression)e6);
                except.setSelectionCriteria(e6.get("firstName").equal((Object)"Sarah"));
                query.except(except);
                List result = (List)this.getSession().executeQuery((DatabaseQuery)query);
                if (result.size() > 0) {
                    this.throwError("Expected 0 elements: " + result);
                }
            }
        };
        test.setName("UnionTest");
        return test;
    }

    public TestCase buildArgumentValuesTest() {
        TestCase test = new TestCase(){

            public void test() {
                ReadAllQuery query = new ReadAllQuery(Employee.class);
                query.setSelectionCriteria(query.getExpressionBuilder().get("firstName").equal(query.getExpressionBuilder().getParameter("firstName")));
                query.addArgument("firstName");
                query.addArgumentValue((Object)"Bob");
                List result = (List)this.getSession().executeQuery((DatabaseQuery)query);
                for (Employee employee : result) {
                    if (employee.getFirstName().equals("Bob")) continue;
                    this.throwError("Incorrect result: " + employee);
                }
            }
        };
        test.setName("ArgumentValuesTest");
        return test;
    }

    public TestCase buildGetSQLTest() {
        TestCase test = new TestCase(){

            public void test() {
                ReadAllQuery query = new ReadAllQuery(Employee.class);
                ExpressionBuilder builder = query.getExpressionBuilder();
                query.setSelectionCriteria(builder.get("firstName").equal(builder.getParameter("name")));
                query.addArgument("name");
                DatabaseRecord record = new DatabaseRecord();
                record.put((Object)"name", (Object)"Bob");
                String sql = query.getTranslatedSQLString(this.getSession(), (Record)record);
                if (sql.indexOf("?") != -1) {
                    this.throwError("SQL was not translated.");
                }
            }
        };
        test.setName("GetSQLTest");
        return test;
    }

    public TestCase buildJoinSubclassesQueryTest() {
        TestCase test = new TestCase(){

            public void test() {
                ScrollableCursorPolicy policy;
                UnitOfWork uow = this.getSession().acquireUnitOfWork();
                ReadAllQuery query = new ReadAllQuery(Project.class);
                boolean TYPE_SCROLL_INSENSITIVE_isSupported = true;
                boolean CONCUR_UPDATABLE_isSupported = true;
                if (this.getSession().getPlatform().isSQLServer()) {
                    TYPE_SCROLL_INSENSITIVE_isSupported = false;
                    CONCUR_UPDATABLE_isSupported = false;
                }
                if (this.getSession().getPlatform().isSymfoware()) {
                    TYPE_SCROLL_INSENSITIVE_isSupported = false;
                    CONCUR_UPDATABLE_isSupported = false;
                }
                if (this.getSession().getPlatform().isHANA()) {
                    policy = new ScrollableCursorPolicy();
                    policy.setResultSetType(1003);
                    policy.setResultSetConcurrency(1007);
                    policy.setPageSize(10);
                    query.useScrollableCursor(policy);
                } else if (TYPE_SCROLL_INSENSITIVE_isSupported && CONCUR_UPDATABLE_isSupported) {
                    query.useScrollableCursor();
                } else {
                    policy = new ScrollableCursorPolicy();
                    if (!TYPE_SCROLL_INSENSITIVE_isSupported) {
                        policy.setResultSetType(1005);
                    }
                    if (!CONCUR_UPDATABLE_isSupported) {
                        policy.setResultSetConcurrency(1007);
                    }
                    policy.setPageSize(10);
                    query.useScrollableCursor(policy);
                }
                query.setShouldOuterJoinSubclasses(true);
                Cursor result = (Cursor)uow.executeQuery((DatabaseQuery)query);
                result.nextElement();
                result.close();
            }
        };
        test.setName("JoinSubclassesQueryTest");
        return test;
    }

    public PredefinedQueryTest buildPredefinedAnyOfObjectComparisonTest() {
        Employee employee = (Employee)PopulationManager.getDefaultManager().getObject(Employee.class, "0002");
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        query.setName("findEmployeeByPhone");
        query.setSelectionCriteria(query.getExpressionBuilder().anyOf("phoneNumbers").equal(query.getExpressionBuilder().getParameter("phone")));
        query.addArgument("phone");
        Vector arguments = new Vector();
        arguments.addElement(employee.getPhoneNumbers().firstElement());
        PredefinedQueryTest test = new PredefinedQueryTest(query, employee, arguments);
        test.setName("PredefinedAnyOfObjectComparisonTest");
        test.setDescription("Test that any of object comparisons can be parameterized.");
        return test;
    }

    public PredefinedQueryTest buildPredefinedContainsSubStringTest() {
        Employee employee = (Employee)PopulationManager.getDefaultManager().getObject(Employee.class, "0002");
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        query.setName("findEmployeeWithNameContaining");
        query.setSelectionCriteria(query.getExpressionBuilder().get("firstName").containsSubstringIgnoringCase(query.getExpressionBuilder().getParameter("name")));
        query.addArgument("name");
        Vector<String> arguments = new Vector<String>();
        arguments.addElement(employee.getFirstName().toLowerCase());
        PredefinedQueryTest test = new PredefinedQueryTest(query, employee, arguments);
        test.setName("PredefinedContainsSubStringTest");
        test.setDescription("Test that complex function can be parameterized.");
        return test;
    }

    public PredefinedQueryTest buildPredefinedEqualNullTest() {
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        query.setName("findEmployeeByName");
        query.setSelectionCriteria(query.getExpressionBuilder().get("firstName").equal(query.getExpressionBuilder().getParameter("name")));
        query.addArgument("name");
        query.setShouldPrepare(false);
        Vector<Object> arguments = new Vector<Object>();
        arguments.addElement(null);
        PredefinedQueryTest test = new PredefinedQueryTest(query, null, arguments);
        test.setName("PredefinedEqualNullTest");
        test.setDescription("Test that equal null can be parameterized.");
        return test;
    }

    public PredefinedQueryTest buildPredefinedInTest() {
        Employee employee = (Employee)PopulationManager.getDefaultManager().getObject(Employee.class, "0002");
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        query.setName("findEmployeeByName");
        query.setSelectionCriteria(query.getExpressionBuilder().get("firstName").in(query.getExpressionBuilder().getParameter("names")));
        query.addArgument("names");
        query.setShouldPrepare(false);
        query.bindAllParameters();
        Vector arguments = new Vector();
        Vector<String> names = new Vector<String>();
        names.addElement(employee.getFirstName());
        names.addElement("Hommer-Simpson");
        arguments.addElement(names);
        PredefinedQueryTest test = new PredefinedQueryTest(query, employee, arguments);
        test.setName("PredefinedInTest");
        test.setDescription("Test that in's can be parameterized.");
        return test;
    }

    public PredefinedQueryTest buildPredefinedMethodRedirectorTest() {
        Employee employee = (Employee)PopulationManager.getDefaultManager().getObject(Employee.class, "0002");
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        query.setName("findEmployeeByAnEmployee");
        query.addArgument("employee");
        MethodBaseQueryRedirector redirector = new MethodBaseQueryRedirector(QueryFrameworkTestSuite.class, "findEmployeeByAnEmployee");
        query.setRedirector((QueryRedirector)redirector);
        Vector<Employee> arguments = new Vector<Employee>();
        arguments.addElement(employee);
        PredefinedQueryTest test = new PredefinedQueryTest(query, employee, arguments);
        test.setName("PredefinedMethodRedirectorTest");
        test.setDescription("Test query redirectors.");
        return test;
    }

    public PredefinedQueryTest buildPredefinedNestedParameterTest() {
        Employee employee = (Employee)PopulationManager.getDefaultManager().getObject(Employee.class, "0002");
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        query.setName("findEmployeeInSameCity");
        query.setSelectionCriteria(query.getExpressionBuilder().get("address").get("city").equal(query.getExpressionBuilder().getParameter("employee").get("address").get("city")));
        query.addArgument("employee");
        Vector<Employee> arguments = new Vector<Employee>();
        arguments.addElement(employee);
        PredefinedQueryTest test = new PredefinedQueryTest(query, employee, arguments);
        test.setName("PredefinedNestedParameterTest");
        test.setDescription("Test nested parameters.");
        return test;
    }

    public PredefinedQueryTest buildPredefinedObjectComparisonTest() {
        Employee employee = (Employee)PopulationManager.getDefaultManager().getObject(Employee.class, "0002");
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        query.setName("findEmployeeByAddress");
        query.setSelectionCriteria(query.getExpressionBuilder().get("address").equal(query.getExpressionBuilder().getParameter("address")));
        query.addArgument("address");
        Vector<Address> arguments = new Vector<Address>();
        arguments.addElement(employee.getAddress());
        PredefinedQueryTest test = new PredefinedQueryTest(query, employee, arguments);
        test.setName("PredefinedObjectComparisonTest");
        test.setDescription("Test that object comparisons can be parameterized.");
        return test;
    }

    public PredefinedQueryTest buildPredefinedObjectTypeTest() {
        Employee employee = (Employee)PopulationManager.getDefaultManager().getObject(Employee.class, "0002");
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        query.setName("findEmployeeByGender");
        query.setSelectionCriteria(query.getExpressionBuilder().get("firstName").equal(query.getExpressionBuilder().getParameter("firstName")).and(query.getExpressionBuilder().get("gender").equal(query.getExpressionBuilder().getParameter("gender"))));
        query.addArgument("firstName");
        query.addArgument("gender");
        Vector<String> arguments = new Vector<String>();
        arguments.addElement(employee.getFirstName());
        arguments.addElement(employee.getGender());
        PredefinedQueryTest test = new PredefinedQueryTest(query, employee, arguments);
        test.setName("PredefinedObjectTypeTest");
        test.setDescription("Test that object type mappings can be parameterized.");
        return test;
    }

    public PredefinedQueryTest buildPredefinedRedirectorTest() {
        Employee employee = (Employee)PopulationManager.getDefaultManager().getObject(Employee.class, "0002");
        ReadObjectQuery query = new ReadObjectQuery(Employee.class);
        query.setName("findEmployeeByEmployee");
        query.addArgument("employee");
        query.setRedirector(new QueryRedirector(){

            public Object invokeQuery(DatabaseQuery query, Record arguments, Session session) {
                return arguments.get((Object)"employee");
            }
        });
        Vector<Employee> arguments = new Vector<Employee>();
        arguments.addElement(employee);
        PredefinedQueryTest test = new PredefinedQueryTest(query, employee, arguments);
        test.setName("PredefinedRedirectorTest");
        test.setDescription("Test query redirectors.");
        return test;
    }

    public TestCase buildRecordTest() {
        TestCase test = new TestCase(){

            public void test() {
                ReadAllQuery query = new ReadAllQuery(Employee.class);
                query.setShouldIncludeData(true);
                ComplexQueryResult result = (ComplexQueryResult)this.getSession().executeQuery((DatabaseQuery)query);
                DatabaseRecord record = (DatabaseRecord)((List)result.getData()).get(0);
                Iterator keySetKeys = record.keySet().iterator();
                Iterator keys = record.getFields().iterator();
                while (keys.hasNext() || keySetKeys.hasNext()) {
                    if (keys.next() == keySetKeys.next()) continue;
                    this.throwError("KeySet is incorrect.");
                }
                Iterator valuesSetValues = record.values().iterator();
                Iterator values = record.getValues().iterator();
                while (values.hasNext() || valuesSetValues.hasNext()) {
                    if (values.next() == valuesSetValues.next()) continue;
                    this.throwError("ValuesSet is incorrect.");
                }
                Iterator entries = record.entrySet().iterator();
                keys = record.getFields().iterator();
                values = record.getValues().iterator();
                while (entries.hasNext() || keys.hasNext()) {
                    Map.Entry entry = (Map.Entry)entries.next();
                    if (entry.getKey() == keys.next() && entry.getValue() == values.next()) continue;
                    this.throwError("EntrySet is incorrect.");
                }
            }
        };
        test.setName("BuildRecordTest");
        return test;
    }

    public static Object findEmployeeByAnEmployee(DatabaseQuery query, DatabaseRecord arguments, Session session) {
        ((ReadObjectQuery)query).setSelectionObject(arguments.get("employee"));
        return session.executeQuery(query);
    }

    public static Object findEmployeeByAnEmployee(Session session, Vector arguments) {
        return arguments.firstElement();
    }
}

