/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.manual;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.ManualVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.EmployeePopulator;

public class SQLLogToFileTest
extends ManualVerifyTestCase {
    String logFileName;
    Writer oldLog;

    public SQLLogToFileTest() {
        this.setDescription("This test verifies that SQL can be logged to a file, the sql output should logged.");
    }

    private String getLogFileName() {
        return this.logFileName;
    }

    public void reset() {
        this.rollbackTransaction();
        this.getSession().setLog(this.oldLog);
    }

    private void setLogFileName(String newFileName) {
        this.logFileName = newFileName;
    }

    protected void setLogging() {
        this.oldLog = this.getSession().getLog();
        this.setLogFileName("SQL.LOG");
        try {
            FileWriter fileWriter = new FileWriter(this.getLogFileName());
            this.getSession().setLog((Writer)fileWriter);
        }
        catch (IOException exception) {
            TestException testException = new TestException("Error opening stream on file " + this.getLogFileName());
            testException.setInternalException((Throwable)exception);
            throw testException;
        }
    }

    public void setup() {
        this.setLogging();
        this.beginTransaction();
    }

    public void test() {
        DatabaseSession session = this.getDatabaseSession();
        Employee anEmployee = (Employee)new EmployeePopulator().basicEmployeeExample1();
        session.insertObject((Object)anEmployee);
        session.writeObject((Object)new EmployeePopulator().basicEmployeeExample2());
        session.readAllObjects(Employee.class);
        session.deleteObject((Object)anEmployee);
        try {
            session.getLog().close();
        }
        catch (IOException e) {
            // empty catch block
        }
        session.setLog(this.oldLog);
        this.getSession().logMessage("================================================================");
        this.getSession().logMessage("Dumping contents of log file (" + this.getLogFileName() + ") to screen.");
        try {
            BufferedReader input = new BufferedReader(new FileReader(this.getLogFileName()));
            String nextLine = "";
            while (nextLine != null) {
                this.getSession().logMessage(nextLine);
                nextLine = input.readLine();
            }
        }
        catch (FileNotFoundException exception) {
            TestException testException = new TestException("The log file was not found :" + this.getLogFileName());
            testException.setInternalException((Throwable)exception);
            throw testException;
        }
        catch (IOException exception) {
            TestException testException = new TestException("Could not read from log file :" + this.getLogFileName());
            testException.setInternalException((Throwable)exception);
            throw testException;
        }
        this.getSession().logMessage("================== DONE (Dumping contents of log file.) ====================");
    }
}

