/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.internal.sessions.factories.model.login.DatabaseLoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.LoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.StructConverterConfig;
import org.eclipse.persistence.internal.sessions.factories.model.sequencing.SequencingConfig;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatform;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DataSource;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.LoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.LoginHandler;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SequencingAdapter;
import org.eclipse.persistence.tools.workbench.utility.iterators.ArrayIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public final class DatabaseLoginAdapter
extends LoginAdapter {
    public static final String DRIVER_CLASS_PROPERTY = "driverClass";
    public static final String CONNECTION_URL_PROPERTY = "connectionURL";
    public static final String DATA_SOURCE_PROPERTY = "dataSource";
    public static final String NATIVE_SEQUENCING_PROPERTY = "nativeSequencing";
    public static final String CONNECTION_HEALTH_VALIDATE_ON_ERROR_PROPERTY = "connectionHealthValidateOnError";
    public static final String DELAY_BETWEEN_CONNECTION_ATTEMPTS_PROPERTY = "delayBetweenConnectionAttempts";
    public static final String QUERY_RETRY_ATTEMPT_COUNT_PROPERTY = "queryRetryAttemptCount";
    public static final String PING_SQL_PROPERTY = "pingSQL";
    public static final String BIND_ALL_PARAMETERS_PROPERTY = "bindAllParameters";
    public static final String CACHE_ALL_STATEMENTS_PROPERTY = "cacheAllStatements";
    public static final String BYTE_ARRAY_BINDING_PROPERTY = "byteArrayBinding";
    public static final String STRING_BINDING_PROPERTY = "stringBinding";
    public static final String STREAMS_FOR_BINDING_PROPERTY = "streamsForBinding";
    public static final String FORCE_FIELD_NAMES_TO_UPPER_CASE_PROPERTY = "forceFieldNamesToUppercase";
    public static final String OPTIMIZE_DATA_CONVERSION_PROPERTY = "optimizeDataConversion";
    public static final String TRIM_STRINGS_PROPERTY = "trimStrings";
    public static final String BATCH_WRITING_PROPERTY = "batchWriting";
    public static final String JDBC_BATCH_WRITING_PROPERTY = "jdbcBatchWriting";
    public static final String MAX_BATCH_WRITING_SIZE_PROPERTY = "maxBatchWritingSize";
    public static final String NATIVE_SQL_PROPERTY = "nativeSQL";
    public static final String LOOKUP_TYPE_PROPERTY = "lookup";
    public static final String STRUCT_CONVERTER_COLLECTION_PROPERTY = "structConverters";
    private volatile boolean useDriverManager;
    public static final String USE_DRIVER_MANAGER_PROPERTY = "useDriverManager";
    private volatile boolean useProperties;
    public static final String USE_PROPERTIES_PROPERTY = "useProperties";
    private static Map driverClassesURLTable;

    DatabaseLoginAdapter(SCAdapter parent, DatabaseLoginConfig scConfig) {
        super(parent, (LoginConfig)scConfig);
    }

    protected DatabaseLoginAdapter(SCAdapter parent) {
        super(parent);
    }

    @Override
    protected Object buildModel() {
        DatabaseLoginConfig dBLoginConfig = new DatabaseLoginConfig();
        dBLoginConfig.setStructConverterConfig(new StructConverterConfig());
        return dBLoginConfig;
    }

    protected StructConverterConfig buildStructConverters() {
        StructConverterConfig config = new StructConverterConfig();
        this.login().setStructConverterConfig(config);
        return config;
    }

    @Override
    protected SequencingAdapter buildSequencing() {
        SequencingAdapter sequencing = super.buildSequencing();
        this.login().setSequencingConfig((SequencingConfig)sequencing.getModel());
        return sequencing;
    }

    public String getDriverClassName() {
        return this.login().getDriverClass();
    }

    public void setDriverClassName(String className) {
        if (!this.useDriverManager) {
            throw new IllegalStateException();
        }
        String old = this.login().getDriverClass();
        this.login().setDriverClass(className);
        this.firePropertyChanged(DRIVER_CLASS_PROPERTY, old, className);
    }

    public String getConnectionURL() {
        return this.login().getConnectionURL();
    }

    public void setConnectionURL(String value) {
        String old = this.login().getConnectionURL();
        this.login().setConnectionURL(value);
        this.firePropertyChanged(CONNECTION_URL_PROPERTY, old, value);
    }

    public String getDataSourceName() {
        return this.login().getDatasource();
    }

    public void setDataSourceName(String name) {
        if (this.useDriverManager) {
            throw new IllegalStateException();
        }
        String old = this.login().getDatasource();
        this.login().setDatasource(name);
        this.firePropertyChanged(DATA_SOURCE_PROPERTY, old, name);
    }

    @Override
    public boolean databaseDriverIsDriverManager() {
        return this.useDriverManager;
    }

    @Override
    public boolean databaseDriverIsDataSource() {
        return !this.useDriverManager;
    }

    public void setDatabaseDriverAsDataSource() {
        this.setDatabaseDriverType(false);
    }

    public void setDatabaseDriverAsDriverManager() {
        this.setDatabaseDriverType(true);
    }

    private void setDatabaseDriverType(boolean useDriverManager) {
        boolean old = this.useDriverManager;
        if (old == useDriverManager) {
            return;
        }
        this.clearDatabaseDriverData();
        this.useDriverManager = useDriverManager;
        this.firePropertyChanged(USE_DRIVER_MANAGER_PROPERTY, old, useDriverManager);
    }

    private void clearDatabaseDriverData() {
        if (this.useDriverManager) {
            this.setDriverClassName(null);
            this.setConnectionURL(null);
            ((LoginHandler)this.getParent()).setExternalConnectionPooling(true);
        } else {
            this.setDataSourceName(null);
        }
    }

    @Override
    public void toString(StringBuffer sb) {
        super.toString(sb);
        sb.append(", ").append(this.getDriverClassName());
    }

    private final DatabaseLoginConfig login() {
        return (DatabaseLoginConfig)this.getModel();
    }

    @Override
    protected void initializeDefaults() {
        super.initializeDefaults();
        this.useDriverManager = true;
        this.setByteArrayBinding(true);
        this.setOptimizeDataConversion(true);
        this.setTrimStrings(true);
        this.setMaxBatchWritingSize(32000);
        this.setJdbcBatchWriting(true);
        this.setLookupType(new Integer(2));
        this.setBindAllParameters(true);
    }

    @Override
    protected void initialize(Object newConfig) {
        super.initialize(newConfig);
        this.buildStructConverters();
    }

    @Override
    protected void initializeFromModel(Object scConfig) {
        super.initializeFromModel(scConfig);
        if (this.usesBatchWriting() && this.login().getMaxBatchWritingSize() == null) {
            this.login().setMaxBatchWritingSize(new Integer(0));
        }
        this.useDriverManager = StringTools.stringIsEmpty((String)this.getDataSourceName());
        Vector properties = this.login().getPropertyConfigs();
        boolean bl = this.useProperties = properties != null && !properties.isEmpty();
        if (this.login().getLookupType() == null) {
            this.login().setLookupType(new Integer(2));
        }
        if (this.login().getStructConverterConfig() == null) {
            this.buildStructConverters();
        }
    }

    @Override
    protected void postInitializationFromModel() {
        super.postInitializationFromModel();
        String platformClass = this.convertToNewPlatformClass(this.getPlatformClass());
        if (platformClass != null) {
            this.setPlatformClass(platformClass);
        }
    }

    @Override
    protected String getDefaultPlatformClassName() {
        String platformName = this.preferences().get("platform.database", "Oracle11");
        DatabasePlatform platform = DatabasePlatformRepository.getDefault().platformNamed(platformName);
        return DataSource.getClassNameForDatabasePlatform(platform);
    }

    private String convertToNewPlatformClass(String platformClass) {
        if (platformClass == null) {
            return null;
        }
        return (String)this.oldPlatformClasses().get(platformClass);
    }

    private Map oldPlatformClasses() {
        Hashtable<String, String> oldClasses = new Hashtable<String, String>();
        oldClasses.put("org.eclipse.persistence.internal.databaseaccess.AttunityPlatform", "org.eclipse.persistence.platform.database.AttunityPlatform");
        oldClasses.put("org.eclipse.persistence.internal.databaseaccess.CloudscapePlatform", "org.eclipse.persistence.platform.database.CloudscapePlatform");
        oldClasses.put("org.eclipse.persistence.internal.databaseaccess.DB2Platform", "org.eclipse.persistence.platform.database.DB2Platform");
        oldClasses.put("org.eclipse.persistence.internal.databaseaccess.DBasePlatform", "org.eclipse.persistence.platform.database.DBasePlatform");
        oldClasses.put("org.eclipse.persistence.internal.databaseaccess.HSQLPlatform", "org.eclipse.persistence.platform.database.HSQLPlatform");
        oldClasses.put("org.eclipse.persistence.internal.databaseaccess.InformixPlatform", "org.eclipse.persistence.platform.database.InformixPlatform");
        oldClasses.put("org.eclipse.persistence.internal.databaseaccess.AccessPlatform", "org.eclipse.persistence.platform.database.AccessPlatform");
        oldClasses.put("org.eclipse.persistence.internal.databaseaccess.OraclePlatform", "org.eclipse.persistence.platform.database.oracle.OraclePlatform");
        oldClasses.put("org.eclipse.persistence.oraclespecific.Oracle8Platform", "org.eclipse.persistence.platform.database.oracle.Oracle8Platform");
        oldClasses.put("org.eclipse.persistence.oraclespecific.Oracle9Platform", "org.eclipse.persistence.platform.database.oracle.Oracle9Platform");
        oldClasses.put("org.eclipse.persistence.internal.databaseaccess.DatabasePlatform", "org.eclipse.persistence.platform.database.DatabasePlatform");
        oldClasses.put("org.eclipse.persistence.internal.databaseaccess.PointBasePlatform", "org.eclipse.persistence.platform.database.PointBasePlatform");
        oldClasses.put("org.eclipse.persistence.internal.databaseaccess.SQLAnyWherePlatform", "org.eclipse.persistence.platform.database.SQLAnywherePlatform");
        oldClasses.put("org.eclipse.persistence.internal.databaseaccess.SQLServerPlatform", "org.eclipse.persistence.platform.database.SQLServerPlatform");
        oldClasses.put("org.eclipse.persistence.internal.databaseaccess.SybasePlatform", "org.eclipse.persistence.platform.database.SybasePlatform");
        oldClasses.put("org.eclipse.persistence.platform.database.SQLAnyWherePlatform", "org.eclipse.persistence.platform.database.SQLAnywherePlatform");
        return oldClasses;
    }

    @Override
    boolean platformIsRdbms() {
        return true;
    }

    public boolean bindsAllParameters() {
        return this.login().getBindAllParameters();
    }

    public void setBindAllParameters(boolean value) {
        boolean old = this.login().getBindAllParameters();
        this.login().setBindAllParameters(value);
        this.firePropertyChanged(BIND_ALL_PARAMETERS_PROPERTY, old, value);
    }

    public boolean cachesAllStatements() {
        return this.login().getCacheAllStatements();
    }

    public void setCacheAllStatements(boolean value) {
        boolean old = this.login().getCacheAllStatements();
        this.login().setCacheAllStatements(value);
        this.firePropertyChanged(CACHE_ALL_STATEMENTS_PROPERTY, old, value);
    }

    public boolean usesByteArrayBinding() {
        return this.login().getByteArrayBinding();
    }

    public void setByteArrayBinding(boolean value) {
        boolean old = this.login().getByteArrayBinding();
        this.login().setByteArrayBinding(value);
        this.firePropertyChanged(BYTE_ARRAY_BINDING_PROPERTY, old, value);
    }

    public boolean usesStringBinding() {
        return this.login().getStringBinding();
    }

    public void setStringBinding(boolean value) {
        boolean old = this.login().getStringBinding();
        if (old == value) {
            return;
        }
        this.login().setStringBinding(value);
        this.firePropertyChanged(STRING_BINDING_PROPERTY, old, value);
        this.setDefaultMaxBatchWritingSize();
    }

    protected void setDefaultMaxBatchWritingSize() {
        if (this.usesStringBinding()) {
            this.setMaxBatchWritingSize(100);
        } else {
            this.setMaxBatchWritingSize(32000);
        }
    }

    public boolean usesStreamsForBinding() {
        return this.login().getStreamsForBinding();
    }

    public void setStreamsForBinding(boolean value) {
        boolean old = this.login().getStreamsForBinding();
        this.login().setStreamsForBinding(value);
        this.firePropertyChanged(STREAMS_FOR_BINDING_PROPERTY, old, value);
    }

    public boolean forcesFieldNamesToUppercase() {
        return this.login().getForceFieldNamesToUppercase();
    }

    public void setForceFieldNamesToUppercase(boolean value) {
        boolean old = this.login().getForceFieldNamesToUppercase();
        this.login().setForceFieldNamesToUppercase(value);
        this.firePropertyChanged(FORCE_FIELD_NAMES_TO_UPPER_CASE_PROPERTY, old, value);
    }

    public boolean optimizesDataConversion() {
        return this.login().getOptimizeDataConversion();
    }

    public void setOptimizeDataConversion(boolean value) {
        boolean old = this.login().getOptimizeDataConversion();
        this.login().setOptimizeDataConversion(value);
        this.firePropertyChanged(OPTIMIZE_DATA_CONVERSION_PROPERTY, old, value);
    }

    public boolean trimsStrings() {
        return this.login().getTrimStrings();
    }

    public void setTrimStrings(boolean value) {
        boolean old = this.login().getTrimStrings();
        this.login().setTrimStrings(value);
        this.firePropertyChanged(TRIM_STRINGS_PROPERTY, old, value);
    }

    public boolean usesBatchWriting() {
        return this.login().getBatchWriting();
    }

    public void setBatchWriting(boolean value) {
        boolean old = this.login().getBatchWriting();
        this.login().setBatchWriting(value);
        this.firePropertyChanged(BATCH_WRITING_PROPERTY, old, value);
    }

    public boolean usesJdbcBatchWriting() {
        return this.login().getJdbcBatchWriting();
    }

    public void setJdbcBatchWriting(boolean value) {
        boolean old = this.login().getJdbcBatchWriting();
        this.login().setJdbcBatchWriting(value);
        this.firePropertyChanged(JDBC_BATCH_WRITING_PROPERTY, old, value);
    }

    public int getMaxBatchWritingSize() {
        Integer size = this.login().getMaxBatchWritingSize();
        return size != null ? size : 0;
    }

    public void setMaxBatchWritingSize(int value) {
        int old = this.getMaxBatchWritingSize();
        this.login().setMaxBatchWritingSize(new Integer(value));
        this.firePropertyChanged(MAX_BATCH_WRITING_SIZE_PROPERTY, old, value);
    }

    public String getPingSQL() {
        return this.login().getPingSQL();
    }

    public void setPingSQL(String value) {
        String old = this.login().getPingSQL();
        this.login().setPingSQL(value);
        this.firePropertyChanged(PING_SQL_PROPERTY, old, value);
    }

    public Integer getQueryRetryAttemptCount() {
        return this.login().getQueryRetryAttemptCount();
    }

    public void setQueryRetryAttemptCount(Integer value) {
        Integer old = this.login().getQueryRetryAttemptCount();
        this.login().setQueryRetryAttemptCount(value);
        this.firePropertyChanged(QUERY_RETRY_ATTEMPT_COUNT_PROPERTY, old, value);
    }

    public Integer getDelayBetweenConnectionAttempts() {
        return this.login().getDelayBetweenConnectionAttempts();
    }

    public void setDelayBetweenConnectionAttempts(Integer value) {
        Integer old = this.login().getDelayBetweenConnectionAttempts();
        this.login().setDelayBetweenConnectionAttempts(value);
        this.firePropertyChanged(DELAY_BETWEEN_CONNECTION_ATTEMPTS_PROPERTY, old, value);
    }

    public boolean usesNativeSQL() {
        return this.login().getNativeSQL();
    }

    public void setNativeSQL(boolean value) {
        boolean old = this.login().getNativeSQL();
        this.login().setNativeSQL(value);
        this.firePropertyChanged(NATIVE_SQL_PROPERTY, old, value);
    }

    public boolean isNativeSequencing() {
        return this.login().getNativeSequencing();
    }

    public void setIsNativeSequencing(boolean value) {
        boolean old = this.login().getNativeSequencing();
        this.login().setNativeSequencing(value);
        this.firePropertyChanged(NATIVE_SEQUENCING_PROPERTY, old, value);
    }

    public boolean isConnectionHealthValidatedOnError() {
        Boolean value = this.login().isConnectionHealthValidatedOnError();
        if (value == null) {
            return false;
        }
        return value;
    }

    public void setConnectionHealthValidatedOnError(boolean value) {
        Boolean old = this.login().isConnectionHealthValidatedOnError();
        Boolean newValue = value;
        this.login().setConnectionHealthValidatedOnError(newValue);
        this.firePropertyChanged(CONNECTION_HEALTH_VALIDATE_ON_ERROR_PROPERTY, old, newValue);
    }

    public static Iterator driverClasses() {
        return DatabaseLoginAdapter.getDriverClassesURLTable().keySet().iterator();
    }

    public static Iterator driverURLs(String driverClass) {
        Object[] urls = (String[])DatabaseLoginAdapter.getDriverClassesURLTable().get(driverClass);
        if (urls == null) {
            return NullIterator.instance();
        }
        return new ArrayIterator(urls);
    }

    private static Map buildDriverClassURLTable() {
        Hashtable<String, String[]> table = new Hashtable<String, String[]>();
        table.put("com.neon.jdbc.Driver", new String[]{"jdbc:neon:"});
        table.put("com.pointbase.jdbc.jdbcUniversalDriver", new String[]{"jdbc:pointbase:"});
        table.put("com.sybase.jdbc3.jdbc.SybDriver", new String[]{"jdbc:sybase:Tds:"});
        table.put("com.sybase.jdbc2.jdbc.SybDriver", new String[]{"jdbc:sybase:Tds:"});
        table.put("com.sybase.jdbc.SybDriver", new String[]{"jdbc:sybase:Tds:"});
        table.put("COM.ibm.db2.jdbc.app.DB2Driver", new String[]{"jdbc:db2:"});
        table.put("COM.ibm.db2.jdbc.net.DB2Driver", new String[]{"jdbc:db2:"});
        table.put("com.ibm.db2.jcc.DB2Driver", new String[]{"jdbc:db2://"});
        table.put("com.mysql.jdbc.Driver", new String[]{"jdbc:mysql://"});
        table.put("borland.jdbc.Bridge.LocalDriver", new String[]{"jdbc:BorlandBridge:"});
        table.put("borland.jdbc.Broker.RemoteDriver", new String[]{"jdbc:BorlandBridge:"});
        table.put("intersolv.jdbc.sequelink.SequeLinkDriver", new String[]{"jdbc:sequelink:"});
        String[] oracleURLs = new String[]{"jdbc:oracle:thin:@<HOST>:<PORT>:<SID>", "jdbc:oracle:oci:@<HOST>:<PORT>:<SID>", "jdbc:oracle:oci7:@<HOST>:<PORT>:<SID>", "jdbc:oracle:oci8:@<HOST>:<PORT>:<SID>"};
        table.put("oracle.jdbc.OracleDriver", oracleURLs);
        table.put("oracle.jdbc.driver.OracleDriver", oracleURLs);
        table.put("com.oracle.ias.jdbc.db2.DB2Driver", new String[]{"jdbc:oracle:db2://"});
        table.put("com.oracle.ias.jdbc.sqlserver.SQLServerDriver", new String[]{"jdbc:oracle:sqlserver://"});
        table.put("com.oracle.ias.jdbc.sybase.SybaseDriver", new String[]{"jdbc:oracle:sybase://"});
        table.put("org.hsqldb.jdbcDriver", new String[]{"jdbc:hsqldb:"});
        table.put("sun.jdbc.odbc.JdbcOdbcDriver", new String[]{"jdbc:odbc:"});
        table.put("weblogic.jdbc.oci.Driver", new String[]{"jdbc:weblogic:oracle:"});
        table.put("weblogic.jdbc.dblib.Driver", new String[]{"jdbc:weblogic:mssqlserver:", "jdbc:weblogic:sybase"});
        table.put("weblogic.jdbc.informix4.Driver", new String[]{"jdbc:weblogic:informix4:"});
        table.put("weblogic.jdbc.jts.Driver", new String[]{"jdbc:weblogic:jts:"});
        table.put("weblogic.jdbc.mssqlserver4.Driver", new String[]{"jdbc:weblogic:mssqlserver4:"});
        table.put("weblogic.jdbc.pool.Driver", new String[]{"jdbc:weblogic:pool:"});
        table.put("weblogic.jdbc.t3client.Driver", new String[]{"jdbc:weblogic:t3Client:"});
        table.put("weblogic.jdbc.t3.Driver", new String[]{"jdbc:weblogic:t3:"});
        table.put("com.timesten.jdbc.TimesTenDriver", new String[]{"jdbc:timesten:direct:<SID>"});
        return table;
    }

    private static Map getDriverClassesURLTable() {
        if (driverClassesURLTable == null) {
            driverClassesURLTable = DatabaseLoginAdapter.buildDriverClassURLTable();
        }
        return driverClassesURLTable;
    }

    protected void addProblemsTo(List branchProblems) {
        super.addProblemsTo(branchProblems);
        if (this.databaseDriverIsDriverManager()) {
            this.verifyProblemDriverClass(branchProblems);
            this.verifyProblemDriverURL(branchProblems);
        } else {
            this.verifyProblemDataSourceName(branchProblems);
        }
    }

    private void verifyProblemDriverClass(List branchProblems) {
        if (StringTools.stringIsEmpty((String)this.getDriverClassName())) {
            branchProblems.add(this.buildProblem("0802", this.getParent().displayString()));
        }
    }

    private void verifyProblemDriverURL(List branchProblems) {
        if (StringTools.stringIsEmpty((String)this.getConnectionURL())) {
            branchProblems.add(this.buildProblem("0801", this.getParent().displayString()));
        }
    }

    private void verifyProblemDataSourceName(List branchProblems) {
        if (StringTools.stringIsEmpty((String)this.getDataSourceName())) {
            branchProblems.add(this.buildProblem("0803", this.getParent().displayString()));
        }
    }

    public boolean usesProperties() {
        return this.useProperties;
    }

    public void setUseProperties(boolean useProperties) {
        boolean old = this.usesProperties();
        this.useProperties = useProperties;
        this.firePropertyChanged(USE_PROPERTIES_PROPERTY, old, useProperties);
        if (!this.usesProperties()) {
            this.removeAllProperties();
        }
    }

    public void setLookupType(Integer lookupType) {
        Integer oldLookupType = this.getLookupType();
        this.login().setLookupType(lookupType);
        this.firePropertyChanged(LOOKUP_TYPE_PROPERTY, oldLookupType, lookupType);
    }

    public Integer getLookupType() {
        return this.login().getLookupType();
    }

    private StructConverterConfig structConverterConfig() {
        return this.login().getStructConverterConfig();
    }

    public ListIterator<String> structConvertersClasses() {
        return this.structConverterConfig().getStructConverterClasses().listIterator();
    }

    public void addStructConverterClass(String className) {
        this.structConverterConfig().addStructConverterClass(className);
        int index = this.structConverterConfig().getStructConverterClasses().indexOf(className);
        this.fireItemAdded(STRUCT_CONVERTER_COLLECTION_PROPERTY, index, className);
    }

    public void removeStructConverterClass(String className) {
        Vector oldStructConverterClasses = this.structConverterConfig().getStructConverterClasses();
        int index = oldStructConverterClasses.indexOf(className);
        oldStructConverterClasses.remove(className);
        this.structConverterConfig().setStructConverterClasses(oldStructConverterClasses);
        this.fireItemRemoved(STRUCT_CONVERTER_COLLECTION_PROPERTY, index, className);
    }
}

