/*******************************************************************************
 * Copyright (c) 2006, 2012 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.mapping.orm.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.tools.mapping.orm.ExternalBatchFetch;

/**
 * The external form of an batch fetch.
 *
 * @see RelationshipMapping
 * @see ElementCollectionMapping
 * @see BasicCollectionMapping
 * @see BasicMapMapping
 *
 * @version 2.5
 * @author Les Davis
 */
@SuppressWarnings("nls")
final class BatchFetch extends AbstractExternalForm
                       implements ExternalBatchFetch {

	/**
	 * The node name used to store and retrieve the {@link Element} encapsulated by this external form.
	 */
	static final String BATCH_FETCH = "batch-fetch";

	/**
	 * The attribute name used to store and retrieve the size property.
	 */
	static final String SIZE = "size";

	/**
	 * The attribute name used to store and retrieve the type property.
	 */
	static final String TYPE = "type";

	/**
	 * Creates a new <code>BatchFetch<code>.
	 *
	 * @param parent The parent of this external form
	 */
	BatchFetch(AbstractExternalForm parent) {
		super(parent);
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	protected List<String> buildAttributeNamesOrder() {
		List<String> names = new ArrayList<String>();
		names.add(TYPE);
		names.add(SIZE);
		return names;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String getElementName() {
		return BATCH_FETCH;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getSize() {
		return getIntegerAttribute(SIZE);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public BatchFetchType getType() {
		return getEnumAttribute(TYPE, BatchFetchType.class);
	}


	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setSize(int size) {
		setAttribute(SIZE, size);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setType(BatchFetchType type) {
		setAttribute(TYPE, type);
	}
}