/*******************************************************************************
 * Copyright (c) 2012, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.reference;

/**
 * Convenience abstract class for boolean reference implementations.
 * Subclasses need only implement<ul>
 * <li>{@link #getValue()}
 * </ul>
 */
public abstract class AbstractBooleanReference
	implements BooleanReference
{
	protected AbstractBooleanReference() {
		super();
	}

	@Override
	public boolean is(boolean value) {
		return this.getValue() == value;
	}

	@Override
	public boolean isNot(boolean value) {
		return this.getValue() != value;
	}

	@Override
	public boolean isTrue() {
		return this.getValue();
	}

	@Override
	public boolean isFalse() {
		return ! this.getValue();
	}


	// ********** standard methods **********

	/**
	 * Object identity is critical to boolean references.
	 * There is no reason for two different boolean references to be
	 * <em>equal</em>.
	 *
	 * @see #is(boolean)
	 */
	@Override
	public boolean equals(Object obj) {
		return super.equals(obj);
	}

	/**
	 * @see #equals(Object)
	 */
	@Override
	public int hashCode() {
		return super.hashCode();
	}

	@Override
	public String toString() {
		return '[' + String.valueOf(this.getValue()) + ']';
	}
}