/*******************************************************************************
 * Copyright (c) 2008, 2013 Oracle and/or its affiliates. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 and Eclipse Distribution License v. 1.0
 * which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *     Oracle - initial API and implementation
 *
 ******************************************************************************/
package org.eclipse.persistence.tools.utility.command;

/**
 * @see AbstractThreadLocalCommandExecutor
 */
public class ThreadLocalExtendedCommandExecutor
	extends AbstractThreadLocalCommandExecutor<ExtendedCommandExecutor>
	implements ExtendedCommandExecutor
{
	/**
	 * The default command executor simply executes commands directly.
	 */
	public ThreadLocalExtendedCommandExecutor() {
		this(ExtendedCommandExecutor.Default.instance());
	}

	public ThreadLocalExtendedCommandExecutor(ExtendedCommandExecutor defaultCommandExecutor) {
		super(defaultCommandExecutor);
	}

	@Override
	public void waitToExecute(Command command) throws InterruptedException {
		this.getThreadLocalCommandExecutor().waitToExecute(command);
	}

	@Override
	public boolean waitToExecute(Command command, long timeout) throws InterruptedException {
		return this.getThreadLocalCommandExecutor().waitToExecute(command, timeout);
	}
}