/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.mapping.persistence.dom;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.persistence.tools.mapping.persistence.ExternalPersistenceConfiguration;
import org.eclipse.persistence.tools.mapping.persistence.ExternalPersistenceRepository;
import org.eclipse.persistence.tools.mapping.persistence.PersistenceDocumentType;
import org.eclipse.persistence.tools.mapping.persistence.dom.PersistenceConfiguration;
import org.eclipse.persistence.tools.utility.XMLTools;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public final class PersistenceRepository
implements ExternalPersistenceRepository {
    public static final String PERSISTENCE_XML = "persistence.xml";

    @Override
    public ExternalPersistenceConfiguration buildPersistenceConfiguration(URL location, PersistenceDocumentType type) throws IOException {
        PersistenceConfiguration persistence = new PersistenceConfiguration(XMLTools.newDocument());
        persistence.addSelf();
        persistence.setDocumentType(type);
        return persistence;
    }

    @Override
    public ExternalPersistenceConfiguration getPersistenceConfiguration(String persistenceXml) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            dbf.setNamespaceAware(false);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new ByteArrayInputStream(persistenceXml.getBytes("utf-8"))));
            return new PersistenceConfiguration(document);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return null;
        }
    }
}

