/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.db.driver;

import java.util.ArrayList;
import org.eclipse.persistence.tools.db.driver.AbstractWorkbenchDriverAdapter;
import org.eclipse.persistence.tools.db.driver.CatalogStrategy;
import org.eclipse.persistence.tools.db.driver.FoldingStrategy;
import org.eclipse.persistence.tools.db.driver.NonFoldingStrategy;
import org.eclipse.persistence.tools.db.driver.SimpleCatalogStrategy;
import org.eclipse.persistence.tools.db.driver.WorkbenchDriverAdapter;
import org.eclipse.persistence.tools.db.driver.WorkbenchDriverAdapterFactory;
import org.eclipse.persistence.tools.gen.db.Database;
import org.eclipse.persistence.tools.utility.StringTools;

class Sybase
extends AbstractWorkbenchDriverAdapter {
    private static final String MASTER_CATALOG_NAME = "master";
    private static final String DEFAULT_SCHEMA_NAME = "dbo";
    private static final char[] EXTENDED_REGULAR_NAME_START_CHARACTERS = new char[]{'_', '@'};
    private static final char[] EXTENDED_REGULAR_NAME_PART_CHARACTERS = new char[]{'$', '\u00a5', '\u00a3', '#'};

    Sybase(Database database) {
        super(database);
    }

    @Override
    CatalogStrategy buildCatalogStrategy() {
        return new SimpleCatalogStrategy();
    }

    @Override
    FoldingStrategy buildFoldingStrategy() {
        return NonFoldingStrategy.instance();
    }

    @Override
    boolean regularNamesMatch(String name1, String name2) {
        return name1.equals(name2);
    }

    @Override
    void addDefaultCatalogNamesTo(ArrayList<String> names) {
        names.add(this.database.getName());
        names.add(MASTER_CATALOG_NAME);
    }

    @Override
    void addDefaultSchemaNamesTo(ArrayList<String> names) {
        names.add(DEFAULT_SCHEMA_NAME);
    }

    @Override
    char[] getExtendedRegularNameStartCharacters() {
        return EXTENDED_REGULAR_NAME_START_CHARACTERS;
    }

    @Override
    char[] getExtendedRegularNamePartCharacters() {
        return EXTENDED_REGULAR_NAME_PART_CHARACTERS;
    }

    @Override
    String delimitName(String name) {
        return String.valueOf('[') + name + ']';
    }

    @Override
    boolean identifierIsDelimited(String identifier) {
        return StringTools.isBracketed((String)identifier) || super.identifierIsDelimited(identifier);
    }

    static class Factory
    implements WorkbenchDriverAdapterFactory {
        private static final String[] VENDORS = new String[]{"Sybase_ASA", "Sybase_ASE"};

        Factory() {
        }

        @Override
        public String[] getSupportedVendors() {
            return VENDORS;
        }

        @Override
        public WorkbenchDriverAdapter buildAdapter(Database database) {
            return new Sybase(database);
        }
    }
}

