/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.transformer;

import java.io.Serializable;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.transformer.Transformer;

public final class NonNullBooleanTransformer
implements Transformer<Boolean, Boolean>,
Serializable {
    private final Boolean nullValue;
    public static final Transformer<Boolean, Boolean> TRUE = new NonNullBooleanTransformer(Boolean.TRUE);
    public static final Transformer<Boolean, Boolean> FALSE = new NonNullBooleanTransformer(Boolean.FALSE);
    private static final long serialVersionUID = 1L;

    public static Transformer<Boolean, Boolean> valueOf(Boolean b) {
        return NonNullBooleanTransformer.valueOf((boolean)b);
    }

    public static Transformer<Boolean, Boolean> valueOf(boolean b) {
        return b ? TRUE : FALSE;
    }

    private NonNullBooleanTransformer(Boolean nullValue) {
        if (nullValue == null) {
            throw new NullPointerException();
        }
        this.nullValue = nullValue;
    }

    @Override
    public Boolean transform(Boolean b) {
        return b != null ? b : this.nullValue;
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.nullValue);
    }

    private Object readResolve() {
        return NonNullBooleanTransformer.valueOf(this.nullValue);
    }
}

