/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.utility.iterator;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.tools.utility.ObjectTools;
import org.eclipse.persistence.tools.utility.iterator.ArrayIterator;

public class CloneIterator<E>
implements Iterator<E> {
    private final Iterator<Object> iterator;
    private E current;
    private final Remover<E> remover;
    private boolean removeAllowed;

    public CloneIterator(Collection<? extends E> collection) {
        this(collection, Remover.ReadOnly.instance());
    }

    public CloneIterator(E[] array) {
        this(array, Remover.ReadOnly.instance());
    }

    public CloneIterator(Collection<? extends E> collection, Remover<E> remover) {
        this(remover, collection.toArray());
    }

    public CloneIterator(E[] array, Remover<E> remover) {
        this(remover, (Object[])array.clone());
    }

    protected CloneIterator(Remover<E> remover, Object ... array) {
        if (remover == null) {
            throw new NullPointerException();
        }
        this.iterator = new ArrayIterator<Object>(array);
        this.current = null;
        this.remover = remover;
        this.removeAllowed = false;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public E next() {
        this.current = this.nestedNext();
        this.removeAllowed = true;
        return this.current;
    }

    @Override
    public void remove() {
        if (!this.removeAllowed) {
            throw new IllegalStateException();
        }
        this.remover.remove(this.current);
        this.removeAllowed = false;
    }

    protected E nestedNext() {
        return (E)this.iterator.next();
    }

    public String toString() {
        return ObjectTools.toString(this);
    }

    public static interface Remover<T> {
        public void remove(T var1);

        public static final class ReadOnly<S>
        implements Remover<S>,
        Serializable {
            public static final Remover INSTANCE = new ReadOnly();
            private static final long serialVersionUID = 1L;

            public static <R> Remover<R> instance() {
                return INSTANCE;
            }

            private ReadOnly() {
            }

            @Override
            public void remove(Object element) {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return ObjectTools.singletonToString(this);
            }

            private Object readResolve() {
                return INSTANCE;
            }
        }
    }
}

