/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.legacy;

import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.models.legacy.Computer;
import org.eclipse.persistence.testing.models.legacy.Employee;
import org.eclipse.persistence.testing.models.legacy.GaurenteedShipment;
import org.eclipse.persistence.testing.models.legacy.InsuredShipment;
import org.eclipse.persistence.testing.models.legacy.LegacyTables;
import org.eclipse.persistence.testing.models.legacy.Order;
import org.eclipse.persistence.testing.models.legacy.Shipment;

public class LegacyProject
extends Project {
    public LegacyProject() {
        this.applyPROJECT();
        this.applyLOGIN();
        this.buildComputerDescriptor();
        this.buildEmployeeDescriptor();
        this.buildGaurenteedShipmentDescriptor();
        this.buildInsuredShipmentDescriptor();
        this.buildOrderDescriptor();
        this.buildShipmentDescriptor();
    }

    public static void amendEmployeeDescriptor(RelationalDescriptor descriptor) {
        descriptor.addForeignKeyFieldNameForMultipleTable("LEG_ADD.FIRST_NM", "LEG_EMP.FNAME");
        descriptor.addForeignKeyFieldNameForMultipleTable("LEG_ADD.LNAME", "LEG_EMP.LNAME");
    }

    public static void amendInsuredShipmentDescriptor(RelationalDescriptor descriptor) {
        descriptor.addForeignKeyFieldNameForMultipleTable("LEG_ISHP.F_NAME", "LEG_SHP.FNAME");
        descriptor.addForeignKeyFieldNameForMultipleTable("LEG_ISHP.L_NAME", "LEG_SHP.LNAME");
        descriptor.addForeignKeyFieldNameForMultipleTable("LEG_ISHP.SHIP_NO", "LEG_SHP.SHIP_NO");
        ExpressionBuilder builder = new ExpressionBuilder();
        descriptor.getDescriptorQueryManager().setMultipleTableJoinExpression(builder.getField("LEG_ISHP.F_NAME").equal(builder.getField("LEG_SHP.FNAME")).and(builder.getField("LEG_ISHP.L_NAME").equal(builder.getField("LEG_SHP.LNAME"))).and(builder.getField("LEG_ISHP.SHIP_NO").equal(builder.getField("LEG_SHP.SHIP_NO"))));
    }

    protected void applyLOGIN() {
        DatabaseLogin login = new DatabaseLogin();
        this.setLogin(login);
    }

    protected void applyPROJECT() {
        this.setName("Complex Legacy Model");
    }

    protected void buildComputerDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Computer.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("LEG_COM");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("LEG_COM.CREATE_TS");
        descriptor.addPrimaryKeyFieldName("LEG_COM.CREATE_TSM");
        descriptor.getDescriptorEventManager().setPreInsertSelector("prepareForInsert");
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("creationTimestamp");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("LEG_COM.CREATE_TS");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("creationTimestampMillis");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("LEG_COM.CREATE_TSM");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        DirectToFieldMapping directtofieldmapping2 = new DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("description");
        directtofieldmapping2.setIsReadOnly(false);
        if (LegacyTables.computerDescriptionFieldName == null) {
            directtofieldmapping2.setFieldName("LEG_COM.DESCRIP");
        } else {
            directtofieldmapping2.setFieldName("LEG_COM." + LegacyTables.computerDescriptionFieldName);
        }
        descriptor.addMapping((DatabaseMapping)directtofieldmapping2);
        OneToOneMapping onetoonemapping = new OneToOneMapping();
        onetoonemapping.setAttributeName("employee");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(false);
        onetoonemapping.setReferenceClass(Employee.class);
        onetoonemapping.setIsPrivateOwned(false);
        onetoonemapping.addForeignKeyFieldName("LEG_COM.EMP_FNAME", "LEG_EMP.FNAME");
        onetoonemapping.addForeignKeyFieldName("LEG_COM.EMP_LNAME", "LEG_EMP.LNAME");
        descriptor.addMapping((DatabaseMapping)onetoonemapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildEmployeeDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Employee.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("LEG_EMP");
        vector.addElement("LEG_ADD");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("LEG_EMP.FNAME");
        descriptor.addPrimaryKeyFieldName("LEG_EMP.LNAME");
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("address");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("LEG_ADD.ADDR");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("firstName");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("LEG_EMP.FNAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        DirectToFieldMapping directtofieldmapping2 = new DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("lastName");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setFieldName("LEG_EMP.LNAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping2);
        OneToManyMapping onetomanymapping = new OneToManyMapping();
        onetomanymapping.setAttributeName("shipments");
        onetomanymapping.setIsReadOnly(false);
        onetomanymapping.setUsesIndirection(false);
        onetomanymapping.setReferenceClass(Shipment.class);
        onetomanymapping.setIsPrivateOwned(true);
        onetomanymapping.addTargetForeignKeyFieldName("LEG_SHP.FNAME", "LEG_EMP.FNAME");
        onetomanymapping.addTargetForeignKeyFieldName("LEG_SHP.LNAME", "LEG_EMP.LNAME");
        descriptor.addMapping((DatabaseMapping)onetomanymapping);
        OneToOneMapping onetoonemapping = new OneToOneMapping();
        onetoonemapping.setAttributeName("computer");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(false);
        onetoonemapping.setReferenceClass(Computer.class);
        onetoonemapping.setIsPrivateOwned(true);
        onetoonemapping.addTargetForeignKeyFieldName("LEG_COM.EMP_FNAME", "LEG_EMP.FNAME");
        onetoonemapping.addTargetForeignKeyFieldName("LEG_COM.EMP_LNAME", "LEG_EMP.LNAME");
        descriptor.addMapping((DatabaseMapping)onetoonemapping);
        LegacyProject.amendEmployeeDescriptor(descriptor);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildGaurenteedShipmentDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(GaurenteedShipment.class);
        descriptor.getDescriptorInheritancePolicy().setParentClass(InsuredShipment.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("LEG_ISHP");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("LEG_ISHP.F_NAME");
        descriptor.addPrimaryKeyFieldName("LEG_ISHP.L_NAME");
        descriptor.addPrimaryKeyFieldName("LEG_ISHP.SHIP_NO");
        descriptor.getDescriptorInheritancePolicy().setShouldReadSubclasses(true);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildInsuredShipmentDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(InsuredShipment.class);
        descriptor.getDescriptorInheritancePolicy().setParentClass(Shipment.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("LEG_ISHP");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("LEG_ISHP.F_NAME");
        descriptor.addPrimaryKeyFieldName("LEG_ISHP.L_NAME");
        descriptor.addPrimaryKeyFieldName("LEG_ISHP.SHIP_NO");
        descriptor.getDescriptorInheritancePolicy().setShouldReadSubclasses(true);
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("employeeFirstName");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("LEG_ISHP.F_NAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("employeeLastName");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("LEG_ISHP.L_NAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        DirectToFieldMapping directtofieldmapping2 = new DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("insuranceAmount");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setFieldName("LEG_ISHP.INS_AMT");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping2);
        DirectToFieldMapping directtofieldmapping3 = new DirectToFieldMapping();
        directtofieldmapping3.setAttributeName("shipmentNumber");
        directtofieldmapping3.setIsReadOnly(false);
        directtofieldmapping3.setFieldName("LEG_ISHP.SHIP_NO");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping3);
        LegacyProject.amendInsuredShipmentDescriptor(descriptor);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildOrderDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Order.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("LEG_ORD");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("LEG_ORD.FNAME");
        descriptor.addPrimaryKeyFieldName("LEG_ORD.LNAME");
        descriptor.addPrimaryKeyFieldName("LEG_ORD.ORDER_NO");
        descriptor.addPrimaryKeyFieldName("LEG_ORD.SHIP_NO");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("description");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("LEG_ORD.DESCRIP");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("employeeFirstName");
        directtofieldmapping1.setIsReadOnly(true);
        directtofieldmapping1.setFieldName("LEG_ORD.FNAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        DirectToFieldMapping directtofieldmapping2 = new DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("employeeLastName");
        directtofieldmapping2.setIsReadOnly(true);
        directtofieldmapping2.setFieldName("LEG_ORD.LNAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping2);
        DirectToFieldMapping directtofieldmapping3 = new DirectToFieldMapping();
        directtofieldmapping3.setAttributeName("orderNumber");
        directtofieldmapping3.setIsReadOnly(false);
        directtofieldmapping3.setFieldName("LEG_ORD.ORDER_NO");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping3);
        DirectToFieldMapping directtofieldmapping4 = new DirectToFieldMapping();
        directtofieldmapping4.setAttributeName("shipmentNumber");
        directtofieldmapping4.setIsReadOnly(true);
        directtofieldmapping4.setFieldName("LEG_ORD.SHIP_NO");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping4);
        OneToOneMapping onetoonemapping = new OneToOneMapping();
        onetoonemapping.setAttributeName("employee");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(false);
        onetoonemapping.setReferenceClass(Employee.class);
        onetoonemapping.setIsPrivateOwned(false);
        onetoonemapping.addForeignKeyFieldName("LEG_ORD.FNAME", "LEG_EMP.FNAME");
        onetoonemapping.addForeignKeyFieldName("LEG_ORD.LNAME", "LEG_EMP.LNAME");
        descriptor.addMapping((DatabaseMapping)onetoonemapping);
        OneToOneMapping onetoonemapping1 = new OneToOneMapping();
        onetoonemapping1.setAttributeName("shipment");
        onetoonemapping1.setIsReadOnly(false);
        onetoonemapping1.setUsesIndirection(false);
        onetoonemapping1.setReferenceClass(Shipment.class);
        onetoonemapping1.setIsPrivateOwned(false);
        onetoonemapping1.addForeignKeyFieldName("LEG_ORD.SHIP_NO", "LEG_SHP.SHIP_NO");
        onetoonemapping1.addTargetForeignKeyFieldName("LEG_SHP.FNAME", "LEG_ORD.FNAME");
        onetoonemapping1.addTargetForeignKeyFieldName("LEG_SHP.LNAME", "LEG_ORD.LNAME");
        descriptor.addMapping((DatabaseMapping)onetoonemapping1);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildShipmentDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Shipment.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("LEG_SHP");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("LEG_SHP.FNAME");
        descriptor.addPrimaryKeyFieldName("LEG_SHP.LNAME");
        descriptor.addPrimaryKeyFieldName("LEG_SHP.SHIP_NO");
        descriptor.getDescriptorInheritancePolicy().setShouldReadSubclasses(true);
        descriptor.getDescriptorInheritancePolicy().setClassIndicatorFieldName("TYPE");
        descriptor.getDescriptorInheritancePolicy().setShouldUseClassNameAsIndicator(false);
        descriptor.getDescriptorInheritancePolicy().addClassIndicator(GaurenteedShipment.class, (Object)"Gaurentee");
        descriptor.getDescriptorInheritancePolicy().addClassIndicator(InsuredShipment.class, (Object)"Insured");
        descriptor.getDescriptorInheritancePolicy().addClassIndicator(Shipment.class, (Object)"Normal");
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("employeeFirstName");
        directtofieldmapping.setIsReadOnly(true);
        directtofieldmapping.setFieldName("LEG_SHP.FNAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("employeeLastName");
        directtofieldmapping1.setIsReadOnly(true);
        directtofieldmapping1.setFieldName("LEG_SHP.LNAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        DirectToFieldMapping directtofieldmapping2 = new DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("quantityShipped");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setFieldName("LEG_SHP.QUANTITY");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping2);
        DirectToFieldMapping directtofieldmapping3 = new DirectToFieldMapping();
        directtofieldmapping3.setAttributeName("shipmentNumber");
        directtofieldmapping3.setIsReadOnly(false);
        directtofieldmapping3.setFieldName("LEG_SHP.SHIP_NO");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping3);
        DirectToFieldMapping directtofieldmapping4 = new DirectToFieldMapping();
        directtofieldmapping4.setAttributeName("shipMode");
        directtofieldmapping4.setIsReadOnly(false);
        directtofieldmapping4.setFieldName("LEG_SHP.SHP_MODE");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping4);
        OneToManyMapping onetomanymapping = new OneToManyMapping();
        onetomanymapping.setAttributeName("orders");
        onetomanymapping.setIsReadOnly(false);
        onetomanymapping.setUsesIndirection(false);
        onetomanymapping.setReferenceClass(Order.class);
        onetomanymapping.setIsPrivateOwned(true);
        onetomanymapping.addTargetForeignKeyFieldName("LEG_ORD.LNAME", "LEG_SHP.LNAME");
        onetomanymapping.addTargetForeignKeyFieldName("LEG_ORD.SHIP_NO", "LEG_SHP.SHIP_NO");
        onetomanymapping.addTargetForeignKeyFieldName("LEG_ORD.FNAME", "LEG_SHP.FNAME");
        descriptor.addMapping((DatabaseMapping)onetomanymapping);
        ExpressionBuilder myBuilder = new ExpressionBuilder();
        Expression exp = myBuilder.getField("LEG_ORD.SHIP_NO").equal(myBuilder.getParameter("LEG_SHP.SHIP_NO"));
        Expression exp1 = myBuilder.getField("LEG_ORD.ORDER_NO").notEqual(0);
        ReadAllQuery q = new ReadAllQuery();
        q.setReferenceClass(Order.class);
        q.addArgument("shipmentNumber");
        q.setSelectionCriteria(exp.and(exp1));
        OneToManyMapping myMap = (OneToManyMapping)descriptor.getMappingForAttributeName("orders");
        myMap.setCustomSelectionQuery((ReadQuery)q);
        OneToOneMapping onetoonemapping = new OneToOneMapping();
        onetoonemapping.setAttributeName("employee");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(false);
        onetoonemapping.setReferenceClass(Employee.class);
        onetoonemapping.setIsPrivateOwned(false);
        onetoonemapping.addForeignKeyFieldName("LEG_SHP.LNAME", "LEG_EMP.LNAME");
        onetoonemapping.addForeignKeyFieldName("LEG_SHP.FNAME", "LEG_EMP.FNAME");
        descriptor.addMapping((DatabaseMapping)onetoonemapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }
}

