/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.spi.java;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import org.eclipse.persistence.jpa.jpql.tools.spi.IType;
import org.eclipse.persistence.jpa.jpql.tools.spi.ITypeDeclaration;
import org.eclipse.persistence.jpa.jpql.tools.spi.ITypeRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaTypeDeclaration
implements ITypeDeclaration {
    private boolean array;
    private Object genericType;
    private ITypeDeclaration[] genericTypes;
    private final IType type;
    private ITypeRepository typeRepository;

    public JavaTypeDeclaration(ITypeRepository typeRepository, IType type, Object genericType, boolean array) {
        this.type = type;
        this.array = array;
        this.genericType = genericType;
        this.typeRepository = typeRepository;
    }

    protected String buildArrayTypeName(String arrayTypeName) {
        StringBuilder sb = new StringBuilder();
        int index = arrayTypeName.indexOf(91);
        int dimensionality = (arrayTypeName.length() - index) / 2;
        String typeName = arrayTypeName.substring(0, index);
        while (--dimensionality >= 0) {
            sb.append("[");
        }
        String elementType = this.elementType(typeName);
        sb.append(elementType);
        sb.append(typeName);
        if (elementType.equals("L")) {
            sb.append(";");
        }
        return sb.toString();
    }

    protected ITypeDeclaration[] buildParameterTypes() {
        ArrayList<JavaTypeDeclaration> parameterTypes;
        block4: {
            block7: {
                block6: {
                    block5: {
                        block3: {
                            parameterTypes = new ArrayList<JavaTypeDeclaration>();
                            if (!(this.genericType instanceof ParameterizedType)) break block3;
                            ParameterizedType parameterizedType = (ParameterizedType)this.genericType;
                            Type[] typeArray = parameterizedType.getActualTypeArguments();
                            int n = typeArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Type type = typeArray[n2];
                                JavaTypeDeclaration typeParameter = this.buildTypeDeclaration(type);
                                parameterTypes.add(typeParameter);
                                ++n2;
                            }
                            break block4;
                        }
                        if (!(this.genericType instanceof GenericArrayType)) break block5;
                        GenericArrayType genericArrayType = (GenericArrayType)this.genericType;
                        parameterTypes.add(this.buildTypeDeclaration(genericArrayType.getGenericComponentType()));
                        break block4;
                    }
                    if (this.genericType.getClass() != Class.class) break block6;
                    JavaTypeDeclaration typeParameter = this.buildTypeDeclaration((Class)this.genericType);
                    parameterTypes.add(typeParameter);
                    break block4;
                }
                if (this.genericType.getClass() != Class[].class) break block7;
                Class[] classArray = (Class[])this.genericType;
                int n = classArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Class javaType = classArray[n3];
                    JavaTypeDeclaration typeParameter = this.buildTypeDeclaration(javaType);
                    parameterTypes.add(typeParameter);
                    ++n3;
                }
                break block4;
            }
            if (this.genericType.getClass() != IType[].class) break block4;
            IType[] iTypeArray = (IType[])this.genericType;
            int n = iTypeArray.length;
            int n4 = 0;
            while (n4 < n) {
                IType type = iTypeArray[n4];
                JavaTypeDeclaration typeParameter = new JavaTypeDeclaration(this.typeRepository, type, null, false);
                parameterTypes.add(typeParameter);
                ++n4;
            }
        }
        return parameterTypes.toArray(new ITypeDeclaration[parameterTypes.size()]);
    }

    protected JavaTypeDeclaration buildTypeDeclaration(Class<?> javaType) {
        return new JavaTypeDeclaration(this.typeRepository, this.getType(javaType), null, javaType.isArray());
    }

    protected JavaTypeDeclaration buildTypeDeclaration(Object genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            return this.buildTypeDeclaration(parameterizedType.getRawType());
        }
        if (genericType instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)genericType;
            Type[] typeArray = typeVariable.getBounds();
            if (typeArray.length != 0) {
                Type type = typeArray[0];
                return this.buildTypeDeclaration(type);
            }
            return this.buildTypeDeclaration(Object.class);
        }
        if (genericType instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)genericType;
            Type[] typeArray = wildcardType.getUpperBounds();
            if (typeArray.length != 0) {
                Type type = typeArray[0];
                return this.buildTypeDeclaration(type);
            }
            return this.buildTypeDeclaration(Object.class);
        }
        if (genericType instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)genericType;
            String arrayTypeName = this.buildArrayTypeName(genericArrayType.toString());
            IType arrayType = this.typeRepository.getType(arrayTypeName);
            return new JavaTypeDeclaration(this.typeRepository, arrayType, genericArrayType.getGenericComponentType(), true);
        }
        return this.buildTypeDeclaration((Class)genericType);
    }

    protected String elementType(String typeName) {
        if (typeName.equals("boolean")) {
            return "Z";
        }
        if (typeName.equals("byte")) {
            return "B";
        }
        if (typeName.equals("char")) {
            return "C";
        }
        if (typeName.equals("double")) {
            return "D";
        }
        if (typeName.equals("float")) {
            return "F";
        }
        if (typeName.equals("int")) {
            return "I";
        }
        if (typeName.equals("long")) {
            return "J";
        }
        if (typeName.equals("short")) {
            return "S";
        }
        return "L";
    }

    @Override
    public int getDimensionality() {
        if (this.array) {
            String name = this.type.getName();
            int index = 0;
            while (name.charAt(index) == '[') {
                ++index;
            }
            return index;
        }
        return 0;
    }

    @Override
    public IType getType() {
        return this.type;
    }

    protected IType getType(Class<?> type) {
        return this.typeRepository.getType(type);
    }

    @Override
    public ITypeDeclaration[] getTypeParameters() {
        if (this.genericTypes == null) {
            this.genericTypes = this.genericType == null ? new ITypeDeclaration[0] : this.buildParameterTypes();
        }
        return this.genericTypes;
    }

    @Override
    public boolean isArray() {
        return this.array;
    }

    public String toString() {
        if (this.genericType == null) {
            return this.type.toString();
        }
        if (this.genericType instanceof Class) {
            return ((Class)this.genericType).getName();
        }
        return this.genericType.toString();
    }
}

