/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.Ordering;
import org.eclipse.persistence.tools.workbench.utility.node.Node;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;

public final class MWReportOrderingItem
extends MWAttributeItem
implements Ordering {
    private volatile boolean ascending;
    private volatile String itemName;

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWReportOrderingItem.class);
        descriptor.getInheritancePolicy().setParentClass(MWAttributeItem.class);
        ((AbstractDirectMapping)descriptor.addDirectMapping("ascending", "ascending/text()")).setNullValue((Object)Boolean.TRUE);
        descriptor.addDirectMapping("itemName", "item-name/text()");
        return descriptor;
    }

    private MWReportOrderingItem() {
    }

    MWReportOrderingItem(MWReportQuery parent, MWReportAttributeItem attributeItem) {
        super((MWQuery)parent, attributeItem.getQueryableArgument());
        this.itemName = attributeItem.getName();
    }

    MWReportOrderingItem(MWReportQuery parent, MWQueryable queryable) {
        super((MWQuery)parent, queryable);
    }

    MWReportOrderingItem(MWReportQuery parent, Iterator queryables) {
        super((MWQuery)parent, queryables);
    }

    MWReportOrderingItem(MWReportQuery parent, Iterator queryables, Iterator allowsNull) {
        super(parent, queryables, allowsNull);
    }

    @Override
    protected void initialize(Node parentNode) {
        super.initialize(parentNode);
        this.ascending = true;
    }

    @Override
    public boolean isAscending() {
        return this.ascending;
    }

    public boolean isDesending() {
        return !this.isAscending();
    }

    @Override
    public void setAscending(boolean ascending) {
        boolean old = this.ascending;
        this.ascending = ascending;
        this.firePropertyChanged("ascending", old, this.ascending);
    }

    public String getItemName() {
        return this.itemName;
    }

    @Override
    public void removeSelfFromParent() {
        ((MWReportQuery)this.getParentQuery()).removeOrderingItem(this);
    }

    @Override
    public Problem queryableNullProblem() {
        return this.buildProblem("0252", this.getParentQuery().signature(), new Integer(((MWReportQuery)this.getParentQuery()).indexOfOrderingItem(this) + 1));
    }

    @Override
    public Problem queryableInvalidProblem(MWQueryable queryable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isQueryableValid(MWQueryable queryable) {
        return true;
    }

    @Override
    protected void adjustRuntimeQuery(ObjectLevelReadQuery readQuery) {
        MWReportAttributeItem attributeItem;
        ReportQuery reportQuery = (ReportQuery)readQuery;
        Expression expression = this.getQueryableArgument().runtimeExpression(reportQuery.getExpressionBuilder());
        if (this.itemName != null && (attributeItem = this.attributeItem()).getFunction() != "None") {
            expression = attributeItem.getFunction() == "Average" ? expression.average() : (attributeItem.getFunction() == "Count" ? expression.count() : (attributeItem.getFunction() == "Distinct" ? expression.distinct() : (attributeItem.getFunction() == "Maximum" ? expression.maximum() : (attributeItem.getFunction() == "Minimum" ? expression.minimum() : (attributeItem.getFunction() == "Standard Deviation" ? expression.standardDeviation() : (attributeItem.getFunction() == "Sum" ? expression.sum() : (attributeItem.getFunction() == "Variance" ? expression.variance() : expression.getFunction(attributeItem.getFunction()))))))));
        }
        expression = this.isAscending() ? expression.ascending() : expression.descending();
        reportQuery.addOrdering(expression);
    }

    MWReportAttributeItem attributeItem() {
        ListIterator i = ((MWReportQuery)this.getParent()).attributeItems();
        while (i.hasNext()) {
            MWReportAttributeItem item = (MWReportAttributeItem)i.next();
            if (!item.getName().equals(this.itemName)) continue;
            return item;
        }
        return null;
    }

    @Override
    public String displayString() {
        String displayString = this.itemName == null ? super.displayString() : this.itemName;
        displayString = this.isAscending() ? displayString + " (Ascending)" : displayString + " (Descending)";
        return displayString;
    }
}

