/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.handles;

import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.mapping.MWMapping;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWMappingHandle
extends MWHandle {
    private volatile MWMapping mapping;
    private volatile String mappingDescriptorName;
    private volatile String mappingName;

    private MWMappingHandle() {
    }

    public MWMappingHandle(MWModel parent, MWHandle.NodeReferenceScrubber scrubber) {
        super(parent, scrubber);
    }

    public MWMappingHandle(MWModel parent, MWMapping mapping, MWHandle.NodeReferenceScrubber scrubber) {
        super(parent, scrubber);
        this.mapping = mapping;
    }

    public MWMapping getMapping() {
        return this.mapping;
    }

    public void setMapping(MWMapping mapping) {
        this.mapping = mapping;
    }

    @Override
    protected Node node() {
        return this.getMapping();
    }

    public MWMappingHandle setScrubber(MWHandle.NodeReferenceScrubber scrubber) {
        this.setScrubberInternal(scrubber);
        return this;
    }

    @Override
    public void postProjectBuild() {
        MWMappingDescriptor mappingDescriptor;
        super.postProjectBuild();
        if (this.mappingDescriptorName != null && this.mappingName != null && (mappingDescriptor = (MWMappingDescriptor)this.getProject().descriptorNamed(this.mappingDescriptorName)) != null) {
            this.mapping = mappingDescriptor.mappingNamed(this.mappingName);
        }
        this.mappingDescriptorName = null;
        this.mappingName = null;
    }

    public int compareTo(Object o) {
        return this.mapping.compareTo(((MWMappingHandle)o).mapping);
    }

    @Override
    public void toString(StringBuffer sb) {
        if (this.mapping == null) {
            sb.append("null");
        } else {
            this.mapping.toString(sb);
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor descriptor = new XMLDescriptor();
        descriptor.setJavaClass(MWMappingHandle.class);
        descriptor.addDirectMapping("mappingDescriptorName", "getMappingDescriptorNameForToplink", "setMappingDescriptorNameForToplink", "mapping-descriptor-name/text()");
        descriptor.addDirectMapping("mappingName", "getMappingNameForToplink", "setMappingNameForToplink", "mapping-name/text()");
        return descriptor;
    }

    private String getMappingDescriptorNameForToplink() {
        return this.mapping == null ? null : this.mapping.getParentDescriptor().getName();
    }

    private void setMappingDescriptorNameForToplink(String mappingDescriptorName) {
        this.mappingDescriptorName = mappingDescriptorName;
    }

    private String getMappingNameForToplink() {
        return this.mapping == null ? null : this.mapping.getName();
    }

    private void setMappingNameForToplink(String mappingName) {
        this.mappingName = mappingName;
    }
}

