/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.CursoredStream;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.legacy.Employee;

public class CursoredStreamAnyOfTest
extends TestCase {
    public CursoredStreamAnyOfTest() {
        this.setDescription("Verify the size works correctly with distinct through anyOf");
    }

    public void setup() {
        if (this.getSession().getPlatform().isAccess()) {
            throw new TestWarningException("Access does not support distinct in counts.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        ReadAllQuery query = new ReadAllQuery();
        query.setReferenceClass(org.eclipse.persistence.testing.models.employee.domain.Employee.class);
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression exp = builder.anyOf("managedEmployees").get("salary").greaterThan(0);
        query.setSelectionCriteria(exp);
        query.useCursoredStream(1, 1);
        CursoredStream stream = (CursoredStream)this.getSession().executeQuery((DatabaseQuery)query);
        try {
            stream.read(1);
            if (stream.size() != this.getSession().readAllObjects(org.eclipse.persistence.testing.models.employee.domain.Employee.class, exp).size()) {
                throw new TestErrorException("Size is incorrect");
            }
        }
        finally {
            stream.close();
        }
        query = new ReadAllQuery();
        query.setReferenceClass(Employee.class);
        builder = new ExpressionBuilder();
        exp = builder.anyOf("shipments").get("shipmentNumber").equal(10000);
        query.setSelectionCriteria(exp);
        query.useCursoredStream(1, 1);
        stream = (CursoredStream)this.getSession().executeQuery((DatabaseQuery)query);
        try {
            if (stream.size() != this.getSession().readAllObjects(Employee.class, exp).size()) {
                throw new TestErrorException("Size is incorrect");
            }
        }
        finally {
            stream.close();
        }
    }
}

