/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation;

import java.util.GregorianCalendar;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.DailyCacheInvalidationPolicy;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.CacheExpiryTest;

public class CacheExpiryPolicyTest
extends CacheExpiryTest {
    protected boolean shouldObjectExpire = false;
    protected CacheInvalidationPolicy policy = null;
    protected Employee employee = null;

    public CacheExpiryPolicyTest(CacheInvalidationPolicy policy, boolean shouldObjectExpire) {
        this.setDescription("Test Cache Expiry with various kinds of expiry");
        this.shouldObjectExpire = shouldObjectExpire;
        this.policy = policy;
    }

    @Override
    public void setup() {
        super.setup();
        this.getSession().getDescriptor(Employee.class).setCacheInvalidationPolicy(this.policy);
        this.employee = (Employee)this.getSession().readObject(Employee.class);
        GregorianCalendar c1 = new GregorianCalendar();
        if (this.policy instanceof DailyCacheInvalidationPolicy && this.shouldObjectExpire) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException exc) {
                // empty catch block
            }
            GregorianCalendar calendar = new GregorianCalendar();
            ((DailyCacheInvalidationPolicy)this.policy).setExpiryTime(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return;
        }
    }

    public void verify() {
        if (this.getSession().getIdentityMapAccessor().isValid((Object)this.employee) == this.shouldObjectExpire) {
            throw new TestErrorException("Cache Expiry Failed.  Please ensure this system is not running with a heavy load prior to filing a bug since the cache expiry tests rely to a certain degree on timing.");
        }
    }
}

