/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps;

import java.util.Vector;
import junit.framework.Test;
import org.eclipse.persistence.internal.identitymaps.CacheIdentityMap;
import org.eclipse.persistence.internal.identitymaps.FullIdentityMap;
import org.eclipse.persistence.internal.identitymaps.HardCacheWeakIdentityMap;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.identitymaps.NoIdentityMap;
import org.eclipse.persistence.internal.identitymaps.SoftCacheWeakIdentityMap;
import org.eclipse.persistence.internal.identitymaps.SoftIdentityMap;
import org.eclipse.persistence.internal.identitymaps.WeakIdentityMap;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.identitymaps.CleanupCacheKeyCorrectnessTest;
import org.eclipse.persistence.testing.tests.identitymaps.ClearLastAccessedIdentityMapTest;
import org.eclipse.persistence.testing.tests.identitymaps.CreateCacheKeyWeakIdentityMapTest;
import org.eclipse.persistence.testing.tests.identitymaps.DeleteFromIdentityMapTest;
import org.eclipse.persistence.testing.tests.identitymaps.DeleteWithGarbageCollectionTest;
import org.eclipse.persistence.testing.tests.identitymaps.GetSizeRecurseOptionTest;
import org.eclipse.persistence.testing.tests.identitymaps.HardCacheWeakIdentityMapTest;
import org.eclipse.persistence.testing.tests.identitymaps.IdentityWeakHashMapConcurrentModTest;
import org.eclipse.persistence.testing.tests.identitymaps.InitializeIdentityMapByDescriptorJavaClassTest;
import org.eclipse.persistence.testing.tests.identitymaps.InsertWeakIdentityMapTest;
import org.eclipse.persistence.testing.tests.identitymaps.MultipleDeleteFromIdentityMapTest;
import org.eclipse.persistence.testing.tests.identitymaps.MultipleRegisterTest;
import org.eclipse.persistence.testing.tests.identitymaps.ReadSoftCacheWeakIdentityMapTest;
import org.eclipse.persistence.testing.tests.identitymaps.ReadWeakIdentityMapTest;
import org.eclipse.persistence.testing.tests.identitymaps.RegisterInIdentityMapTest;
import org.eclipse.persistence.testing.tests.identitymaps.RemoveFromIdentityMapReturnTest;
import org.eclipse.persistence.testing.tests.identitymaps.SetWriteLockInIdentityMapTest;
import org.eclipse.persistence.testing.tests.identitymaps.TriggerValueHoldersSelfReferencingOneToOneTest;

public class IdentityMapTestSuite
extends TestSuite {
    public IdentityMapTestSuite() {
        this.setDescription("This suite tests the functionality of the identity maps.");
    }

    protected void addMultipleIdentityTests(TestSuite suite, IdentityMap identityMap) {
        Employee employee1 = new Employee();
        Employee employee2 = new Employee();
        Vector primaryKeys = new Vector();
        Vector<Employee> employees = new Vector<Employee>();
        employee1.setFirstName("Wayne");
        employee1.setLastName("Gretzky");
        employee2.setFirstName("Eric");
        employee2.setLastName("Lindros");
        employees.addElement(employee1);
        employees.addElement(employee2);
        Vector<Integer> primaryKey1 = new Vector<Integer>();
        primaryKey1.addElement(new Integer(99));
        Vector<Integer> primaryKey2 = new Vector<Integer>();
        primaryKey2.addElement(new Integer(88));
        primaryKeys.addElement(primaryKey1);
        primaryKeys.addElement(primaryKey2);
        suite.addTest((Test)new MultipleRegisterTest(identityMap, primaryKeys, employees));
        suite.addTest((Test)new MultipleDeleteFromIdentityMapTest(identityMap, primaryKeys, employees, primaryKeys));
    }

    public void addTests() {
        this.addTest((Test)this.getFullIdentityMapSuite());
        this.addTest((Test)this.getNoIdentityMapSuite());
        this.addTest((Test)this.getCacheIdentityMapSuite());
        this.addTest((Test)this.getSoftCacheWeakIdentityMapSuite());
        this.addTest((Test)this.getHardCacheWeakIdentityMapSuite());
        this.addTest((Test)this.getWeakIdentityMapSuite());
        this.addTest((Test)this.getSoftIdentityMapSuite());
        this.addTest((Test)this.getDeleteWithGarbageCollectionTestSuite(new CacheIdentityMap(100)));
        this.addTest((Test)new GetSizeRecurseOptionTest());
        this.addTest((Test)new ClearLastAccessedIdentityMapTest());
        this.addTest((Test)new InitializeIdentityMapByDescriptorJavaClassTest());
        this.addTest((Test)new CleanupCacheKeyCorrectnessTest());
        this.addTest((Test)new TriggerValueHoldersSelfReferencingOneToOneTest());
    }

    private TestSuite getCacheIdentityMapSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("Cache IdentityMap Test Suite");
        suite.setDescription("This suite tests the functionality of the CacheIdentityMap");
        suite.addTest((Test)new RegisterInIdentityMapTest(CacheIdentityMap.class));
        suite.addTest((Test)new DeleteFromIdentityMapTest(CacheIdentityMap.class));
        suite.addTest((Test)new SetWriteLockInIdentityMapTest(CacheIdentityMap.class));
        return suite;
    }

    private TestSuite getFullIdentityMapSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("Full IdentityMap Test Suite");
        suite.setDescription("This suite tests the functionality of the FullIdentityMap");
        suite.addTest((Test)new RegisterInIdentityMapTest(FullIdentityMap.class));
        suite.addTest((Test)new DeleteFromIdentityMapTest(FullIdentityMap.class));
        this.addMultipleIdentityTests(suite, (IdentityMap)new FullIdentityMap(100));
        suite.addTest((Test)new RemoveFromIdentityMapReturnTest());
        suite.addTest((Test)new SetWriteLockInIdentityMapTest(FullIdentityMap.class));
        return suite;
    }

    private TestSuite getHardCacheWeakIdentityMapSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("Hard Cache Weak IdentityMap Test Suite");
        suite.setDescription("This suite tests the functionality of the HardCacheWeakIdentityMap");
        suite.addTest((Test)new RegisterInIdentityMapTest(HardCacheWeakIdentityMap.class));
        suite.addTest((Test)new DeleteFromIdentityMapTest(HardCacheWeakIdentityMap.class));
        this.addMultipleIdentityTests(suite, (IdentityMap)new HardCacheWeakIdentityMap(100, null));
        suite.addTest((Test)new SetWriteLockInIdentityMapTest(HardCacheWeakIdentityMap.class));
        suite.addTest((Test)new HardCacheWeakIdentityMapTest());
        return suite;
    }

    private TestSuite getNoIdentityMapSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("No IdentityMap Test Suite");
        suite.setDescription("This suite tests the functionality of the NoIdentityMap");
        suite.addTest((Test)new RegisterInIdentityMapTest(NoIdentityMap.class));
        suite.addTest((Test)new DeleteFromIdentityMapTest(NoIdentityMap.class));
        suite.addTest((Test)new SetWriteLockInIdentityMapTest(NoIdentityMap.class));
        return suite;
    }

    private TestSuite getSoftCacheWeakIdentityMapSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("Soft Cache Weak IdentityMap Test Suite");
        suite.setDescription("This suite tests the functionality of the SoftCacheWeakIdentityMap");
        suite.addTest((Test)new RegisterInIdentityMapTest(SoftCacheWeakIdentityMap.class));
        suite.addTest((Test)new DeleteFromIdentityMapTest(SoftCacheWeakIdentityMap.class));
        this.addMultipleIdentityTests(suite, (IdentityMap)new SoftCacheWeakIdentityMap(100, null));
        suite.addTest((Test)new SetWriteLockInIdentityMapTest(SoftCacheWeakIdentityMap.class));
        suite.addTest((Test)new ReadSoftCacheWeakIdentityMapTest(SoftCacheWeakIdentityMap.class));
        return suite;
    }

    private TestSuite getWeakIdentityMapSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("Weak IdentityMap Test Suite");
        suite.setDescription("This suite tests the functionality of the WeakIdentityMap");
        suite.addTest((Test)new RegisterInIdentityMapTest(WeakIdentityMap.class));
        suite.addTest((Test)new DeleteFromIdentityMapTest(WeakIdentityMap.class));
        this.addMultipleIdentityTests(suite, (IdentityMap)new WeakIdentityMap(100, null));
        suite.addTest((Test)new SetWriteLockInIdentityMapTest(WeakIdentityMap.class));
        suite.addTest((Test)new ReadWeakIdentityMapTest(WeakIdentityMap.class));
        suite.addTest((Test)new CreateCacheKeyWeakIdentityMapTest());
        suite.addTest((Test)new InsertWeakIdentityMapTest());
        suite.addTest((Test)new IdentityWeakHashMapConcurrentModTest());
        return suite;
    }

    private TestSuite getSoftIdentityMapSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("Soft IdentityMap Test Suite");
        suite.setDescription("This suite tests the functionality of the SoftIdentityMap");
        suite.addTest((Test)new RegisterInIdentityMapTest(SoftIdentityMap.class));
        suite.addTest((Test)new DeleteFromIdentityMapTest(SoftIdentityMap.class));
        this.addMultipleIdentityTests(suite, (IdentityMap)new SoftIdentityMap(100, null));
        suite.addTest((Test)new SetWriteLockInIdentityMapTest(SoftIdentityMap.class));
        return suite;
    }

    private TestSuite getDeleteWithGarbageCollectionTestSuite(CacheIdentityMap cache) {
        TestSuite suite = new TestSuite();
        suite.setName("DeleteWithGarbageCollectionTestSuite");
        suite.setDescription("This suite tests for an error condition in which removal of an object which is garbage collected is attempted.");
        suite.addTest((Test)new DeleteWithGarbageCollectionTest(cache));
        return suite;
    }
}

