/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.oracleddl.test.databasetypebuilder;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.eclipse.persistence.tools.oracleddl.metadata.ArgumentType;
import org.eclipse.persistence.tools.oracleddl.metadata.DatabaseType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLCursorType;
import org.eclipse.persistence.tools.oracleddl.metadata.PLSQLPackageType;
import org.eclipse.persistence.tools.oracleddl.metadata.ProcedureType;
import org.eclipse.persistence.tools.oracleddl.metadata.ROWTYPEType;
import org.eclipse.persistence.tools.oracleddl.metadata.TableType;
import org.eclipse.persistence.tools.oracleddl.test.AllTests;
import org.eclipse.persistence.tools.oracleddl.test.TestHelper;
import org.eclipse.persistence.tools.oracleddl.test.databasetypebuilder.DatabaseTypeBuilderTestSuite;
import org.eclipse.persistence.tools.oracleddl.util.DatabaseTypeBuilder;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class PackagewStronglyTypedCursorDDLTestSuite {
    static final String STRONGLY_TYPED_REF_CURSOR_TABLE = "STRC_TABLE";
    static final String CREATE_STRONGLY_TYPED_REF_CURSOR_TABLE = "CREATE TABLE STRC_TABLE (\nID NUMBER NOT NULL,\nNAME VARCHAR(25),\nSINCE DATE,\nPRIMARY KEY (ID)\n)";
    static final String[] POPULATE_STRONGLY_TYPED_REF_CURSOR_TABLE = new String[]{"INSERT INTO STRC_TABLE (ID, NAME, SINCE) VALUES (1, 'mike', TO_DATE('2001-12-25 00:00:00','YYYY-MM-DD HH24:MI:SS'))", "INSERT INTO STRC_TABLE (ID, NAME, SINCE) VALUES (2, 'blaise', TO_DATE('2002-02-12 00:00:00','YYYY-MM-DD HH24:MI:SS'))", "INSERT INTO STRC_TABLE (ID, NAME, SINCE) VALUES (3, 'rick', TO_DATE('2001-10-30 00:00:00','YYYY-MM-DD HH24:MI:SS'))", "INSERT INTO STRC_TABLE (ID, NAME, SINCE) VALUES (4, 'mikey', TO_DATE('2010-01-01 00:00:00','YYYY-MM-DD HH24:MI:SS'))"};
    static final String STRONGLY_TYPED_REF_CURSOR_PROC = "GET_EMS";
    static final String STRONGLY_TYPED_REF_CURSOR = "STRONGLY_TYPED_REF_CURSOR";
    static final String STRONGLY_TYPED_REF_CURSOR_TEST_PACKAGE = "STRONGLY_TYPED_REF_CURSOR_TEST";
    static final String CREATE_STRONGLY_TYPED_REF_CURSOR_TEST_PACKAGE = "CREATE OR REPLACE PACKAGE STRONGLY_TYPED_REF_CURSOR_TEST AS\nTYPE STRONGLY_TYPED_REF_CURSOR IS REF CURSOR RETURN STRC_TABLE%ROWTYPE;\nPROCEDURE GET_EMS(P_EMS STRC_TABLE.NAME%TYPE, P_EMS_SET OUT STRONGLY_TYPED_REF_CURSOR);\nEND STRONGLY_TYPED_REF_CURSOR_TEST;";
    static final String CREATE_STRONGLY_TYPED_REF_CURSOR_TEST_PACKAGE_BODY = "CREATE OR REPLACE PACKAGE BODY STRONGLY_TYPED_REF_CURSOR_TEST AS\nPROCEDURE GET_EMS(P_EMS STRC_TABLE.NAME%TYPE, P_EMS_SET OUT STRONGLY_TYPED_REF_CURSOR) AS\nBEGIN\n    OPEN P_EMS_SET FOR\n        SELECT ID, NAME, SINCE FROM STRC_TABLE WHERE NAME LIKE P_EMS;\nEND GET_EMS;\nEND STRONGLY_TYPED_REF_CURSOR_TEST;";
    static final String DROP_STRONGLY_TYPED_REF_CURSOR_TEST_PACKAGE = "DROP PACKAGE STRONGLY_TYPED_REF_CURSOR_TEST";
    static final String DROP_STRONGLY_TYPED_REF_CURSOR_TABLE = "DROP TABLE STRC_TABLE";
    static DatabaseTypeBuilder dtBuilder = DatabaseTypeBuilderTestSuite.dtBuilder;
    static Connection conn = AllTests.conn;
    static PLSQLPackageType packageType = null;
    static ProcedureType procType = null;
    static ArgumentType outCursorArg = null;
    static boolean ddlCreate = false;
    static boolean ddlDrop = false;
    static boolean ddlDebug = false;

    @BeforeClass
    public static void setUp() throws SQLException, ClassNotFoundException {
        String ddlDebugProp;
        String ddlDropProp;
        conn = TestHelper.buildConnection();
        dtBuilder = new DatabaseTypeBuilder();
        String ddlCreateProp = System.getProperty("db.ddl.create", "false");
        if ("true".equalsIgnoreCase(ddlCreateProp)) {
            ddlCreate = true;
        }
        if ("true".equalsIgnoreCase(ddlDropProp = System.getProperty("db.ddl.drop", "false"))) {
            ddlDrop = true;
        }
        if ("true".equalsIgnoreCase(ddlDebugProp = System.getProperty("db.ddl.debug", "false"))) {
            ddlDebug = true;
        }
        if (ddlCreate) {
            TestHelper.runDdl(conn, CREATE_STRONGLY_TYPED_REF_CURSOR_TABLE, ddlDebug);
            try {
                Statement stmt = conn.createStatement();
                int i = 0;
                while (i < POPULATE_STRONGLY_TYPED_REF_CURSOR_TABLE.length) {
                    stmt.addBatch(POPULATE_STRONGLY_TYPED_REF_CURSOR_TABLE[i]);
                    ++i;
                }
                stmt.executeBatch();
            }
            catch (SQLException stmt) {
                // empty catch block
            }
            TestHelper.runDdl(conn, CREATE_STRONGLY_TYPED_REF_CURSOR_TEST_PACKAGE, ddlDebug);
            TestHelper.runDdl(conn, CREATE_STRONGLY_TYPED_REF_CURSOR_TEST_PACKAGE_BODY, ddlDebug);
        }
        boolean worked = true;
        String msg = null;
        try {
            String schema = System.getProperty("db.user", "scott");
            packageType = dtBuilder.buildPackages(conn, schema, STRONGLY_TYPED_REF_CURSOR_TEST_PACKAGE).get(0);
        }
        catch (Exception e) {
            worked = false;
            msg = e.getMessage();
        }
        if (!worked) {
            Assert.fail((String)msg);
        }
    }

    @AfterClass
    public static void tearDown() {
        if (ddlDrop) {
            TestHelper.runDdl(conn, DROP_STRONGLY_TYPED_REF_CURSOR_TEST_PACKAGE, ddlDebug);
            TestHelper.runDdl(conn, DROP_STRONGLY_TYPED_REF_CURSOR_TABLE, ddlDebug);
        }
    }

    @Test
    public void testPackageName() {
        Assert.assertEquals((String)"incorrect package name", (Object)STRONGLY_TYPED_REF_CURSOR_TEST_PACKAGE, (Object)packageType.getPackageName());
    }

    @Test
    public void testProcedureName() {
        List<ProcedureType> procedures = packageType.getProcedures();
        Assert.assertTrue((procedures.size() == 1 ? 1 : 0) != 0);
        procType = procedures.get(0);
        Assert.assertEquals((String)"incorrect procedure name", (Object)STRONGLY_TYPED_REF_CURSOR_PROC, (Object)procType.getProcedureName());
    }

    @Test
    public void testProcedureArgs() {
        List<ArgumentType> args = procType.getArguments();
        Assert.assertTrue((args.size() == 2 ? 1 : 0) != 0);
        ArgumentType arg1 = args.get(0);
        Assert.assertEquals((String)"incorrect arg1 name", (Object)"P_EMS", (Object)arg1.getArgumentName());
        ArgumentType arg2 = args.get(1);
        Assert.assertEquals((String)"incorrect arg2 name", (Object)"P_EMS_SET", (Object)arg2.getArgumentName());
    }

    @Test
    public void testProcedureArgNames() {
        List<ArgumentType> args = procType.getArguments();
        Assert.assertTrue((args.size() == 2 ? 1 : 0) != 0);
        ArgumentType arg1 = args.get(0);
        Assert.assertEquals((String)"incorrect arg1 name", (Object)"P_EMS", (Object)arg1.getArgumentName());
        outCursorArg = args.get(1);
        Assert.assertEquals((String)"incorrect outCursorArg name", (Object)"P_EMS_SET", (Object)outCursorArg.getArgumentName());
    }

    @Test
    public void testOutCursorArg() {
        DatabaseType enclosedType = outCursorArg.getEnclosedType();
        Assert.assertTrue((boolean)enclosedType.isPLSQLCursorType());
        PLSQLCursorType cursorType = (PLSQLCursorType)enclosedType;
        Assert.assertEquals((String)"incorrect cursor name", (Object)STRONGLY_TYPED_REF_CURSOR, (Object)cursorType.getCursorName());
        DatabaseType enclosedType2 = cursorType.getEnclosedType();
        Assert.assertNotNull((Object)enclosedType2);
        Assert.assertTrue((boolean)enclosedType2.isROWTYPEType());
        ROWTYPEType rowType = (ROWTYPEType)enclosedType2;
        Assert.assertEquals((String)"incorrect cursor %ROWTYPE name", (Object)"STRC_TABLE%ROWTYPE", (Object)rowType.getTypeName());
        DatabaseType enclosedType3 = rowType.getEnclosedType();
        Assert.assertTrue((boolean)enclosedType3.isTableType());
        TableType tableType = (TableType)enclosedType3;
        Assert.assertEquals((String)"incorrect %ROWTYPE table name", (Object)STRONGLY_TYPED_REF_CURSOR_TABLE, (Object)tableType.getTableName());
    }
}

