/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.fieldaccess.fetchgroups;

import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.eclipse.persistence.config.DescriptorCustomizer;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.EmployeePopulator;
import org.eclipse.persistence.testing.models.jpa.fieldaccess.advanced.EquipmentCode;
import org.eclipse.persistence.testing.tests.jpa.dynamic.QuerySQLTracker;
import org.eclipse.persistence.testing.tests.jpa.fetchgroups.FetchGroupAssert;
import org.junit.Test;

public abstract class BaseFetchGroupTests
extends JUnitTestCase {
    ClassDescriptor employeeDescriptor;
    boolean employeeDescriptorIsIsolatedOriginal;
    ClassDescriptor phoneDescriptor;
    ClassDescriptor addressDescriptor;
    int sessionLogLevelOriginal;
    public static FetchGroup defaultEmployeeFG;
    public static FetchGroup defaultPhoneFG;

    public BaseFetchGroupTests() {
    }

    public BaseFetchGroupTests(String name) {
        super(name);
    }

    public void runBare() throws Throwable {
        if (this.shouldRunTestOnServer()) {
            super.runBare();
        } else if (BaseFetchGroupTests.isWeavingEnabled((String)"fieldaccess")) {
            super.runBare();
        }
    }

    public void setUp() {
        ServerSession session = BaseFetchGroupTests.getServerSession((String)"fieldaccess");
        this.employeeDescriptor = this.getDescriptor("Employee");
        this.phoneDescriptor = this.getDescriptor("PhoneNumber");
        this.addressDescriptor = this.getDescriptor("Address");
        session.getProject().setJPQLParseCacheMaxSize(session.getProject().getJPQLParseCacheMaxSize());
        this.clearFetchGroups(this.employeeDescriptor);
        this.clearFetchGroups(this.phoneDescriptor);
        this.clearFetchGroups(this.addressDescriptor);
        this.reprepareReadQueries(this.employeeDescriptor);
        this.reprepareReadQueries(this.phoneDescriptor);
        this.reprepareReadQueries(this.addressDescriptor);
        BaseFetchGroupTests.assertConfig(this.employeeDescriptor, null, 0);
        BaseFetchGroupTests.assertConfig(this.addressDescriptor, null, 0);
        BaseFetchGroupTests.assertConfig(this.phoneDescriptor, null, 0);
        this.employeeDescriptorIsIsolatedOriginal = this.employeeDescriptor.isIsolated();
        if (this.employeeDescriptorIsIsolatedOriginal) {
            this.employeeDescriptor.setIsIsolated(false);
        }
        BaseFetchGroupTests.clearCache((String)"fieldaccess");
        QuerySQLTracker.install((Session)session);
        this.sessionLogLevelOriginal = session.getLogLevel();
        if (this.sessionLogLevelOriginal > 3) {
            session.setLogLevel(3);
        }
    }

    public void tearDown() {
        ServerSession session = BaseFetchGroupTests.getServerSession((String)"fieldaccess");
        session.getProject().setJPQLParseCacheMaxSize(session.getProject().getJPQLParseCacheMaxSize());
        this.clearFetchGroups(this.employeeDescriptor);
        this.clearFetchGroups(this.phoneDescriptor);
        this.clearFetchGroups(this.addressDescriptor);
        this.clearReadQueries(this.employeeDescriptor);
        this.clearReadQueries(this.phoneDescriptor);
        this.clearReadQueries(this.addressDescriptor);
        if (this.employeeDescriptorIsIsolatedOriginal) {
            this.employeeDescriptor.setIsIsolated(true);
        }
        BaseFetchGroupTests.clearCache((String)"fieldaccess");
        QuerySQLTracker.uninstall((Session)session);
        if (this.sessionLogLevelOriginal != session.getLogLevel()) {
            session.setLogLevel(this.sessionLogLevelOriginal);
        }
    }

    void clearFetchGroups(ClassDescriptor descriptor) {
        FetchGroupManager manager = descriptor.getFetchGroupManager();
        if (manager != null) {
            if (manager.getDefaultFetchGroup() != null) {
                manager.setDefaultFetchGroup(null);
            }
            if (manager.getFetchGroups().size() > 0) {
                manager.getFetchGroups().clear();
            }
        }
    }

    void reprepareReadQueries(ClassDescriptor descriptor) {
        this.reprepareReadQueriesInternal(descriptor, false);
    }

    void clearReadQueries(ClassDescriptor descriptor) {
        this.reprepareReadQueriesInternal(descriptor, true);
    }

    private void reprepareReadQueriesInternal(ClassDescriptor descriptor, boolean shouldClear) {
        ReadObjectQuery olrQuery;
        ServerSession session = BaseFetchGroupTests.getServerSession((String)"fieldaccess");
        if (descriptor.getQueryManager().hasReadObjectQuery()) {
            olrQuery = descriptor.getQueryManager().getReadObjectQuery();
            if (shouldClear) {
                olrQuery.setFetchGroupName(null);
                olrQuery.setShouldUseDefaultFetchGroup(true);
            } else {
                olrQuery.setShouldUseDefaultFetchGroup(olrQuery.shouldUseDefaultFetchGroup());
            }
            descriptor.getQueryManager().getReadObjectQuery().checkPrepare((AbstractSession)session, null);
        }
        if (descriptor.getQueryManager().hasReadAllQuery()) {
            olrQuery = descriptor.getQueryManager().getReadAllQuery();
            if (shouldClear) {
                olrQuery.setFetchGroupName(null);
                olrQuery.setShouldUseDefaultFetchGroup(true);
            } else {
                olrQuery.setShouldUseDefaultFetchGroup(olrQuery.shouldUseDefaultFetchGroup());
            }
            olrQuery.checkPrepare((AbstractSession)session, null);
        }
        descriptor.getQueryManager().setExpressionQueryCacheMaxSize(descriptor.getQueryManager().getExpressionQueryCacheMaxSize());
        for (DatabaseMapping mapping : descriptor.getMappings()) {
            if (!mapping.isForeignReferenceMapping() || !((ForeignReferenceMapping)mapping).getSelectionQuery().isObjectLevelReadQuery()) continue;
            olrQuery = (ObjectLevelReadQuery)((ForeignReferenceMapping)mapping).getSelectionQuery();
            if (shouldClear) {
                olrQuery.setFetchGroupName(null);
                olrQuery.setShouldUseDefaultFetchGroup(true);
            } else {
                olrQuery.setShouldUseDefaultFetchGroup(olrQuery.shouldUseDefaultFetchGroup());
            }
            olrQuery.checkPrepare((AbstractSession)session, null);
        }
    }

    @Test
    public void testSetup() {
        ServerSession session = BaseFetchGroupTests.getServerSession((String)"fieldaccess");
        new AdvancedTableCreator().replaceTables((DatabaseSession)session);
        if (session.getPlatform().isPostgreSQL()) {
            session.getLogin().setShouldForceFieldNamesToUpperCase(true);
        }
        ClassDescriptor descriptor = session.getDescriptor(EquipmentCode.class);
        boolean shouldBeReadOnly = descriptor.shouldBeReadOnly();
        descriptor.setShouldBeReadOnly(false);
        EmployeePopulator employeePopulator = new EmployeePopulator();
        employeePopulator.buildExamples();
        employeePopulator.persistExample((Session)session);
        descriptor.setShouldBeReadOnly(shouldBeReadOnly);
        BaseFetchGroupTests.clearCache((String)"fieldaccess");
    }

    public void managerFetchGroup() throws Exception {
        EntityManager em = BaseFetchGroupTests.createEntityManager((String)"fieldaccess");
        Query query = em.createQuery("SELECT e FROM Employee e WHERE e.id = :ID");
        query.setParameter("ID", (Object)BaseFetchGroupTests.minimumEmployeeId(em));
        FetchGroup managerFG = new FetchGroup();
        managerFG.addAttribute("manager");
        query.setHint("eclipselink.fetch-group", (Object)managerFG);
        BaseFetchGroupTests.assertNotNull((Object)this.getFetchGroup(query));
        BaseFetchGroupTests.assertSame((Object)managerFG, (Object)this.getFetchGroup(query));
        Employee emp = (Employee)query.getSingleResult();
        BaseFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        BaseFetchGroupTests.assertFetchedAttribute(emp, "id");
        BaseFetchGroupTests.assertNotFetchedAttribute(emp, "firstName");
        BaseFetchGroupTests.assertFetchedAttribute(emp, "version");
        BaseFetchGroupTests.assertFetchedAttribute(emp, "manager");
        BaseFetchGroupTests.assertFetchedAttribute(emp, "address");
        BaseFetchGroupTests.assertFetchedAttribute(emp, "phoneNumbers");
        BaseFetchGroupTests.assertFetchedAttribute(emp, "projects");
        emp.getManager();
        BaseFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        emp.getLastName();
        BaseFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
    }

    public void employeeNamesFetchGroup() throws Exception {
        EntityManager em = BaseFetchGroupTests.createEntityManager((String)"fieldaccess");
        int minId = BaseFetchGroupTests.minimumEmployeeId(em);
        BaseFetchGroupTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        Query query = em.createQuery("SELECT e FROM Employee e WHERE e.id = :ID");
        query.setParameter("ID", (Object)minId);
        FetchGroup namesFG = new FetchGroup();
        namesFG.addAttribute("firstName");
        namesFG.addAttribute("lastName");
        query.setHint("eclipselink.fetch-group", (Object)namesFG);
        BaseFetchGroupTests.assertNotNull((Object)this.getFetchGroup(query));
        BaseFetchGroupTests.assertSame((Object)namesFG, (Object)this.getFetchGroup(query));
        Employee emp = (Employee)query.getSingleResult();
        BaseFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        BaseFetchGroupTests.assertFetchedAttribute(emp, "id");
        BaseFetchGroupTests.assertFetchedAttribute(emp, "firstName");
        BaseFetchGroupTests.assertFetchedAttribute(emp, "lastName");
        BaseFetchGroupTests.assertFetchedAttribute(emp, "gender");
        BaseFetchGroupTests.assertFetchedAttribute(emp, "salary");
        BaseFetchGroupTests.assertFetchedAttribute(emp, "version");
        BaseFetchGroupTests.assertFetchedAttribute(emp, "manager");
        BaseFetchGroupTests.assertFetchedAttribute(emp, "address");
        BaseFetchGroupTests.assertFetchedAttribute(emp, "phoneNumbers");
        BaseFetchGroupTests.assertFetchedAttribute(emp, "projects");
        emp.getId();
        emp.getFirstName();
        emp.getLastName();
        emp.getVersion();
        BaseFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        emp.getGender();
        BaseFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        BaseFetchGroupTests.assertFetchedAttribute(emp, "gender");
        BaseFetchGroupTests.assertFetchedAttribute(emp, "salary");
        emp.getSalary();
        BaseFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        emp.getManager();
        BaseFetchGroupTests.assertEquals((int)4, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        BaseFetchGroupTests.assertFetchedAttribute(emp, "manager");
    }

    public void joinFetchEmployeeAddressWithDynamicFetchGroup() {
        EntityManager em = BaseFetchGroupTests.createEntityManager((String)"fieldaccess");
        Query query = em.createQuery("SELECT e FROM Employee e JOIN FETCH e.address");
        FetchGroup fetchGroup = new FetchGroup("names");
        fetchGroup.addAttribute("firstName");
        fetchGroup.addAttribute("lastName");
        query.setHint("eclipselink.fetch-group", (Object)fetchGroup);
        List emps = query.getResultList();
        BaseFetchGroupTests.assertNotNull((Object)emps);
    }

    public void joinFetchEmployeeAddressPhoneWithDynamicFetchGroup() {
        EntityManager em = BaseFetchGroupTests.createEntityManager((String)"fieldaccess");
        Query query = em.createQuery("SELECT e FROM Employee e JOIN FETCH e.address WHERE e.id IN (SELECT p.owner.id FROM PhoneNumber p)");
        FetchGroup fetchGroup = new FetchGroup("names");
        fetchGroup.addAttribute("firstName");
        fetchGroup.addAttribute("lastName");
        query.setHint("eclipselink.fetch-group", (Object)fetchGroup);
        List emps = query.getResultList();
        BaseFetchGroupTests.assertNotNull((Object)emps);
    }

    protected Employee findMinimumEmployee(EntityManager em) {
        List emps = em.createQuery("SELECT e FROM Employee e WHERE e.id in (SELECT MIN(ee.id) FROM Employee ee)").getResultList();
        BaseFetchGroupTests.assertNotNull((String)"Null returned for min employee query", (Object)emps);
        BaseFetchGroupTests.assertEquals((String)"No results returned for Mmin employee query", (int)1, (int)emps.size());
        return (Employee)emps.get(0);
    }

    public FetchGroup assertHasFetchGroup(Object entity) {
        BaseFetchGroupTests.assertNotNull((String)"Entity is null", (Object)entity);
        BaseFetchGroupTests.assertTrue((String)"Entity does not implement FetchGroupTracker", (boolean)(entity instanceof FetchGroupTracker));
        BaseFetchGroupTests.assertNotNull((String)"Entity does not have FetchGroup", (Object)((FetchGroupTracker)entity)._persistence_getFetchGroup());
        return ((FetchGroupTracker)entity)._persistence_getFetchGroup();
    }

    protected FetchGroup getFetchGroup(Object object) {
        BaseFetchGroupTests.assertNotNull((String)"Cannot get a FetchGroup from null", (Object)object);
        if (object instanceof Query) {
            return this.getFetchGroup((Query)object);
        }
        if (object instanceof ObjectLevelReadQuery) {
            return this.getExecutionFetchGroup((ObjectLevelReadQuery)object);
        }
        BaseFetchGroupTests.assertTrue((String)("Entity " + object + " does not implement FetchGroupTracker"), (boolean)(object instanceof FetchGroupTracker));
        FetchGroupTracker tracker = (FetchGroupTracker)object;
        return tracker._persistence_getFetchGroup();
    }

    protected FetchGroup getFetchGroup(Query query) {
        return this.getFetchGroup((ObjectLevelReadQuery)JpaHelper.getDatabaseQuery((Query)query));
    }

    protected FetchGroup getFetchGroup(ObjectLevelReadQuery readQuery) {
        return readQuery.getFetchGroup();
    }

    protected FetchGroup getExecutionFetchGroup(Query query) {
        return this.getExecutionFetchGroup((ObjectLevelReadQuery)JpaHelper.getDatabaseQuery((Query)query));
    }

    protected FetchGroup getExecutionFetchGroup(ObjectLevelReadQuery readQuery) {
        return readQuery.getExecutionFetchGroup();
    }

    public static void assertFetchedAttribute(Object entity, String ... attribute) {
        FetchGroupAssert.assertFetchedAttribute(BaseFetchGroupTests.getEntityManagerFactory((String)"fieldaccess"), entity, attribute);
    }

    public static void assertNotFetchedAttribute(Object entity, String ... attribute) {
        FetchGroupAssert.assertNotFetchedAttribute(BaseFetchGroupTests.getEntityManagerFactory((String)"fieldaccess"), entity, attribute);
    }

    public static void assertFetched(Object entity, FetchGroup fetchGroup) {
        FetchGroupAssert.assertFetched(BaseFetchGroupTests.getEntityManagerFactory((String)"fieldaccess"), entity, fetchGroup);
    }

    public static void assertDefaultFetched(Object entity) {
        FetchGroupAssert.assertDefaultFetched(BaseFetchGroupTests.getEntityManagerFactory((String)"fieldaccess"), entity);
    }

    public static void assertFetched(Object entity, String fetchGroupName) {
        FetchGroupAssert.assertFetched(BaseFetchGroupTests.getEntityManagerFactory((String)"fieldaccess"), entity, fetchGroupName);
    }

    public static void assertNoFetchGroup(Object entity) {
        FetchGroupAssert.assertNoFetchGroup(BaseFetchGroupTests.getEntityManagerFactory((String)"fieldaccess"), entity);
    }

    public static void assertConfig(String entityName, FetchGroup defaultFetchGroup) {
        FetchGroupAssert.assertConfig(BaseFetchGroupTests.getEntityManagerFactory((String)"fieldaccess"), entityName, defaultFetchGroup);
    }

    public static void assertConfig(String entityName, FetchGroup defaultFetchGroup, int numNamedFetchGroups) {
        FetchGroupAssert.assertConfig(BaseFetchGroupTests.getEntityManagerFactory((String)"fieldaccess"), entityName, defaultFetchGroup, numNamedFetchGroups);
    }

    public static void assertConfig(ClassDescriptor descriptor, FetchGroup defaultFetchGroup) {
        FetchGroupAssert.assertConfig(descriptor, defaultFetchGroup);
    }

    public static void assertConfig(ClassDescriptor descriptor, FetchGroup defaultFetchGroup, int numNamedFetchGroups) {
        FetchGroupAssert.assertConfig(descriptor, defaultFetchGroup, numNamedFetchGroups);
    }

    protected QuerySQLTracker getQuerySQLTracker(EntityManager em) {
        return QuerySQLTracker.getTracker((Session)BaseFetchGroupTests.getServerSession((String)"fieldaccess"));
    }

    ClassDescriptor getDescriptor(String entityName) {
        return BaseFetchGroupTests.getServerSession((String)"fieldaccess").getClassDescriptorForAlias(entityName);
    }

    public static int minimumEmployeeId(EntityManager em) {
        return ((Number)em.createQuery("SELECT MIN(e.id) FROM Employee e").getSingleResult()).intValue();
    }

    public static int minimumEmployeeWithoutDepartmentId(EntityManager em) {
        return ((Number)em.createQuery("SELECT MIN(e.id) FROM Employee e WHERE e.department IS NULL").getSingleResult()).intValue();
    }

    public static Employee minimumEmployee(EntityManager em) {
        Query q = em.createQuery("SELECT e FROM Employee e WHERE e.id in (SELECT MIN(ee.id) FROM Employee ee)");
        return (Employee)q.getSingleResult();
    }

    public static Employee minimumEmployee(EntityManager em, Map<String, Object> hints) {
        Query q = em.createQuery("SELECT e FROM Employee e WHERE e.id in (SELECT MIN(ee.id) FROM Employee ee)");
        for (Map.Entry<String, Object> entry : hints.entrySet()) {
            q.setHint(entry.getKey(), entry.getValue());
        }
        return (Employee)q.getSingleResult();
    }

    public static Employee minEmployeeWithAddressAndPhones(EntityManager em) {
        return (Employee)em.createQuery("SELECT e FROM Employee e JOIN FETCH e.address WHERE e.id IN (SELECT MIN(p.owner.id) FROM PhoneNumber p)").getSingleResult();
    }

    public Employee minEmployeeWithManagerWithAddress(EntityManager em) {
        List emps = em.createQuery("SELECT e FROM Employee e JOIN FETCH e.manager WHERE e.manager.address IS NOT NULL ORDER BY e.id").getResultList();
        return (Employee)emps.get(0);
    }

    public static int minEmployeeIdWithAddressAndPhones(EntityManager em) {
        return ((Number)em.createQuery("SELECT e.id FROM Employee e JOIN FETCH e.address WHERE e.id IN (SELECT MIN(p.owner.id) FROM PhoneNumber p)").getSingleResult()).intValue();
    }

    public static class PhoneCustomizer
    implements DescriptorCustomizer {
        public void customize(ClassDescriptor descriptor) throws Exception {
            defaultPhoneFG = new FetchGroup("PhoneNumber.default");
            defaultPhoneFG.addAttribute("number");
            descriptor.getFetchGroupManager().setDefaultFetchGroup(defaultPhoneFG);
        }
    }
}

