/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork.transactionisolation;

import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class TransactionIsolationNoNewObjectsTest
extends AutoVerifyTestCase {
    UnitOfWork unitOfWork;

    protected void setup() throws Exception {
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.unitOfWork = this.getSession().acquireUnitOfWork();
    }

    public void reset() throws Exception {
        if (this.unitOfWork != null) {
            this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
            this.unitOfWork.release();
            this.unitOfWork = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        Employee employee = new Employee();
        Employee newClone = (Employee)this.unitOfWork.registerObject((Object)employee);
        this.unitOfWork.writeChanges();
        UnitOfWorkImpl parallelUow = this.unitOfWork.getParent().acquireUnitOfWork();
        parallelUow.beginEarlyTransaction();
        try {
            Employee newCloneInParallelUow = (Employee)parallelUow.readObject((Object)newClone);
            this.strongAssert(newCloneInParallelUow != null, "As the parallel Uow shares the same write connection, should be able to see parallel objects.");
        }
        finally {
            parallelUow.release();
        }
        ReadObjectQuery cacheQuery = new ReadObjectQuery(Employee.class);
        cacheQuery.checkCacheOnly();
        Employee original = (Employee)this.getSession().executeQuery((DatabaseQuery)cacheQuery);
        this.strongAssert(original == null, "Reading back a new object from the write connection should not have cached objects in the shared cache. " + original);
    }
}

