/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.sessionsxml;

import junit.framework.Test;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.tests.sessionsxml.FailoverLoginSettingsTest;
import org.eclipse.persistence.testing.tests.sessionsxml.JavaLogSessionsXMLTest;
import org.eclipse.persistence.testing.tests.sessionsxml.MWConfigModelEncryptionTest;
import org.eclipse.persistence.testing.tests.sessionsxml.RCMWithJmsTopicTest;
import org.eclipse.persistence.testing.tests.sessionsxml.RcmEncryptedPasswordTest;
import org.eclipse.persistence.testing.tests.sessionsxml.RcmWithRmiAndJndiTest;
import org.eclipse.persistence.testing.tests.sessionsxml.RcmWithRmiAndRmiRegistryTest;
import org.eclipse.persistence.testing.tests.sessionsxml.RcmWithTransportClassTest;
import org.eclipse.persistence.testing.tests.sessionsxml.SessionManagerGetMultipleSessionsTest;
import org.eclipse.persistence.testing.tests.sessionsxml.SessionManagerGetSessionNotFoundTest;
import org.eclipse.persistence.testing.tests.sessionsxml.SessionManagerGetSessionStringStringTest;
import org.eclipse.persistence.testing.tests.sessionsxml.SessionsXMLSchemaDefaultValueTest;
import org.eclipse.persistence.testing.tests.sessionsxml.SessionsXMLSchemaIncorrectTagValuesTest;
import org.eclipse.persistence.testing.tests.sessionsxml.SessionsXMLSchemaInvalidTagTest;
import org.eclipse.persistence.testing.tests.sessionsxml.SessionsXMLSchemaJBossPlatformTest;
import org.eclipse.persistence.testing.tests.sessionsxml.SessionsXMLSchemaJavaLogTest;
import org.eclipse.persistence.testing.tests.sessionsxml.SessionsXMLSchemaLoggingOptionsTest;
import org.eclipse.persistence.testing.tests.sessionsxml.SessionsXMLSchemaMisplacedDependentTagTest;
import org.eclipse.persistence.testing.tests.sessionsxml.SessionsXMLSchemaNoLoggingTest;
import org.eclipse.persistence.testing.tests.sessionsxml.SessionsXMLSchemaProjectXMLTest;
import org.eclipse.persistence.testing.tests.sessionsxml.SessionsXMLSchemaReloadTest;
import org.eclipse.persistence.testing.tests.sessionsxml.SessionsXMLSchemaSequencingTest;
import org.eclipse.persistence.testing.tests.sessionsxml.SessionsXMLSchemaSunCORBATransportConfigTest;
import org.eclipse.persistence.testing.tests.sessionsxml.SessionsXMLSchemaTest;
import org.eclipse.persistence.testing.tests.sessionsxml.SessionsXMLSchemaWeblogicPlatformTest;
import org.eclipse.persistence.testing.tests.sessionsxml.SessionsXMLSchemaWebsphere61PlatformTest;
import org.eclipse.persistence.testing.tests.sessionsxml.SessionsXMLServerSessionSchemaTest;
import org.eclipse.persistence.testing.tests.sessionsxml.SessionsXMLSessionEventListenerTest;

public class SessionsXMLTestModel
extends TestModel {
    public SessionsXMLTestModel() {
        this.setDescription("This model tests the Sessions XML feature.");
    }

    public SessionsXMLTestModel(boolean isSRG) {
        this();
        this.isSRG = isSRG;
    }

    public void addTests() {
        this.addTest((Test)this.getSessionsXMLLoadingTestSuite());
        this.addTest((Test)this.getSessionsXMLRCMTestSuite());
        this.addTest((Test)this.getSessionManagerTestSuite());
        this.addTest((Test)this.getSessionXMLSchemaTestSuite());
    }

    public void addSRGTests() {
        this.addTest((Test)this.getSRGSessionXMLSchemaTestSuite());
    }

    public TestSuite getSessionsXMLLoadingTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("Sessions.xml standard loading tests");
        suite.addTest((Test)new JavaLogSessionsXMLTest());
        return suite;
    }

    public TestSuite getSessionXMLSchemaTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("XML Schema tests");
        suite.addTest((Test)new SessionsXMLSchemaTest());
        this.addSessionsXMLSchemaWriteTest(suite);
        suite.addTest((Test)new SessionsXMLSchemaNoLoggingTest());
        suite.addTest((Test)new SessionsXMLSchemaDefaultValueTest());
        suite.addTest((Test)new SessionsXMLServerSessionSchemaTest());
        suite.addTest((Test)new SessionsXMLSessionEventListenerTest());
        if (!this.getExecutor().isServer) {
            suite.addTest((Test)new SessionsXMLSchemaReloadTest());
        }
        suite.addTest((Test)new SessionsXMLSchemaSunCORBATransportConfigTest());
        suite.addTest((Test)new SessionsXMLSchemaJavaLogTest());
        suite.addTest((Test)new SessionsXMLSchemaSequencingTest());
        suite.addTest((Test)new SessionsXMLSchemaInvalidTagTest());
        suite.addTest((Test)new SessionsXMLSchemaMisplacedDependentTagTest());
        suite.addTest((Test)new SessionsXMLSchemaIncorrectTagValuesTest());
        suite.addTest((Test)new SessionsXMLSchemaProjectXMLTest());
        suite.addTest((Test)new SessionsXMLSchemaWebsphere61PlatformTest());
        suite.addTest((Test)new SessionsXMLSchemaWeblogicPlatformTest());
        suite.addTest((Test)new SessionsXMLSchemaLoggingOptionsTest());
        suite.addTest((Test)new SessionsXMLSchemaJBossPlatformTest());
        suite.addTest((Test)new SessionManagerGetMultipleSessionsTest());
        suite.addTest((Test)new FailoverLoginSettingsTest());
        return suite;
    }

    public TestSuite getSRGSessionXMLSchemaTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("XML Schema tests");
        suite.addTest((Test)new SessionsXMLSchemaTest());
        this.addSessionsXMLSchemaWriteTest(suite);
        return suite;
    }

    public TestSuite getSessionsXMLRCMTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("sessions.xml with RCM loading tests");
        suite.addTest((Test)new RcmWithRmiAndJndiTest());
        suite.addTest((Test)new RcmWithRmiAndRmiRegistryTest());
        suite.addTest((Test)new RcmWithTransportClassTest());
        suite.addTest((Test)new RcmEncryptedPasswordTest());
        suite.addTest((Test)new RCMWithJmsTopicTest());
        return suite;
    }

    public TestSuite getSessionManagerTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("SessionManager tests");
        suite.addTest((Test)new SessionManagerGetSessionStringStringTest());
        suite.addTest((Test)new SessionManagerGetSessionNotFoundTest());
        suite.addTest((Test)new MWConfigModelEncryptionTest());
        return suite;
    }

    public void addSessionsXMLSchemaWriteTest(TestSuite suite) {
        block2: {
            try {
                Class<?> testCaseClass = Class.forName("org.eclipse.persistence.testing.tests.sessionsxml.SessionsXMLSchemaWriteTest");
                Test testCase = (Test)testCaseClass.newInstance();
                suite.addTest(testCase);
            }
            catch (Exception e) {
                this.getSession().logMessage("Unable to load SessionsXMLSchemaWriteTest.  This usually occurs when the tests were compiled  on a non-Oracle environment. If you are not running on Oracle, this is not a problem.");
                if (!this.getSession().getPlatform().isOracle()) break block2;
                throw new TestProblemException("Could not load: SessionsXMLSchemaWriteTest", (Throwable)e);
            }
        }
    }
}

