/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.options;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ScrollableCursor;
import org.eclipse.persistence.queries.ScrollableCursorPolicy;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.tests.queries.options.QueryOptionEmployee;

public class ClearQueryOptionsOnStatementTest
extends AutoVerifyTestCase {
    private List employeesCreated;
    protected boolean TYPE_SCROLL_INSENSITIVE_isSupported;
    protected boolean CONCUR_UPDATABLE_isSupported;

    public ClearQueryOptionsOnStatementTest() {
        this.setDescription("This test verifies max rows, query timeout & result set fetch size are cleared on prepared statements");
    }

    public void setup() {
        this.TYPE_SCROLL_INSENSITIVE_isSupported = true;
        this.CONCUR_UPDATABLE_isSupported = true;
        if (this.getSession().getPlatform().isSQLServer()) {
            this.TYPE_SCROLL_INSENSITIVE_isSupported = false;
            this.CONCUR_UPDATABLE_isSupported = false;
        }
        this.getDatabaseSession().getLogin().cacheAllStatements();
        this.getDatabaseSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        UnitOfWork uow = this.getDatabaseSession().acquireUnitOfWork();
        this.employeesCreated = new ArrayList(10);
        this.employeesCreated.add(new QueryOptionEmployee(new BigDecimal(190), "Jak"));
        this.employeesCreated.add(new QueryOptionEmployee(new BigDecimal(191), "Daxter"));
        this.employeesCreated.add(new QueryOptionEmployee(new BigDecimal(192), "Ratchet"));
        this.employeesCreated.add(new QueryOptionEmployee(new BigDecimal(193), "Clank"));
        this.employeesCreated.add(new QueryOptionEmployee(new BigDecimal(194), "Crash"));
        this.employeesCreated.add(new QueryOptionEmployee(new BigDecimal(195), "Sonic"));
        this.employeesCreated.add(new QueryOptionEmployee(new BigDecimal(196), "Mario"));
        this.employeesCreated.add(new QueryOptionEmployee(new BigDecimal(197), "Luigi"));
        this.employeesCreated.add(new QueryOptionEmployee(new BigDecimal(198), "Peach"));
        this.employeesCreated.add(new QueryOptionEmployee(new BigDecimal(199), "Bowser"));
        uow.registerAllObjects((Collection)this.employeesCreated);
        uow.commit();
    }

    public void test() {
        DatabaseSession session = this.getDatabaseSession();
        this.testQueryTimeoutReset((Session)session);
        this.testMaxRowsReset((Session)session);
        this.testResultSetFetchSizeReset((Session)session);
    }

    public void testMaxRowsReset(Session session) {
        ReadAllQuery query = new ReadAllQuery(QueryOptionEmployee.class);
        query.setMaxRows(4);
        List employees = (List)session.executeQuery((DatabaseQuery)query);
        if (employees.size() != 4) {
            throw new TestErrorException("Max Rows reset - Rows returned: " + employees.size() + " (expecting 4)");
        }
        for (int iteration = 0; iteration < 100; ++iteration) {
            query = new ReadAllQuery(QueryOptionEmployee.class);
            employees = (List)session.executeQuery((DatabaseQuery)query);
            if (employees.size() > 4) continue;
            throw new TestErrorException("Max Rows reset - Rows returned: " + employees.size() + " (expecting >= 10)");
        }
    }

    public void testResultSetFetchSizeReset(Session session) {
        if (this.getSession().getLogin().getDatasourcePlatform().isH2()) {
            return;
        }
        ReadAllQuery query = new ReadAllQuery(QueryOptionEmployee.class);
        if (this.TYPE_SCROLL_INSENSITIVE_isSupported && this.CONCUR_UPDATABLE_isSupported) {
            query.useScrollableCursor(2);
        } else {
            ScrollableCursorPolicy policy = new ScrollableCursorPolicy();
            if (!this.TYPE_SCROLL_INSENSITIVE_isSupported) {
                policy.setResultSetType(1005);
            }
            if (!this.CONCUR_UPDATABLE_isSupported) {
                policy.setResultSetConcurrency(1007);
            }
            policy.setPageSize(10);
            query.useScrollableCursor(policy);
        }
        String sql = "SELECT ID, NAME, HISTORY_ID FROM QUERY_OPTION_EMPLOYEE";
        int fetchSize = 100;
        query.setSQLString(sql);
        query.setFetchSize(fetchSize);
        DatabaseSessionImpl impl = (DatabaseSessionImpl)session;
        DatabaseAccessor accessor = (DatabaseAccessor)impl.getAccessor();
        Map statementCache = null;
        try {
            Method method = PrivilegedAccessHelper.getDeclaredMethod(DatabaseAccessor.class, (String)"getStatementCache", (Class[])new Class[0]);
            method.setAccessible(true);
            statementCache = (Map)method.invoke((Object)accessor, new Object[0]);
        }
        catch (Exception nsme) {
            this.throwError("Could not invoke DatabaseAccessor>>getStatementCache()", nsme);
        }
        int previousFetchSize = 0;
        Statement statement = (Statement)statementCache.get(sql);
        if (statement != null) {
            try {
                previousFetchSize = statement.getFetchSize();
            }
            catch (SQLException sqle) {
                this.throwError("Error whilst invoking intial Statement>>getFetchSize()", sqle);
            }
        }
        ScrollableCursor cursor = (ScrollableCursor)session.executeQuery((DatabaseQuery)query);
        ArrayList<Object> employees = new ArrayList<Object>();
        while (cursor.hasNext()) {
            employees.add(cursor.next());
        }
        cursor.close();
        int postQueryFetchSize = 0;
        statement = (Statement)statementCache.get(sql);
        if (statement != null) {
            try {
                postQueryFetchSize = statement.getFetchSize();
            }
            catch (SQLException sqle) {
                this.throwError("Error whilst invoking secondary Statement>>getFetchSize()", sqle);
            }
        }
        if (postQueryFetchSize == fetchSize) {
            this.throwError("Statement fetch size was not reset");
        }
    }

    public void testQueryTimeoutReset(Session session) {
        boolean query2TimedOut;
        block8: {
            DataReadQuery query;
            String sql;
            block7: {
                if (this.getSession().getPlatform().isSymfoware()) {
                    this.throwWarning("Test testQueryTimeoutReset skipped for this platform, the driver does not support query timeout. (bug 304905)");
                }
                boolean query1TimedOut = false;
                query2TimedOut = false;
                if (this.getSession().getLogin().getDatasourcePlatform().isH2()) {
                    return;
                }
                sql = this.getSession().getLogin().getDatasourcePlatform().isDB2() || this.getSession().getLogin().getDatasourcePlatform().isMySQL() ? "SELECT SUM(e.EMP_ID) from EMPLOYEE e , EMPLOYEE b, EMPLOYEE c,EMPLOYEE d" : "SELECT SUM(e.EMP_ID) from EMPLOYEE a , EMPLOYEE b, EMPLOYEE c, EMPLOYEE d, EMPLOYEE e, EMPLOYEE f, EMPLOYEE g";
                try {
                    query = new DataReadQuery();
                    query.setSQLString(sql);
                    query.setQueryTimeout(1);
                    session.executeQuery((DatabaseQuery)query);
                }
                catch (Exception e) {
                    if (!(e instanceof DatabaseException)) break block7;
                    query1TimedOut = true;
                }
            }
            try {
                query = new DataReadQuery();
                query.setSQLString(sql);
                session.executeQuery((DatabaseQuery)query);
            }
            catch (Exception e) {
                if (!(e instanceof DatabaseException)) break block8;
                query2TimedOut = true;
            }
        }
        if (query2TimedOut) {
            throw new TestErrorException("Query timeout occurred - PreparedStatement query timeout setting not cleared");
        }
    }

    public void reset() {
        this.getDatabaseSession().getLogin().dontCacheAllStatements();
        UnitOfWork uow = this.getDatabaseSession().acquireUnitOfWork();
        uow.deleteAllObjects((Collection)this.employeesCreated);
        uow.commit();
        this.getDatabaseSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

