/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation;

import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.NoExpiryCacheInvalidationPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.identitymaps.cacheinvalidation.CacheExpiryTest;

public class NoExpiryInvalidationTest
extends CacheExpiryTest {
    protected String firstName = null;
    protected Employee employee = null;

    public NoExpiryInvalidationTest() {
        this.setDescription("Test the invalidation API with a NoExpiryCacheExpiryPolicy.");
    }

    @Override
    public void setup() {
        super.setup();
        this.getSession().getDescriptor(Employee.class).setCacheInvalidationPolicy((CacheInvalidationPolicy)new NoExpiryCacheInvalidationPolicy());
    }

    public void test() {
        this.employee = (Employee)this.getSession().readObject(Employee.class);
        Employee empFromCache = (Employee)((AbstractSession)this.getSession()).getIdentityMapAccessorInstance().getCacheKeyForObject((Object)this.employee).getObject();
        this.firstName = empFromCache.getFirstName();
        empFromCache.setFirstName(empFromCache.getFirstName() + "-mutated");
        this.getAbstractSession().getIdentityMapAccessor().invalidateObject((Object)this.employee);
        this.employee = (Employee)this.getSession().readObject((Object)this.employee);
    }

    public void verify() {
        if (!this.employee.getFirstName().equals(this.firstName)) {
            throw new TestErrorException("Invalidation did not work with NoExpiryCacheExpiryPolicy.");
        }
    }
}

