/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.employee;

import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.employee.domain.SmallProject;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeProject;

public class AddDescriptorsTest
extends AutoVerifyTestCase {
    ClassDescriptor oldProjectDescriptor;
    ClassDescriptor newProjectDescriptor;

    public AddDescriptorsTest() {
        this.setDescription("Tests DatabaseSession.addDescriptors() method");
    }

    public void reset() {
        if (this.newProjectDescriptor == this.oldProjectDescriptor) {
            for (Class cls : this.getSession().getDescriptors().keySet()) {
                String packageName = Helper.getPackageName((Class)cls);
                if (!packageName.equals("org.eclipse.persistence.testing.models.employee.interfaces")) continue;
                this.getSession().getDescriptors().remove(cls);
            }
            this.getDatabaseSession().addDescriptors((Project)new EmployeeProject());
        }
    }

    public void setup() {
        this.oldProjectDescriptor = this.getSession().getClassDescriptor(org.eclipse.persistence.testing.models.employee.domain.Project.class);
        if (this.oldProjectDescriptor == null) {
            throw new TestWarningException("Test requires EmployeeTestSystem.");
        }
    }

    public void test() {
        this.getDatabaseSession().addDescriptors((Project)new EmployeeProject());
    }

    public void verify() {
        this.newProjectDescriptor = this.getSession().getDescriptor(SmallProject.class).getInheritancePolicy().getParentDescriptor();
        if (this.newProjectDescriptor == this.oldProjectDescriptor) {
            throw new TestErrorException("The old descriptor for Project.class is referenced from SmallProject.inheritancePolicy ");
        }
    }
}

