/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.utility.classfile;

import java.io.IOException;
import org.eclipse.persistence.tools.workbench.utility.classfile.Attribute;
import org.eclipse.persistence.tools.workbench.utility.classfile.AttributePool;
import org.eclipse.persistence.tools.workbench.utility.classfile.Visitor;
import org.eclipse.persistence.tools.workbench.utility.classfile.tools.ClassFileDataInputStream;
import org.eclipse.persistence.tools.workbench.utility.io.IndentingPrintWriter;

public class SourceFileAttribute
extends Attribute {
    private short sourceFileIndex;

    SourceFileAttribute(ClassFileDataInputStream stream, short nameIndex, AttributePool pool) throws IOException {
        super(stream, nameIndex, pool);
    }

    @Override
    void initializeInfo(ClassFileDataInputStream stream) throws IOException {
        this.sourceFileIndex = stream.readU2();
    }

    @Override
    void displayInfoStringOn(IndentingPrintWriter writer) {
        writer.println(this.sourceFileName());
    }

    @Override
    public String sourceFileName() {
        return this.constantPool().getUTF8String(this.sourceFileIndex);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public short getSourceFileIndex() {
        return this.sourceFileIndex;
    }

    @Override
    void toString(StringBuffer sb) {
        sb.append(this.sourceFileName());
    }
}

