/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.persistence.tools.workbench.uitools.app.AspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.utility.Model;

public abstract class PropertyAspectAdapter
extends AspectAdapter
implements PropertyValueModel {
    protected Object value;
    protected String[] propertyNames;
    protected PropertyChangeListener propertyChangeListener;

    protected PropertyAspectAdapter(String propertyName, Model subject) {
        this(new String[]{propertyName}, subject);
    }

    protected PropertyAspectAdapter(String[] propertyNames, Model subject) {
        super(subject);
        this.propertyNames = propertyNames;
    }

    protected PropertyAspectAdapter(ValueModel subjectHolder, String propertyName) {
        this(subjectHolder, new String[]{propertyName});
    }

    protected PropertyAspectAdapter(ValueModel subjectHolder, String propertyName1, String propertyName2) {
        this(subjectHolder, new String[]{propertyName1, propertyName2});
    }

    protected PropertyAspectAdapter(ValueModel subjectHolder, String propertyName1, String propertyName2, String propertyName3) {
        this(subjectHolder, new String[]{propertyName1, propertyName2, propertyName3});
    }

    protected PropertyAspectAdapter(ValueModel subjectHolder, String[] propertyNames) {
        super(subjectHolder);
        this.propertyNames = propertyNames;
    }

    protected PropertyAspectAdapter(ValueModel subjectHolder, Collection propertyNames) {
        this(subjectHolder, propertyNames.toArray(new String[propertyNames.size()]));
    }

    protected PropertyAspectAdapter(ValueModel subjectHolder) {
        this(subjectHolder, new String[0]);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.value = null;
        this.propertyChangeListener = this.buildPropertyChangeListener();
    }

    protected PropertyChangeListener buildPropertyChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                PropertyAspectAdapter.this.propertyChanged();
            }

            public String toString() {
                return "property change listener: " + Arrays.asList(PropertyAspectAdapter.this.propertyNames);
            }
        };
    }

    @Override
    public final Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        if (this.subject != null) {
            this.setValueOnSubject(value);
        }
    }

    protected void setValueOnSubject(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean hasListeners() {
        return this.hasAnyPropertyChangeListeners("value");
    }

    @Override
    protected void fireAspectChange(Object oldValue, Object newValue) {
        this.firePropertyChanged("value", oldValue, newValue);
    }

    @Override
    protected void engageSubject() {
        super.engageSubject();
        this.value = this.buildValue();
    }

    @Override
    protected void engageNonNullSubject() {
        int i = this.propertyNames.length;
        while (i-- > 0) {
            ((Model)this.subject).addPropertyChangeListener(this.propertyNames[i], this.propertyChangeListener);
        }
    }

    @Override
    protected void disengageSubject() {
        super.disengageSubject();
        this.value = null;
    }

    @Override
    protected void disengageNonNullSubject() {
        int i = this.propertyNames.length;
        while (i-- > 0) {
            ((Model)this.subject).removePropertyChangeListener(this.propertyNames[i], this.propertyChangeListener);
        }
    }

    public void toString(StringBuffer sb) {
        for (int i = 0; i < this.propertyNames.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(this.propertyNames[i]);
        }
    }

    protected Object buildValue() {
        if (this.subject == null) {
            return null;
        }
        return this.getValueFromSubject();
    }

    protected Object getValueFromSubject() {
        throw new UnsupportedOperationException();
    }

    protected void propertyChanged() {
        Object old = this.value;
        this.value = this.buildValue();
        this.fireAspectChange(old, this.value);
    }
}

