/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.persistence.internal.sessions.factories.model.login.AppendNewElementsOrderingPolicyConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.DescriptorLevelDocumentPreservationPolicyConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.DocumentPreservationPolicyConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.IgnoreNewElementsOrderingPolicyConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.LoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.NoDocumentPreservationPolicyConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.NodeOrderingPolicyConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.RelativePositionOrderingPolicyConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.XMLBinderPolicyConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.XMLLoginConfig;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.LoginAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;

public final class XMLLoginAdapter
extends LoginAdapter {
    public static final String EQUAL_NAMESPACE_RESOLVERS_PROPERTY = "equalNamespaceResolvers";
    public static final String DOCUMENT_PRESERVATION_POLICY_PROPERTY = "documentPreservationPolicy";
    public static final String DESCRIPTOR_LEVEL_DOCUMENT_PRESERVATION_POLICY = "Descriptor Level";
    public static final String NO_DOCUMENT_PRESERVATION_POLICY = "No Document";
    public static final String XML_BINDER_PRESERVATION_POLICY = "XML Binder";
    public static final String NODE_ORDERING_POLICY_PROPERTY = "nodeOrderingPolicy";
    public static final String APPEND_NEW_ELEMENTS = "Append New Elements";
    public static final String IGNORE_NEW_ELEMENTS = "Ignore New Elements";
    public static final String RELATIVE_POSITION = "Relative Position";
    public static final String SAX_RUNTIME_PLATFORM_CLASS_NAME = "oracle.toplink.ox.platform.SAXPlatform";
    public static final String DOM_RUNTIME_PLATFORM_CLASS_NAME = "oracle.toplink.ox.platform.DOMPlatform";
    public static final String DEFAULT_PLATFORM_CLASS_NAME = "oracle.toplink.ox.platform.SAXPlatform";

    XMLLoginAdapter(SCAdapter parent, XMLLoginConfig scConfig) {
        super(parent, (LoginConfig)scConfig);
    }

    protected XMLLoginAdapter(SCAdapter parent) {
        super(parent);
    }

    @Override
    protected void initializeDefaults() {
        super.initializeDefaults();
        this.setPlatformClass(this.getDefaultPlatformClassName());
        this.setDocumentPreservationPolicy(NO_DOCUMENT_PRESERVATION_POLICY);
        this.setNodeOrderingPolicy(APPEND_NEW_ELEMENTS);
    }

    @Override
    protected void initializeFromModel(Object scConfig) {
        super.initializeFromModel(scConfig);
        if (this.getDocumentPreservationPolicyConfig() == null) {
            this.setDocumentPreservationPolicy(NO_DOCUMENT_PRESERVATION_POLICY);
        }
        if (this.getNodeOrderingPolicyConfig() == null) {
            this.setNodeOrderingPolicy(APPEND_NEW_ELEMENTS);
        }
    }

    @Override
    protected Object buildModel() {
        return new XMLLoginConfig();
    }

    private DocumentPreservationPolicyConfig getDocumentPreservationPolicyConfig() {
        return this.login().getDocumentPreservationPolicy();
    }

    private NodeOrderingPolicyConfig getNodeOrderingPolicyConfig() {
        return this.getDocumentPreservationPolicyConfig().getNodeOrderingPolicy();
    }

    @Override
    protected String getDefaultPlatformClassName() {
        return "oracle.toplink.ox.platform.SAXPlatform";
    }

    public Collection<String> getPlatformClassOptions() {
        ArrayList<String> values = new ArrayList<String>(2);
        values.add("oracle.toplink.ox.platform.SAXPlatform");
        values.add(DOM_RUNTIME_PLATFORM_CLASS_NAME);
        return values;
    }

    public Collection<String> getDocumentPreservationPolicyOptions() {
        ArrayList<String> values = new ArrayList<String>(3);
        values.add(NO_DOCUMENT_PRESERVATION_POLICY);
        values.add(DESCRIPTOR_LEVEL_DOCUMENT_PRESERVATION_POLICY);
        values.add(XML_BINDER_PRESERVATION_POLICY);
        return values;
    }

    public Collection<String> getNodeOrderingPolicyOptions() {
        ArrayList<String> values = new ArrayList<String>(3);
        values.add(APPEND_NEW_ELEMENTS);
        values.add(IGNORE_NEW_ELEMENTS);
        values.add(RELATIVE_POSITION);
        return values;
    }

    @Override
    boolean platformIsXml() {
        return true;
    }

    private final XMLLoginConfig login() {
        return (XMLLoginConfig)this.getModel();
    }

    public boolean isEqualNamespaceResolvers() {
        return this.login().getEqualNamespaceResolvers();
    }

    public void setEqualNamespaceResolvers(boolean value) {
        boolean old = this.login().getEqualNamespaceResolvers();
        this.login().setEqualNamespaceResolvers(value);
        this.firePropertyChanged(EQUAL_NAMESPACE_RESOLVERS_PROPERTY, old, value);
    }

    public String getDocumentPreservationPolicyType() {
        if (this.getDocumentPreservationPolicyConfig() instanceof DescriptorLevelDocumentPreservationPolicyConfig) {
            return DESCRIPTOR_LEVEL_DOCUMENT_PRESERVATION_POLICY;
        }
        if (this.getDocumentPreservationPolicyConfig() instanceof NoDocumentPreservationPolicyConfig) {
            return NO_DOCUMENT_PRESERVATION_POLICY;
        }
        if (this.getDocumentPreservationPolicyConfig() instanceof XMLBinderPolicyConfig) {
            return XML_BINDER_PRESERVATION_POLICY;
        }
        throw new IllegalStateException("Invalid document preservation policy type.");
    }

    public void setDocumentPreservationPolicy(String policyType) {
        DocumentPreservationPolicyConfig old = this.login().getDocumentPreservationPolicy();
        DocumentPreservationPolicyConfig config = this.setConfigDocumentPreservationPolicy(policyType);
        this.setNodeOrderingPolicy(APPEND_NEW_ELEMENTS);
        this.firePropertyChanged(DOCUMENT_PRESERVATION_POLICY_PROPERTY, old, config);
    }

    private DocumentPreservationPolicyConfig setConfigDocumentPreservationPolicy(String policyType) {
        NoDocumentPreservationPolicyConfig config = null;
        if (NO_DOCUMENT_PRESERVATION_POLICY.equals(policyType)) {
            config = new NoDocumentPreservationPolicyConfig();
            this.login().setDocumentPreservationPolicy((DocumentPreservationPolicyConfig)config);
        } else if (DESCRIPTOR_LEVEL_DOCUMENT_PRESERVATION_POLICY.equals(policyType)) {
            config = new DescriptorLevelDocumentPreservationPolicyConfig();
            this.login().setDocumentPreservationPolicy((DocumentPreservationPolicyConfig)config);
        } else if (XML_BINDER_PRESERVATION_POLICY.equals(policyType)) {
            config = new XMLBinderPolicyConfig();
            this.login().setDocumentPreservationPolicy((DocumentPreservationPolicyConfig)config);
        }
        return config;
    }

    public String getNodeOrderingPolicyType() {
        if (this.getNodeOrderingPolicyConfig() instanceof AppendNewElementsOrderingPolicyConfig) {
            return APPEND_NEW_ELEMENTS;
        }
        if (this.getNodeOrderingPolicyConfig() instanceof IgnoreNewElementsOrderingPolicyConfig) {
            return IGNORE_NEW_ELEMENTS;
        }
        if (this.getNodeOrderingPolicyConfig() instanceof RelativePositionOrderingPolicyConfig) {
            return RELATIVE_POSITION;
        }
        throw new IllegalStateException("Invalid node ordering policy type.");
    }

    public void setNodeOrderingPolicy(String policyType) {
        NodeOrderingPolicyConfig old = this.getNodeOrderingPolicyConfig();
        NodeOrderingPolicyConfig config = this.setConfigNodeOrderingPolicy(policyType);
        this.firePropertyChanged(NODE_ORDERING_POLICY_PROPERTY, old, config);
    }

    private NodeOrderingPolicyConfig setConfigNodeOrderingPolicy(String policyType) {
        AppendNewElementsOrderingPolicyConfig config = null;
        if (APPEND_NEW_ELEMENTS.equals(policyType)) {
            config = new AppendNewElementsOrderingPolicyConfig();
            this.getDocumentPreservationPolicyConfig().setNodeOrderingPolicy((NodeOrderingPolicyConfig)config);
        } else if (IGNORE_NEW_ELEMENTS.equals(policyType)) {
            config = new IgnoreNewElementsOrderingPolicyConfig();
            this.getDocumentPreservationPolicyConfig().setNodeOrderingPolicy((NodeOrderingPolicyConfig)config);
        } else if (RELATIVE_POSITION.equals(policyType)) {
            config = new RelativePositionOrderingPolicyConfig();
            this.getDocumentPreservationPolicyConfig().setNodeOrderingPolicy((NodeOrderingPolicyConfig)config);
        }
        return config;
    }
}

