/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.xml;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractReadQuery;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QueryComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.xml.EisQueryAdvancedOptionsDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;

final class EisQueryOptionsPanel
extends AbstractPanel {
    private PropertyValueModel queryHolder;

    EisQueryOptionsPanel(PropertyValueModel queryHolder, WorkbenchContextHolder contextHolder) {
        super(contextHolder);
        this.queryHolder = queryHolder;
        this.initializeLayout();
    }

    protected String helpTopicId() {
        return "descriptor.queries.options";
    }

    protected void initializeLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JPanel checkBoxPanel = new JPanel(new GridBagLayout());
        JCheckBox refreshIdentityMapCheckBox = this.buildRefreshIdentityMapCheckBox();
        this.addHelpTopicId(refreshIdentityMapCheckBox, this.helpTopicId() + ".refresh");
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.anchor = 17;
        checkBoxPanel.add((Component)refreshIdentityMapCheckBox, constraints);
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 2;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.anchor = 18;
        constraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)checkBoxPanel, constraints);
        this.addHelpTopicId(checkBoxPanel, this.helpTopicId() + ".refresh");
        JButton advancedOptionsButton = this.buildAdvancedOptionsButton();
        constraints.gridx = 1;
        constraints.gridy = 5;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 0;
        constraints.anchor = 23;
        constraints.insets = new Insets(10, 5, 5, 5);
        this.add((Component)advancedOptionsButton, constraints);
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private JCheckBox buildRefreshIdentityMapCheckBox() {
        return QueryComponentFactory.buildRefreshIdentityMapCheckBox(this.queryHolder, this.resourceRepository());
    }

    private JButton buildAdvancedOptionsButton() {
        JButton button = new JButton(this.resourceRepository().getString("ADVANCED_BUTTON_TEXT"));
        button.setEnabled(false);
        button.setMnemonic(this.resourceRepository().getMnemonic("ADVANCED_BUTTON_TEXT"));
        button.addActionListener(this.buildAdvancedOptionsAction());
        this.queryHolder.addPropertyChangeListener("value", this.buildQueryListener(button));
        return button;
    }

    private ActionListener buildAdvancedOptionsAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                EisQueryOptionsPanel.this.showAdvancedOptionsDialog();
            }
        };
    }

    private void showAdvancedOptionsDialog() {
        EisQueryAdvancedOptionsDialog dialog = new EisQueryAdvancedOptionsDialog(this.getQuery(), this.getWorkbenchContext());
        dialog.show();
        if (dialog.wasConfirmed()) {
            MWAbstractReadQuery query = this.getQuery();
            query.setMaintainCache(dialog.getMaintainCache());
            query.setLocking(dialog.getLocking());
            query.setUseWrapperPolicy(dialog.getUseWrapperPolicy());
            query.setCacheQueryResults(dialog.getCacheQueryResults());
            query.setRefreshIdentityMapResult(dialog.getRefreshIdentityMapResult());
            query.setRefreshRemoteIdentityMapResult(dialog.getRefreshRemoteIdentityMapResult());
            query.setDistinctState(dialog.getDistinctState());
            query.setQueryTimeout(dialog.getQueryTimeout());
            query.setMaximumRows(dialog.getMaximumRows());
            query.setFirstResult(dialog.getFirstResult());
            query.setExclusiveConnection(dialog.getExclusiveConnection());
        }
    }

    private MWAbstractReadQuery getQuery() {
        return (MWAbstractReadQuery)this.queryHolder.getValue();
    }

    private PropertyChangeListener buildQueryListener(final Component component) {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                component.setEnabled(EisQueryOptionsPanel.this.getQuery() != null);
            }
        };
    }
}

