/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.datashare;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.datashare.IChannel;
import org.eclipse.ecf.datashare.IChannelContainerAdapter;
import org.eclipse.ecf.datashare.IChannelListener;
import org.eclipse.ecf.datashare.events.IChannelConnectEvent;
import org.eclipse.ecf.datashare.events.IChannelDisconnectEvent;
import org.eclipse.ecf.datashare.events.IChannelEvent;
import org.eclipse.ecf.datashare.events.IChannelMessageEvent;

public abstract class AbstractShare {
    protected IChannel channel = null;
    protected IChannelContainerAdapter adapter = null;
    private final IChannelListener listener = new IChannelListener(){

        @Override
        public void handleChannelEvent(IChannelEvent event) {
            AbstractShare.this.handleChannelEvent(event);
        }
    };

    private void getOrCreateChannel(IChannelContainerAdapter containerAdapter, ID channelID, Map options) throws ECFException {
        if (channelID == null) {
            channelID = IDFactory.getDefault().createStringID(this.getClass().getName());
        }
        this.channel = containerAdapter.getChannel(channelID);
        if (this.channel == null) {
            this.channel = containerAdapter.createChannel(channelID, this.listener, options);
        }
        this.adapter = containerAdapter;
    }

    public AbstractShare(IChannelContainerAdapter adapter) throws ECFException {
        Assert.isNotNull((Object)adapter);
        this.getOrCreateChannel(adapter, null, null);
    }

    public AbstractShare(IChannelContainerAdapter adapter, ID channelID) throws ECFException {
        this(adapter, channelID, null);
    }

    public AbstractShare(IChannelContainerAdapter adapter, ID channelID, Map options) throws ECFException {
        Assert.isNotNull((Object)adapter);
        Assert.isNotNull((Object)channelID);
        this.getOrCreateChannel(adapter, channelID, options);
    }

    protected void handleChannelEvent(IChannelEvent event) {
        if (event instanceof IChannelMessageEvent) {
            IChannelMessageEvent cme = (IChannelMessageEvent)event;
            this.handleMessage(cme.getFromContainerID(), cme.getData());
        } else if (event instanceof IChannelConnectEvent) {
            IChannelConnectEvent cce = (IChannelConnectEvent)event;
            this.handleConnectEvent(cce);
        } else if (event instanceof IChannelDisconnectEvent) {
            IChannelDisconnectEvent cde = (IChannelDisconnectEvent)event;
            this.handleDisconnectEvent(cde);
        }
    }

    protected void handleDisconnectEvent(IChannelDisconnectEvent cde) {
    }

    protected void handleConnectEvent(IChannelConnectEvent cce) {
    }

    protected abstract void handleMessage(ID var1, byte[] var2);

    public synchronized void sendMessage(ID toID, byte[] data) throws ECFException {
        if (this.channel != null) {
            this.channel.sendMessage(toID, data);
        }
    }

    public IChannel getChannel() {
        return this.channel;
    }

    public boolean isDisposed() {
        return this.getChannel() == null;
    }

    public synchronized void dispose() {
        if (this.channel != null) {
            this.adapter.removeChannel(this.channel.getID());
            this.channel = null;
            this.adapter = null;
        }
    }
}

