/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.client;

import java.lang.reflect.Method;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.RemoteCall;
import org.eclipse.ecf.remoteservice.client.AbstractClientContainer;
import org.eclipse.ecf.remoteservice.client.AbstractClientService;
import org.eclipse.ecf.remoteservice.client.IRemoteCallable;
import org.eclipse.ecf.remoteservice.client.RemoteServiceClientRegistration;
import org.osgi.framework.ServiceException;

public abstract class AbstractRSAClientService
extends AbstractClientService {
    protected Object invokeRemoteCall(IRemoteCall call, IRemoteCallable callable) throws ECFException {
        return null;
    }

    public AbstractRSAClientService(AbstractClientContainer container, RemoteServiceClientRegistration registration) {
        super(container, registration);
    }

    protected abstract Object invokeAsync(RSARemoteCall var1) throws ECFException;

    protected abstract Object invokeSync(RSARemoteCall var1) throws ECFException;

    protected RSARemoteCall createRemoteCall(Object proxy, Method method, String methodName, Object[] parameters, long timeout) {
        return new RSARemoteCall(proxy, method, methodName, parameters, timeout);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Object resultObject = this.invokeObject(proxy, method, args);
            if (resultObject != null) {
                return resultObject;
            }
            if (this.isAsync(proxy, method, args)) {
                return this.invokeAsync(this.createRemoteCall(proxy, method, this.getAsyncInvokeMethodName(method), args, IRemoteCall.DEFAULT_TIMEOUT));
            }
            String callMethod = this.getCallMethodNameForProxyInvoke(method, args);
            Object[] callParameters = this.getCallParametersForProxyInvoke(callMethod, method, args);
            long callTimeout = this.getCallTimeoutForProxyInvoke(callMethod, method, args);
            return this.invokeSync(this.createRemoteCall(proxy, method, callMethod, callParameters, callTimeout));
        }
        catch (Throwable t) {
            if (t instanceof ServiceException) {
                throw t;
            }
            throw new ServiceException("Service exception on remote service proxy rsid=" + this.getRemoteServiceID(), 5, t);
        }
    }

    public static class RSARemoteCall
    extends RemoteCall {
        private final Object proxy;
        private final Method reflectMethod;

        public RSARemoteCall(Object proxy, Method method, String methodName, Object[] parameters, long timeout) {
            super(methodName, parameters, timeout);
            this.reflectMethod = method;
            this.proxy = proxy;
        }

        public Method getReflectMethod() {
            return this.reflectMethod;
        }

        public Object getProxy() {
            return this.proxy;
        }
    }
}

