/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.jms;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.util.LogHelper;
import org.eclipse.ecf.provider.jms.identity.JMSNamespace;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf.provider.jms";
    private static Activator plugin;
    private BundleContext context = null;
    private ServiceTracker<LogService, LogService> logServiceTracker = null;

    public Activator() {
        plugin = this;
    }

    protected LogService getLogService() {
        if (this.logServiceTracker == null) {
            this.logServiceTracker = new ServiceTracker(this.context, LogService.class.getName(), null);
            this.logServiceTracker.open();
        }
        return (LogService)this.logServiceTracker.getService();
    }

    public void log(IStatus status) {
        LogService logService = this.getLogService();
        if (logService != null) {
            logService.log(LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
        }
    }

    public void start(BundleContext ctxt) throws Exception {
        this.context = ctxt;
        ctxt.registerService(Namespace.class, (Object)new JMSNamespace(), null);
    }

    public void stop(BundleContext ctxt) throws Exception {
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
            this.logServiceTracker = null;
        }
        this.context = null;
        plugin = null;
    }

    public static synchronized Activator getDefault() {
        if (plugin == null) {
            plugin = new Activator();
        }
        return plugin;
    }
}

