/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.osgi.services.remoteserviceadmin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.internal.osgi.services.remoteserviceadmin.IDUtil;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.AbstractContainerSelector;
import org.eclipse.ecf.osgi.services.remoteserviceadmin.SelectContainerException;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainer;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.RemoteServiceContainer;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHostContainerSelector
extends AbstractContainerSelector {
    protected String[] defaultConfigTypes;

    public AbstractHostContainerSelector(String[] defaultConfigTypes) {
        this.defaultConfigTypes = defaultConfigTypes;
    }

    protected Collection selectExistingHostContainers(ServiceReference serviceReference, Map<String, Object> overridingProperties, String[] serviceExportedInterfaces, String[] serviceExportedConfigs, String[] serviceIntents) {
        ArrayList<RemoteServiceContainer> results = new ArrayList<RemoteServiceContainer>();
        IContainer[] containers = this.getContainers();
        if (containers == null || containers.length == 0) {
            return results;
        }
        int i = 0;
        while (i < containers.length) {
            ContainerTypeDescription description;
            IRemoteServiceContainerAdapter adapter = this.hasRemoteServiceContainerAdapter(containers[i]);
            if (adapter != null && (description = this.getContainerTypeDescription(containers[i])) != null && description.isServer()) {
                if (this.matchExistingHostContainer(serviceReference, overridingProperties, containers[i], adapter, description, serviceExportedConfigs, serviceIntents)) {
                    this.trace("selectExistingHostContainers", "INCLUDING containerID=" + containers[i].getID() + " configs=" + (serviceExportedConfigs == null ? "null" : Arrays.asList(serviceExportedConfigs).toString()) + " intents=" + (serviceIntents == null ? "null" : Arrays.asList(serviceIntents).toString()));
                    results.add(new RemoteServiceContainer(containers[i], adapter));
                } else {
                    this.trace("selectExistingHostContainers", "EXCLUDING containerID=" + containers[i].getID() + " configs=" + (serviceExportedConfigs == null ? "null" : Arrays.asList(serviceExportedConfigs).toString()) + " intents=" + (serviceIntents == null ? "null" : Arrays.asList(serviceIntents).toString()));
                }
            }
            ++i;
        }
        return results;
    }

    protected boolean matchHostContainerToConnectTarget(ServiceReference serviceReference, Map<String, Object> properties, IContainer container) {
        String target = (String)properties.get("ecf.endpoint.connecttarget.id");
        if (target == null) {
            return true;
        }
        ID connectedID = container.getConnectedID();
        if (connectedID == null) {
            try {
                this.connectHostContainer(serviceReference, properties, container, target);
            }
            catch (Exception e) {
                this.logException("doConnectContainer containerID=" + container.getID() + " target=" + target, e);
                return false;
            }
            return true;
        }
        ID targetID = this.createTargetID(container, target);
        return connectedID.equals((Object)targetID);
    }

    protected boolean matchExistingHostContainer(ServiceReference serviceReference, Map<String, Object> properties, IContainer container, IRemoteServiceContainerAdapter adapter, ContainerTypeDescription description, String[] requiredConfigTypes, String[] requiredServiceIntents) {
        return this.matchHostSupportedConfigTypes(requiredConfigTypes, description) && this.matchHostSupportedIntents(requiredServiceIntents, description) && this.matchHostContainerID(serviceReference, properties, container) && this.matchHostContainerToConnectTarget(serviceReference, properties, container);
    }

    protected boolean matchHostContainerID(ServiceReference serviceReference, Map<String, Object> properties, IContainer container) {
        ID containerID = container.getID();
        if (containerID == null) {
            return false;
        }
        ID requiredContainerID = (ID)properties.get("ecf.exported.containerid");
        if (requiredContainerID != null) {
            return requiredContainerID.equals((Object)containerID);
        }
        Namespace ns = containerID.getNamespace();
        Object cid = properties.get("ecf.exported.containerfactoryargs");
        if (cid == null) {
            return true;
        }
        ID cID = null;
        if (cid instanceof ID) {
            cID = (ID)cid;
        } else if (cid instanceof String) {
            cID = IDUtil.createID(ns, (String)cid);
        } else if (cid instanceof Object[]) {
            Object cido = ((Object[])cid)[0];
            cID = IDUtil.createID(ns, new Object[]{cido});
        }
        if (cID == null) {
            return true;
        }
        return containerID.equals((Object)cID);
    }

    protected boolean matchHostSupportedConfigTypes(String[] requiredConfigTypes, ContainerTypeDescription containerTypeDescription) {
        if (requiredConfigTypes == null) {
            return true;
        }
        String[] supportedConfigTypes = this.getSupportedConfigTypes(containerTypeDescription);
        if (supportedConfigTypes == null || supportedConfigTypes.length == 0) {
            return false;
        }
        List<String> supportedConfigTypesList = Arrays.asList(supportedConfigTypes);
        List<String> requiredConfigTypesList = Arrays.asList(requiredConfigTypes);
        boolean result = true;
        Iterator<String> i = requiredConfigTypesList.iterator();
        while (i.hasNext()) {
            result &= supportedConfigTypesList.contains(i.next());
        }
        return result;
    }

    protected Collection createAndConfigureHostContainers(ServiceReference serviceReference, Map<String, Object> properties, String[] serviceExportedInterfaces, String[] requiredConfigs, String[] requiredIntents) throws SelectContainerException {
        ArrayList<IRemoteServiceContainer> results = new ArrayList<IRemoteServiceContainer>();
        ContainerTypeDescription[] descriptions = this.getContainerTypeDescriptions();
        if (descriptions == null) {
            return Collections.EMPTY_LIST;
        }
        if (requiredConfigs == null || requiredConfigs.length == 0) {
            this.createAndAddDefaultContainers(serviceReference, properties, serviceExportedInterfaces, requiredIntents, descriptions, results);
        } else {
            int i = 0;
            while (i < descriptions.length) {
                IRemoteServiceContainer matchingContainer = this.createMatchingContainer(descriptions[i], serviceReference, properties, serviceExportedInterfaces, requiredConfigs, requiredIntents);
                if (matchingContainer != null) {
                    results.add(matchingContainer);
                }
                ++i;
            }
        }
        return results;
    }

    private void createAndAddDefaultContainers(ServiceReference serviceReference, Map<String, Object> properties, String[] serviceExportedInterfaces, String[] requiredIntents, ContainerTypeDescription[] descriptions, Collection results) throws SelectContainerException {
        ContainerTypeDescription[] ctds = this.getContainerTypeDescriptionsForDefaultConfigTypes(descriptions);
        if (ctds != null) {
            int i = 0;
            while (i < ctds.length) {
                IRemoteServiceContainer matchingContainer = this.createMatchingContainer(ctds[i], serviceReference, properties, serviceExportedInterfaces, null, requiredIntents);
                if (matchingContainer != null) {
                    results.add(matchingContainer);
                }
                ++i;
            }
        }
    }

    protected ContainerTypeDescription[] getContainerTypeDescriptionsForDefaultConfigTypes(ContainerTypeDescription[] descriptions) {
        String[] defaultConfigTypes = this.getDefaultConfigTypes();
        if (defaultConfigTypes == null || defaultConfigTypes.length == 0) {
            return null;
        }
        ArrayList<ContainerTypeDescription> results = new ArrayList<ContainerTypeDescription>();
        int i = 0;
        while (i < descriptions.length) {
            String[] supportedConfigTypes = descriptions[i].getSupportedConfigs();
            if (supportedConfigTypes != null && this.matchDefaultConfigTypes(defaultConfigTypes, supportedConfigTypes)) {
                results.add(descriptions[i]);
            }
            ++i;
        }
        return results.toArray(new ContainerTypeDescription[0]);
    }

    protected boolean matchDefaultConfigTypes(String[] defaultConfigTypes, String[] supportedConfigTypes) {
        List<String> supportedConfigTypesList = Arrays.asList(supportedConfigTypes);
        int i = 0;
        while (i < defaultConfigTypes.length) {
            if (supportedConfigTypesList.contains(defaultConfigTypes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected String[] getDefaultConfigTypes() {
        return this.defaultConfigTypes;
    }

    protected IRemoteServiceContainer createMatchingContainer(ContainerTypeDescription containerTypeDescription, ServiceReference serviceReference, Map<String, Object> properties, String[] serviceExportedInterfaces, String[] requiredConfigs, String[] requiredIntents) throws SelectContainerException {
        if (this.matchHostSupportedConfigTypes(requiredConfigs, containerTypeDescription) && this.matchHostSupportedIntents(requiredIntents, containerTypeDescription)) {
            return this.createRSContainer(serviceReference, properties, containerTypeDescription);
        }
        return null;
    }

    protected IRemoteServiceContainer createRSContainer(ServiceReference serviceReference, Map<String, Object> properties, ContainerTypeDescription containerTypeDescription) throws SelectContainerException {
        IContainer container = this.createContainer(serviceReference, properties, containerTypeDescription);
        IRemoteServiceContainerAdapter adapter = (IRemoteServiceContainerAdapter)container.getAdapter(IRemoteServiceContainerAdapter.class);
        if (adapter == null) {
            throw new SelectContainerException("Container does not implement IRemoteServiceContainerAdapter", null, containerTypeDescription);
        }
        return new RemoteServiceContainer(container, adapter);
    }

    protected void connectHostContainer(ServiceReference serviceReference, Map<String, Object> properties, IContainer container, Object target) throws ContainerConnectException, IDCreateException {
        ID targetID = target instanceof String ? IDUtil.createID(container.getConnectNamespace(), (String)target) : IDUtil.createID(container.getConnectNamespace(), new Object[]{target});
        Object context = properties.get("ecf.exported.containerconnectcontext");
        IConnectContext connectContext = null;
        if (context != null) {
            connectContext = this.createConnectContext(serviceReference, properties, container, context);
        }
        container.connect(targetID, connectContext);
    }

    protected boolean matchHostSupportedIntents(String[] serviceRequiredIntents, ContainerTypeDescription containerTypeDescription) {
        if (serviceRequiredIntents == null) {
            return true;
        }
        String[] supportedIntents = this.getSupportedIntents(containerTypeDescription);
        if (supportedIntents == null) {
            return false;
        }
        List<String> supportedIntentsList = Arrays.asList(supportedIntents);
        boolean result = true;
        int i = 0;
        while (i < serviceRequiredIntents.length) {
            result = result && supportedIntentsList.contains(serviceRequiredIntents[i]);
            ++i;
        }
        return result;
    }
}

