/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.remoteservice.generic;

import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.provider.remoteservice.generic.RegistrySharedObject;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteServiceRegistrationImpl;
import org.eclipse.ecf.remoteservice.AbstractRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteCall;
import org.eclipse.ecf.remoteservice.IRemoteCallListener;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;

public class RemoteServiceImpl
extends AbstractRemoteService {
    protected static final long DEFAULT_TIMEOUT = new Long(System.getProperty("ecf.remotecall.timeout", "30000"));
    protected RemoteServiceRegistrationImpl registration = null;
    protected RegistrySharedObject sharedObject = null;

    public RemoteServiceImpl(RegistrySharedObject sharedObject, RemoteServiceRegistrationImpl registration) {
        this.sharedObject = sharedObject;
        this.registration = registration;
    }

    protected IRemoteServiceID getRemoteServiceID() {
        return this.registration.getID();
    }

    protected IRemoteServiceReference getRemoteServiceReference() {
        return this.registration.getReference();
    }

    protected String[] getInterfaceClassNames() {
        return this.registration.getClasses();
    }

    protected long getDefaultTimeout() {
        return DEFAULT_TIMEOUT;
    }

    public void callAsync(IRemoteCall call, IRemoteCallListener listener) {
        this.sharedObject.sendCallRequestWithListener(this.registration, call, listener);
    }

    public Object callSync(IRemoteCall call) throws ECFException {
        return this.sharedObject.callSynch(this.registration, call);
    }

    public void fireAsync(IRemoteCall call) throws ECFException {
        this.sharedObject.sendFireRequest(this.registration, call);
    }
}

