/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.filetransfer.scp;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.security.Callback;
import org.eclipse.ecf.core.security.CallbackHandler;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.security.NameCallback;
import org.eclipse.ecf.core.security.PassphraseCallback;
import org.eclipse.ecf.core.security.PasswordCallback;
import org.eclipse.ecf.core.security.UnsupportedCallbackException;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.internal.provider.filetransfer.scp.Activator;
import org.eclipse.ecf.internal.provider.filetransfer.scp.IScpFileTransfer;
import org.eclipse.ecf.internal.provider.filetransfer.scp.Messages;
import org.eclipse.osgi.util.NLS;

public class ScpUtil
implements UserInfo,
UIKeyboardInteractive {
    public static final String SCP_SSHHOMEDIRECTORY = System.getProperty("org.eclipse.ecf.filetransfer.scp.util.sshHomeDirectory", "sshHomeDirectory");
    public static final String SCP_PUBLICKEYFILE = System.getProperty("org.eclipse.ecf.filetransfer.scp.util.keyFile", "keyFile");
    public static final String SCP_KNOWNHOSTSFILE = System.getProperty("org.eclipse.ecf.filetransfer.scp.util.knownHostsFile", "knownHostsFile");
    public static final int DEFAULT_SCP_PORT = Integer.parseInt(System.getProperty("org.eclipse.ecf.filetransfer.scp.util.scpPort", "22"));
    private IScpFileTransfer handler;
    private String password;
    private String passphrase;
    private Session session;
    private String sshHome = null;
    private String keyFile = null;
    private String knownHostsFile = null;

    public ScpUtil(IScpFileTransfer handler) throws JSchException, IOException, UnsupportedCallbackException {
        this.handler = handler;
        JSch jsch = new JSch();
        URL url = handler.getTargetURL();
        int port = url.getPort();
        if (port == -1) {
            port = DEFAULT_SCP_PORT;
        }
        this.setupOptions(jsch);
        this.promptUsername();
        String username = handler.getUsername();
        if (username == null) {
            throw new IOException(Messages.ScpUtil_EXCEPTION_USERNAME_NOT_NULL);
        }
        this.session = jsch.getSession(handler.getUsername(), url.getHost(), port);
        this.setupProxy();
        this.session.setUserInfo((UserInfo)this);
    }

    Session getSession() {
        return this.session;
    }

    void promptUsername() throws IOException, UnsupportedCallbackException {
        IConnectContext connectContext = this.handler.getConnectContext();
        if (connectContext != null) {
            CallbackHandler callbackHandler = connectContext.getCallbackHandler();
            if (this.handler != null) {
                Callback[] callbacks = new Callback[2];
                NameCallback nc = new NameCallback(Messages.ScpOutgoingFileTransfer_USERNAME_PROMPT);
                String user = this.handler.getUsername();
                if (user != null) {
                    nc.setName(user);
                }
                callbacks[0] = nc;
                callbacks[1] = new PasswordCallback(Messages.ScpOutgoingFileTransfer_PASSWORD_PROMPT);
                callbackHandler.handle(callbacks);
                this.handler.setUsername(nc.getName());
            }
        }
    }

    String promptCredentials(boolean usePassphrase) {
        try {
            IConnectContext connectContext = this.handler.getConnectContext();
            if (connectContext != null) {
                CallbackHandler callbackHandler = connectContext.getCallbackHandler();
                if (this.handler != null) {
                    Callback[] callbacks = new Callback[2];
                    NameCallback nc = new NameCallback(Messages.ScpOutgoingFileTransfer_USERNAME_PROMPT);
                    String user = this.handler.getUsername();
                    if (user != null) {
                        nc.setName(user);
                    }
                    callbacks[0] = nc;
                    callbacks[1] = usePassphrase ? new PassphraseCallback(Messages.ScpOutgoingFileTransfer_PASSPHRASE_PROMPT) : new PasswordCallback(Messages.ScpOutgoingFileTransfer_PASSWORD_PROMPT);
                    callbackHandler.handle(callbacks);
                    this.handler.setUsername(nc.getName());
                    if (usePassphrase) {
                        this.passphrase = ((PassphraseCallback)callbacks[1]).getPassphrase();
                    } else {
                        this.password = ((PasswordCallback)callbacks[1]).getPassword();
                    }
                }
            }
            return usePassphrase ? this.passphrase : this.password;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getPassphrase() {
        return this.promptCredentials(true);
    }

    public String getPassword() {
        return this.promptCredentials(false);
    }

    public boolean promptPassphrase(String message) {
        return this.keyFile != null;
    }

    public boolean promptPassword(String message) {
        return true;
    }

    public boolean promptYesNo(String message) {
        return true;
    }

    public void showMessage(String message) {
    }

    public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
        this.promptCredentials(false);
        return new String[]{this.password};
    }

    void setupProxy() {
        ProxyHTTP jProxy = null;
        org.eclipse.ecf.core.util.Proxy proxy = this.handler.getProxy();
        if (proxy != null) {
            String hostname = proxy.getAddress().getHostName();
            int port = proxy.getAddress().getPort();
            if (proxy.getType().equals(Proxy.Type.HTTP)) {
                jProxy = port == -1 ? new ProxyHTTP(hostname) : new ProxyHTTP(hostname, port);
            } else if (proxy.getType().equals(Proxy.Type.SOCKS)) {
                jProxy = port == -1 ? new ProxySOCKS5(hostname) : new ProxySOCKS5(hostname, port);
            }
            if (jProxy != null) {
                this.session.setProxy((Proxy)jProxy);
            }
        }
    }

    private void setupOptions(JSch jsch) {
        File file;
        String userHome;
        this.sshHome = this.getProperty(SCP_SSHHOMEDIRECTORY, this.sshHome);
        if (this.sshHome == null && (userHome = System.getProperty("user.home")) != null) {
            File dir = new File(String.valueOf(userHome) + File.separator + ".ssh");
            if (dir.exists()) {
                this.sshHome = dir.getAbsolutePath();
            } else {
                dir = new File(String.valueOf(userHome) + File.separator + "ssh");
            }
            if (dir.exists()) {
                this.sshHome = dir.getAbsolutePath();
            }
        }
        this.keyFile = this.getProperty(SCP_PUBLICKEYFILE);
        if (this.keyFile != null) {
            if (!new File(this.keyFile).exists()) {
                this.keyFile = null;
            }
        } else {
            file = new File(String.valueOf(this.sshHome) + File.separator + "id_dsa");
            if (file.exists()) {
                this.keyFile = file.getAbsolutePath();
            } else {
                file = new File(String.valueOf(this.sshHome) + File.separator + "id_rsa");
                if (file.exists()) {
                    this.keyFile = file.getAbsolutePath();
                }
            }
        }
        if (this.keyFile != null) {
            try {
                jsch.addIdentity(this.keyFile);
            }
            catch (JSchException e) {
                Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider.scp", 4, Messages.ScpOutgoingFileTransfer_EXCEPTION_SETTING_SSH_IDENTITY, (Throwable)e));
            }
        }
        this.knownHostsFile = this.getProperty(SCP_KNOWNHOSTSFILE);
        if (this.knownHostsFile != null) {
            if (!new File(this.knownHostsFile).exists()) {
                this.knownHostsFile = null;
            }
        } else {
            file = new File(String.valueOf(this.sshHome) + File.separator + "known_hosts");
            this.knownHostsFile = !file.exists() ? null : file.getAbsolutePath();
        }
        if (this.knownHostsFile != null) {
            try {
                jsch.setKnownHosts(this.knownHostsFile);
            }
            catch (JSchException e) {
                Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider.scp", 4, Messages.ScpOutgoingFileTransfer_EXCEPTION_SETTING_KNOWN_HOSTS, (Throwable)e));
            }
        }
    }

    private String getProperty(String key, String def) {
        Map options = this.handler.getOptions();
        if (options == null) {
            return def;
        }
        String result = (String)options.get(key);
        if (result == null) {
            return def;
        }
        return result;
    }

    private String getProperty(String key) {
        return this.getProperty(key, null);
    }

    String trimTargetFile(String string) {
        return string;
    }

    void checkAck(InputStream ins) throws IOException {
        this.checkAck(ins.read(), ins);
    }

    void checkAck(int b, InputStream ins) throws IOException {
        if (b == 0) {
            return;
        }
        if (b == -1) {
            throw new IOException(Messages.ScpUtil_EXCEPTION_UNKNOWN_SCP_ERROR);
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = ins.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1) {
                throw new IOException(NLS.bind((String)Messages.ScpUtil_SCP_ERROR, (Object)sb.toString()));
            }
            if (b == 2) {
                throw new IOException(NLS.bind((String)Messages.ScpUtil_SCP_ERROR, (Object)sb.toString()));
            }
        }
    }

    void sendZeroToStream(OutputStream outs) throws IOException {
        byte[] buf = new byte[]{0};
        outs.write(buf, 0, 1);
        outs.flush();
    }

    void dispose() {
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
        }
        this.handler = null;
        this.password = null;
        this.passphrase = null;
        this.sshHome = null;
        this.keyFile = null;
        this.knownHostsFile = null;
    }
}

