/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.discovery;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.events.ContainerConnectedEvent;
import org.eclipse.ecf.core.events.ContainerConnectingEvent;
import org.eclipse.ecf.core.events.ContainerDisconnectedEvent;
import org.eclipse.ecf.core.events.ContainerDisconnectingEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.IIDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.util.ECFRuntimeException;
import org.eclipse.ecf.core.util.Trace;
import org.eclipse.ecf.discovery.AbstractDiscoveryContainerAdapter;
import org.eclipse.ecf.discovery.DiscoveryContainerConfig;
import org.eclipse.ecf.discovery.IDiscoveryAdvertiser;
import org.eclipse.ecf.discovery.IDiscoveryLocator;
import org.eclipse.ecf.discovery.IServiceEvent;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceListener;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.eclipse.ecf.discovery.IServiceTypeEvent;
import org.eclipse.ecf.discovery.IServiceTypeListener;
import org.eclipse.ecf.discovery.ServiceInfo;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.discovery.identity.ServiceIDFactory;
import org.eclipse.ecf.discovery.service.IDiscoveryService;
import org.eclipse.ecf.provider.discovery.CompositeServiceContainerEvent;
import org.eclipse.ecf.provider.discovery.CompositeServiceTypeContainerEvent;

public class CompositeDiscoveryContainer
extends AbstractDiscoveryContainerAdapter
implements IDiscoveryService {
    public static final String NAME = "ecf.discovery.composite";
    protected static final String METHODS_CATCHING = "org.eclipse.ecf.provider.discovery/debug/methods/catching";
    protected static final String METHODS_TRACING = "org.eclipse.ecf.provider.discovery/debug/methods/tracing";
    protected final CompositeContainerServiceListener ccsl;
    protected final CompositeContainerServiceTypeListener ccstl;
    protected Set registeredServices;
    protected final Collection containers;
    private ID targetID;
    static /* synthetic */ Class class$0;

    public CompositeDiscoveryContainer(Collection containers) {
        IIDFactory iIDFactory = IDFactory.getDefault();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ecf.provider.discovery.CompositeDiscoveryContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super("ecf.namespace.composite", new DiscoveryContainerConfig(iIDFactory.createStringID(clazz.getName())));
        this.ccsl = new CompositeContainerServiceListener();
        this.ccstl = new CompositeContainerServiceTypeListener();
        this.containers = containers;
        this.registeredServices = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(ID aTargetID, IConnectContext connectContext) throws ContainerConnectException {
        if (this.targetID != null || this.getConfig() == null) {
            throw new ContainerConnectException("Already connected");
        }
        this.targetID = aTargetID == null ? this.getConfig().getID() : aTargetID;
        this.fireContainerEvent((IContainerEvent)new ContainerConnectingEvent(this.getID(), this.targetID, (Object)connectContext));
        Collection collection = this.containers;
        synchronized (collection) {
            HashSet<IContainer> containersFailedToConnect = new HashSet<IContainer>();
            Iterator itr = this.containers.iterator();
            while (itr.hasNext()) {
                IContainer container = (IContainer)itr.next();
                if (container.getConnectedID() == null) {
                    try {
                        container.connect(this.targetID, connectContext);
                    }
                    catch (ContainerConnectException cce) {
                        Trace.catching((String)"org.eclipse.ecf.provider.discovery", (String)METHODS_TRACING, ((Object)((Object)this)).getClass(), (String)"connect", (Throwable)cce);
                        containersFailedToConnect.add(container);
                        continue;
                    }
                }
                IDiscoveryLocator idca = (IDiscoveryLocator)container;
                idca.addServiceListener((IServiceListener)this.ccsl);
                idca.addServiceTypeListener((IServiceTypeListener)this.ccstl);
            }
            this.containers.removeAll(containersFailedToConnect);
        }
        this.fireContainerEvent((IContainerEvent)new ContainerConnectedEvent(this.getID(), this.targetID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.fireContainerEvent((IContainerEvent)new ContainerDisconnectingEvent(this.getID(), this.getConnectedID()));
        this.targetID = null;
        Object object = this.containers;
        synchronized (object) {
            Iterator itr = this.containers.iterator();
            while (itr.hasNext()) {
                IContainer container = (IContainer)itr.next();
                container.disconnect();
            }
            this.containers.clear();
        }
        object = this.registeredServices;
        synchronized (object) {
            this.registeredServices.clear();
        }
        object = this.allServiceListeners;
        synchronized (object) {
            this.allServiceListeners.clear();
        }
        object = this.serviceListeners;
        synchronized (object) {
            this.serviceListeners.clear();
        }
        object = this.serviceTypeListeners;
        synchronized (object) {
            this.serviceTypeListeners.clear();
        }
        this.fireContainerEvent((IContainerEvent)new ContainerDisconnectedEvent(this.getID(), this.getConnectedID()));
    }

    protected IServiceEvent getServiceEvent(IServiceInfo iServiceInfo, ID id) {
        CompositeServiceInfoWrapper csi = (CompositeServiceInfoWrapper)iServiceInfo;
        return new CompositeServiceContainerEvent(iServiceInfo, id, csi.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.disconnect();
        Collection collection = this.containers;
        synchronized (collection) {
            Iterator itr = this.containers.iterator();
            while (itr.hasNext()) {
                IContainer container = (IContainer)itr.next();
                container.dispose();
            }
            this.containers.clear();
        }
        this.targetID = null;
        super.dispose();
    }

    public ID getConnectedID() {
        return this.targetID;
    }

    private IServiceID getServiceIDForDiscoveryContainer(IServiceID service, IDiscoveryLocator dca) {
        Namespace connectNamespace = dca.getServicesNamespace();
        if (!connectNamespace.equals((Object)service.getNamespace())) {
            return (IServiceID)connectNamespace.createInstance(new Object[]{service.getServiceTypeID().getName(), service.getLocation()});
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceInfo getServiceInfo(IServiceID aService) {
        Assert.isNotNull((Object)aService);
        Collection collection = this.containers;
        synchronized (collection) {
            Iterator itr = this.containers.iterator();
            while (itr.hasNext()) {
                IServiceID isi;
                IDiscoveryLocator idca = (IDiscoveryLocator)itr.next();
                IServiceInfo service = idca.getServiceInfo(isi = this.getServiceIDForDiscoveryContainer(aService, idca));
                if (service == null) continue;
                return service;
            }
        }
        return null;
    }

    private IServiceInfo getServiceInfoForDiscoveryContainer(IServiceInfo aSi, IDiscoveryLocator idca) {
        IServiceID serviceId = aSi.getServiceID();
        IServiceID sid = this.getServiceIDForDiscoveryContainer(serviceId, idca);
        IServiceTypeID serviceTypeID = sid.getServiceTypeID();
        return new ServiceInfo(serviceId.getLocation(), aSi.getServiceName(), serviceTypeID, aSi.getPriority(), aSi.getWeight(), aSi.getServiceProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceInfo[] getServices() {
        HashSet<IServiceInfo> set = new HashSet<IServiceInfo>();
        Collection collection = this.containers;
        synchronized (collection) {
            Iterator itr = this.containers.iterator();
            while (itr.hasNext()) {
                IDiscoveryLocator idca = (IDiscoveryLocator)itr.next();
                ID containerId = ((IContainer)idca).getID();
                IServiceInfo[] services = idca.getServices();
                int i = 0;
                while (i < services.length) {
                    IServiceInfo iServiceInfo = services[i];
                    services[i] = new CompositeServiceInfoWrapper(iServiceInfo, containerId);
                    ++i;
                }
                set.addAll(Arrays.asList(services));
            }
        }
        return set.toArray(new IServiceInfo[set.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceInfo[] getServices(IServiceTypeID type) {
        Assert.isNotNull((Object)type);
        HashSet<IServiceInfo> set = new HashSet<IServiceInfo>();
        Collection collection = this.containers;
        synchronized (collection) {
            Iterator itr = this.containers.iterator();
            while (itr.hasNext()) {
                IDiscoveryLocator idca = (IDiscoveryLocator)itr.next();
                IServiceTypeID isti = this.getServiceTypeIDForDiscoveryContainer(type, idca);
                IServiceInfo[] services = idca.getServices(isti);
                set.addAll(Arrays.asList(services));
            }
        }
        return set.toArray(new IServiceInfo[set.size()]);
    }

    private IServiceTypeID getServiceTypeIDForDiscoveryContainer(IServiceTypeID type, IDiscoveryLocator dca) {
        Namespace connectNamespace = dca.getServicesNamespace();
        if (!connectNamespace.equals((Object)type.getNamespace())) {
            return ServiceIDFactory.getDefault().createServiceTypeID(connectNamespace, type);
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceTypeID[] getServiceTypes() {
        HashSet<IServiceTypeID> set = new HashSet<IServiceTypeID>();
        Collection collection = this.containers;
        synchronized (collection) {
            Iterator itr = this.containers.iterator();
            while (itr.hasNext()) {
                IDiscoveryLocator idca = (IDiscoveryLocator)itr.next();
                IServiceTypeID[] services = idca.getServiceTypes();
                set.addAll(Arrays.asList(services));
            }
        }
        return set.toArray(new IServiceTypeID[set.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerService(IServiceInfo serviceInfo) {
        Assert.isNotNull((Object)serviceInfo);
        Collection collection = this.registeredServices;
        synchronized (collection) {
            Assert.isTrue((boolean)this.registeredServices.add(serviceInfo));
        }
        collection = this.containers;
        synchronized (collection) {
            Iterator itr = this.containers.iterator();
            while (itr.hasNext()) {
                IDiscoveryAdvertiser dca = (IDiscoveryAdvertiser)itr.next();
                IServiceInfo isi = this.getServiceInfoForDiscoveryContainer(serviceInfo, (IDiscoveryLocator)dca);
                dca.registerService(isi);
                Trace.trace((String)"org.eclipse.ecf.provider.discovery", (String)METHODS_TRACING, ((Object)((Object)this)).getClass(), (String)"registerService", (String)("registeredService " + serviceInfo.toString()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterService(IServiceInfo serviceInfo) {
        Assert.isNotNull((Object)serviceInfo);
        Collection collection = this.registeredServices;
        synchronized (collection) {
            this.registeredServices.remove(serviceInfo);
        }
        collection = this.containers;
        synchronized (collection) {
            Iterator itr = this.containers.iterator();
            while (itr.hasNext()) {
                IDiscoveryAdvertiser idca = (IDiscoveryAdvertiser)itr.next();
                IServiceInfo isi = this.getServiceInfoForDiscoveryContainer(serviceInfo, (IDiscoveryLocator)idca);
                idca.unregisterService(isi);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAllServices() {
        Set set = this.registeredServices;
        synchronized (set) {
            Collection collection = this.containers;
            synchronized (collection) {
                Iterator itr = this.containers.iterator();
                while (itr.hasNext()) {
                    IDiscoveryAdvertiser idca = (IDiscoveryAdvertiser)itr.next();
                    Iterator itr2 = this.registeredServices.iterator();
                    while (itr2.hasNext()) {
                        IServiceInfo serviceInfo = (IServiceInfo)itr2.next();
                        IServiceInfo isi = this.getServiceInfoForDiscoveryContainer(serviceInfo, (IDiscoveryLocator)idca);
                        idca.unregisterService(isi);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServiceInfo[] purgeCache() {
        HashSet<IServiceInfo> set = new HashSet<IServiceInfo>();
        Collection collection = this.containers;
        synchronized (collection) {
            Iterator itr = this.containers.iterator();
            while (itr.hasNext()) {
                IDiscoveryLocator idca = (IDiscoveryLocator)itr.next();
                IServiceInfo[] services = idca.purgeCache();
                set.addAll(Arrays.asList(services));
            }
        }
        return set.toArray(new IServiceInfo[set.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addContainer(Object object) {
        IContainer iContainer = (IContainer)object;
        if (iContainer.getConnectedID() == null) {
            try {
                iContainer.connect(this.targetID, null);
            }
            catch (ContainerConnectException e) {
                Trace.catching((String)"org.eclipse.ecf.provider.discovery", (String)METHODS_CATCHING, ((Object)((Object)this)).getClass(), (String)"addContainer(Object)", (Throwable)e);
                return false;
            }
        }
        IDiscoveryLocator idca = (IDiscoveryLocator)object;
        idca.addServiceListener((IServiceListener)this.ccsl);
        idca.addServiceTypeListener((IServiceTypeListener)this.ccstl);
        Collection collection = this.registeredServices;
        synchronized (collection) {
            IDiscoveryAdvertiser ida = (IDiscoveryAdvertiser)object;
            Iterator itr = this.registeredServices.iterator();
            while (itr.hasNext()) {
                IServiceInfo serviceInfo = (IServiceInfo)itr.next();
                try {
                    ida.registerService(serviceInfo);
                }
                catch (ECFRuntimeException e) {
                    Trace.catching((String)"org.eclipse.ecf.provider.discovery", (String)METHODS_CATCHING, ((Object)((Object)this)).getClass(), (String)"addContainer(Object)", (Throwable)e);
                }
            }
        }
        collection = this.containers;
        synchronized (collection) {
            Trace.trace((String)"org.eclipse.ecf.provider.discovery", (String)METHODS_TRACING, ((Object)((Object)this)).getClass(), (String)"addContainer(Object)", (String)("addContainer " + object.toString()));
            return this.containers.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeContainer(Object object) {
        IDiscoveryLocator idca = (IDiscoveryLocator)object;
        idca.removeServiceListener((IServiceListener)this.ccsl);
        idca.removeServiceTypeListener((IServiceTypeListener)this.ccstl);
        Collection collection = this.containers;
        synchronized (collection) {
            Trace.trace((String)"org.eclipse.ecf.provider.discovery", (String)METHODS_TRACING, ((Object)((Object)this)).getClass(), (String)"removeContainer(Object)", (String)("removeContainer " + object.toString()));
            return this.containers.remove(object);
        }
    }

    public Collection getDiscoveryContainers() {
        return Collections.unmodifiableCollection(this.containers);
    }

    public String getContainerName() {
        return NAME;
    }

    protected class CompositeContainerServiceListener
    implements IServiceListener {
        protected CompositeContainerServiceListener() {
        }

        public void serviceDiscovered(IServiceEvent event) {
            Collection col = CompositeDiscoveryContainer.this.getListeners(event.getServiceInfo().getServiceID().getServiceTypeID());
            if (!col.isEmpty()) {
                Iterator itr = col.iterator();
                while (itr.hasNext()) {
                    IServiceListener isl = (IServiceListener)itr.next();
                    isl.serviceDiscovered((IServiceEvent)new CompositeServiceContainerEvent(event, CompositeDiscoveryContainer.this.getConnectedID()));
                    Trace.trace((String)"org.eclipse.ecf.provider.discovery", (String)CompositeDiscoveryContainer.METHODS_TRACING, this.getClass(), (String)"serviceDiscovered", (String)("serviceResolved fired for listener " + isl.toString() + " with event: " + event.toString()));
                }
            } else {
                Trace.trace((String)"org.eclipse.ecf.provider.discovery", (String)CompositeDiscoveryContainer.METHODS_TRACING, this.getClass(), (String)"serviceDiscovered", (String)"serviceResolved fired without any listeners present");
            }
        }

        public void serviceUndiscovered(IServiceEvent event) {
            Collection col = CompositeDiscoveryContainer.this.getListeners(event.getServiceInfo().getServiceID().getServiceTypeID());
            if (!col.isEmpty()) {
                Iterator itr = col.iterator();
                while (itr.hasNext()) {
                    IServiceListener isl = (IServiceListener)itr.next();
                    isl.serviceUndiscovered((IServiceEvent)new CompositeServiceContainerEvent(event, CompositeDiscoveryContainer.this.getConnectedID()));
                    Trace.trace((String)"org.eclipse.ecf.provider.discovery", (String)CompositeDiscoveryContainer.METHODS_TRACING, this.getClass(), (String)"serviceUndiscovered", (String)("serviceRemoved fired for listener " + isl.toString() + " with event: " + event.toString()));
                }
            } else {
                Trace.trace((String)"org.eclipse.ecf.provider.discovery", (String)CompositeDiscoveryContainer.METHODS_TRACING, this.getClass(), (String)"serviceUndiscovered", (String)"serviceRemoved fired without any listeners present");
            }
        }

        public boolean triggerDiscovery() {
            return false;
        }
    }

    protected class CompositeContainerServiceTypeListener
    implements IServiceTypeListener {
        protected CompositeContainerServiceTypeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void serviceTypeDiscovered(IServiceTypeEvent event) {
            Collection collection = CompositeDiscoveryContainer.this.serviceTypeListeners;
            synchronized (collection) {
                Iterator itr = CompositeDiscoveryContainer.this.serviceTypeListeners.iterator();
                while (itr.hasNext()) {
                    IServiceTypeListener listener = (IServiceTypeListener)itr.next();
                    listener.serviceTypeDiscovered((IServiceTypeEvent)new CompositeServiceTypeContainerEvent(event, CompositeDiscoveryContainer.this.getConnectedID()));
                    Trace.trace((String)"org.eclipse.ecf.provider.discovery", (String)CompositeDiscoveryContainer.METHODS_TRACING, this.getClass(), (String)"serviceTypeDiscovered", (String)("serviceTypeDiscovered fired for listener " + listener.toString() + " with event: " + event.toString()));
                }
            }
            IServiceTypeID istid = event.getServiceTypeID();
            Collection collection2 = CompositeDiscoveryContainer.this.containers;
            synchronized (collection2) {
                Iterator itr = CompositeDiscoveryContainer.this.containers.iterator();
                while (itr.hasNext()) {
                    IDiscoveryLocator idca = (IDiscoveryLocator)itr.next();
                    idca.addServiceListener(istid, (IServiceListener)CompositeDiscoveryContainer.this.ccsl);
                }
            }
        }
    }

    public static class CompositeServiceInfoWrapper
    implements IServiceInfo {
        private final IServiceInfo anInfo;
        private final ID anId;

        public CompositeServiceInfoWrapper(IServiceInfo anInfo, ID anId) {
            this.anInfo = anInfo;
            this.anId = anId;
        }

        public ID getId() {
            return this.anId;
        }

        public URI getLocation() {
            return this.anInfo.getLocation();
        }

        public IServiceID getServiceID() {
            return this.anInfo.getServiceID();
        }

        public int getPriority() {
            return this.anInfo.getPriority();
        }

        public Object getAdapter(Class adapter) {
            return this.anInfo.getAdapter(adapter);
        }

        public int getWeight() {
            return this.anInfo.getWeight();
        }

        public long getTTL() {
            return this.anInfo.getTTL();
        }

        public IServiceProperties getServiceProperties() {
            return this.anInfo.getServiceProperties();
        }

        public String getServiceName() {
            return this.anInfo.getServiceName();
        }
    }
}

