/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.osgi.services.distribution;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.util.LogHelper;
import org.eclipse.ecf.core.util.SystemLogService;
import org.eclipse.ecf.internal.osgi.services.distribution.BasicTopologyManagerComponent;
import org.eclipse.ecf.internal.osgi.services.distribution.BasicTopologyManagerImpl;
import org.eclipse.ecf.internal.osgi.services.distribution.OSGiTopologyManagerImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.service.EventListenerHook;
import org.osgi.service.log.LogService;
import org.osgi.service.remoteserviceadmin.EndpointDescription;
import org.osgi.service.remoteserviceadmin.EndpointEvent;
import org.osgi.service.remoteserviceadmin.EndpointEventListener;
import org.osgi.service.remoteserviceadmin.EndpointListener;
import org.osgi.service.remoteserviceadmin.RemoteServiceAdminListener;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf.osgi.services.distribution";
    public static final boolean autoCreateProxyContainer = new Boolean(System.getProperty("org.eclipse.ecf.osgi.services.distribution.autoCreateProxyContainer", "true"));
    public static final boolean autoCreateHostContainer = new Boolean(System.getProperty("org.eclipse.ecf.osgi.services.distribution.autoCreateHostContainer", "true"));
    public static final String defaultHostConfigType = System.getProperty("org.eclipse.ecf.osgi.services.distribution.defaultConfigType", "ecf.generic.server");
    private static final String PROP_USE_DS = "equinox.use.ds";
    private static Activator plugin;
    private BundleContext context;
    private ServiceTracker logServiceTracker = null;
    private LogService logService = null;
    private BasicTopologyManagerImpl basicTopologyManagerImpl;
    private ServiceRegistration endpointListenerReg;
    private ServiceRegistration endpointEventListenerReg;
    private Map<Bundle, List<EndpointEventHolder>> bundleEndpointEventListenerMap = new HashMap<Bundle, List<EndpointEventHolder>>();
    private BasicTopologyManagerComponent basicTopologyManagerComp;
    private ServiceRegistration eventListenerHookRegistration;
    private ServiceRegistration eventAdminListenerRegistration;
    private static final boolean disableBasicTopologyManager;
    private OSGiTopologyManagerImpl osgiTopologyManagerImpl;

    static {
        disableBasicTopologyManager = new Boolean(System.getProperty("org.eclipse.ecf.osgi.services.distribution.disableBasicTopologyManager", "false"));
    }

    public static Activator getDefault() {
        return plugin;
    }

    public BundleContext getContext() {
        return this.context;
    }

    protected LogService getLogService() {
        if (this.context == null) {
            return null;
        }
        if (this.logServiceTracker == null) {
            this.logServiceTracker = new ServiceTracker(this.context, LogService.class.getName(), null);
            this.logServiceTracker.open();
        }
        this.logService = (LogService)this.logServiceTracker.getService();
        if (this.logService == null) {
            this.logService = new SystemLogService(PLUGIN_ID);
        }
        return this.logService;
    }

    public void log(IStatus status) {
        if (this.logService == null) {
            this.logService = this.getLogService();
        }
        if (this.logService != null) {
            this.logService.log(null, LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
        }
    }

    public void log(ServiceReference sr, IStatus status) {
        this.log(sr, LogHelper.getLogCode((IStatus)status), LogHelper.getLogMessage((IStatus)status), status.getException());
    }

    public void log(ServiceReference sr, int level, String message, Throwable t) {
        if (this.logService == null) {
            this.logService = this.getLogService();
        }
        if (this.logService != null) {
            this.logService.log(sr, level, message, t);
        }
    }

    public void start(BundleContext ctxt) throws Exception {
        plugin = this;
        this.context = ctxt;
        if (disableBasicTopologyManager) {
            this.osgiTopologyManagerImpl = new OSGiTopologyManagerImpl(this.context);
            Properties props = new Properties();
            props.put("endpoint.listener.scope", this.osgiTopologyManagerImpl.getScope());
            this.endpointListenerReg = this.getContext().registerService(EndpointListener.class.getName(), (Object)this.osgiTopologyManagerImpl, (Dictionary)props);
            this.endpointEventListenerReg = this.getContext().registerService(EndpointEventListener.class.getName(), (Object)this.osgiTopologyManagerImpl, (Dictionary)props);
            this.osgiTopologyManagerImpl.activate();
        } else {
            this.basicTopologyManagerImpl = new BasicTopologyManagerImpl(this.context);
            Properties props = new Properties();
            props.put("endpoint.listener.scope", this.basicTopologyManagerImpl.getScope());
            this.endpointEventListenerReg = this.getContext().registerService(EndpointEventListener.class.getName(), (Object)new ServiceFactory(){

                public Object getService(Bundle bundle, ServiceRegistration registration) {
                    return new ProxyEndpointEventListener(bundle);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
                    ProxyEndpointEventListener peel;
                    ProxyEndpointEventListener proxyEndpointEventListener = peel = service instanceof ProxyEndpointEventListener ? (ProxyEndpointEventListener)service : null;
                    if (peel == null) {
                        return;
                    }
                    Map map = Activator.this.bundleEndpointEventListenerMap;
                    synchronized (map) {
                        List endpointEventHolders = (List)Activator.this.bundleEndpointEventListenerMap.get(bundle);
                        if (endpointEventHolders != null) {
                            for (EndpointEventHolder eh : endpointEventHolders) {
                                peel.deliverRemoveEventForBundle(eh);
                            }
                        }
                    }
                }
            }, (Dictionary)props);
            if (Boolean.valueOf(this.context.getProperty(PROP_USE_DS)).booleanValue()) {
                return;
            }
            String serviceName = EventListenerHook.class.getName();
            Filter serviceFilter = this.context.createFilter("(objectclass=" + serviceName + ")");
            ServiceReference[] refs = this.context.getBundle().getRegisteredServices();
            if (refs != null) {
                int i = 0;
                while (i < refs.length) {
                    if (serviceFilter.match(refs[i])) {
                        return;
                    }
                    ++i;
                }
            }
            this.basicTopologyManagerComp = new BasicTopologyManagerComponent();
            this.basicTopologyManagerComp.bindEndpointEventListener(this.basicTopologyManagerImpl);
            this.eventAdminListenerRegistration = this.context.registerService(RemoteServiceAdminListener.class, (Object)this.basicTopologyManagerComp, null);
            this.eventListenerHookRegistration = this.context.registerService(EventListenerHook.class, (Object)this.basicTopologyManagerComp, null);
            this.basicTopologyManagerComp.activate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext ctxt) throws Exception {
        if (this.eventListenerHookRegistration != null) {
            this.eventListenerHookRegistration.unregister();
            this.eventListenerHookRegistration = null;
        }
        if (this.basicTopologyManagerComp != null) {
            this.basicTopologyManagerComp.unbindEndpointEventListener(this.basicTopologyManagerImpl);
            this.basicTopologyManagerComp = null;
        }
        if (this.endpointEventListenerReg != null) {
            this.endpointEventListenerReg.unregister();
            this.endpointEventListenerReg = null;
        }
        if (this.endpointListenerReg != null) {
            this.endpointListenerReg.unregister();
            this.endpointListenerReg = null;
        }
        if (this.eventAdminListenerRegistration != null) {
            this.eventAdminListenerRegistration.unregister();
            this.eventAdminListenerRegistration = null;
        }
        Map<Bundle, List<EndpointEventHolder>> map = this.bundleEndpointEventListenerMap;
        synchronized (map) {
            this.bundleEndpointEventListenerMap.clear();
        }
        if (this.basicTopologyManagerImpl != null) {
            this.basicTopologyManagerImpl.close();
            this.basicTopologyManagerImpl = null;
        }
        if (this.logServiceTracker != null) {
            this.logServiceTracker.close();
            this.logServiceTracker = null;
            this.logService = null;
        }
        this.context = null;
        plugin = null;
    }

    class EndpointEventHolder {
        private final EndpointDescription endpointDescription;
        private final String filter;

        public EndpointEventHolder(EndpointDescription d, String f) {
            this.endpointDescription = d;
            this.filter = f;
        }

        public EndpointDescription getEndpoint() {
            return this.endpointDescription;
        }

        public String getFilter() {
            return this.filter;
        }
    }

    public class ProxyEndpointEventListener
    implements EndpointEventListener {
        private final Bundle bundle;

        public ProxyEndpointEventListener(Bundle b) {
            this.bundle = b;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endpointChanged(EndpointEvent event, String filter) {
            int type = event.getType();
            if (type == 1) {
                Map map = Activator.this.bundleEndpointEventListenerMap;
                synchronized (map) {
                    ArrayList<EndpointEventHolder> endpointEventHolders = (ArrayList<EndpointEventHolder>)Activator.this.bundleEndpointEventListenerMap.get(this.bundle);
                    if (endpointEventHolders == null) {
                        endpointEventHolders = new ArrayList<EndpointEventHolder>();
                    }
                    endpointEventHolders.add(new EndpointEventHolder(event.getEndpoint(), filter));
                    Activator.this.bundleEndpointEventListenerMap.put(this.bundle, endpointEventHolders);
                }
            }
            if (type == 2) {
                Map map = Activator.this.bundleEndpointEventListenerMap;
                synchronized (map) {
                    List endpointEventHolders = (List)Activator.this.bundleEndpointEventListenerMap.get(this.bundle);
                    if (endpointEventHolders != null) {
                        Iterator i = endpointEventHolders.iterator();
                        while (i.hasNext()) {
                            EndpointDescription newEd;
                            EndpointEventHolder eh = (EndpointEventHolder)i.next();
                            EndpointDescription oldEd = eh.getEndpoint();
                            if (!oldEd.equals((Object)(newEd = event.getEndpoint()))) continue;
                            i.remove();
                        }
                        if (endpointEventHolders.size() == 0) {
                            Activator.this.bundleEndpointEventListenerMap.remove(this.bundle);
                        }
                    }
                }
            }
            this.deliverSafe(event, filter);
        }

        public BasicTopologyManagerImpl getBasicTopologyManagerImpl() {
            return Activator.this.basicTopologyManagerImpl;
        }

        private void logError(String methodName, String message, Throwable e) {
            Activator.getDefault().log((IStatus)new Status(4, Activator.PLUGIN_ID, 4, String.valueOf(Activator.class.getName()) + ":" + (methodName == null ? "<unknown>" : methodName) + ":" + (message == null ? "<empty>" : message), e));
        }

        private void deliverSafe(EndpointEvent endpointEvent, String matchingFilter) {
            BasicTopologyManagerImpl listener = Activator.this.basicTopologyManagerImpl;
            if (listener == null) {
                return;
            }
            try {
                listener.endpointChanged(endpointEvent, matchingFilter);
            }
            catch (Exception e) {
                String message = "Exception in EndpointEventListener listener=" + (Object)((Object)listener) + " event=" + endpointEvent + " matchingFilter=" + matchingFilter;
                this.logError("deliverSafe", message, e);
            }
            catch (LinkageError e) {
                String message = "LinkageError in EndpointEventListener listener=" + (Object)((Object)listener) + " event=" + endpointEvent + " matchingFilter=" + matchingFilter;
                this.logError("deliverSafe", message, e);
            }
            catch (AssertionError e) {
                String message = "AssertionError in EndpointEventListener listener=" + (Object)((Object)listener) + " event=" + endpointEvent + " matchingFilter=" + matchingFilter;
                this.logError("deliverSafe", message, (Throwable)((Object)e));
            }
        }

        public void deliverRemoveEventForBundle(EndpointEventHolder eventHolder) {
            this.deliverSafe(new EndpointEvent(2, eventHolder.getEndpoint()), eventHolder.getFilter());
        }
    }
}

