/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.discovery.ui.userinput.handler;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerFactory;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.discovery.ui.userinput.Activator;
import org.eclipse.ecf.discovery.ui.userinput.Messages;
import org.eclipse.ecf.discovery.ui.userinput.UserInputDiscoveryLocator;
import org.eclipse.ecf.discovery.ui.userinput.handler.InputDialogWithComboHistory;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class LookupHandler
extends AbstractHandler {
    private static final String MANUAL_LOOKUP_HANDLER = "ManualLookupHandler";
    private static final String HOST_DOMAIN_TLD_PORT = "scheme://host.domain.tld:port";
    private static IInputValidator VALIDATOR = new MyInputValidator();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        IDialogSettings dialogSettings = Activator.getDefault().getDialogSettings();
        String[] inputs = dialogSettings.getArray(MANUAL_LOOKUP_HANDLER);
        InputDialogWithComboHistory dialog = new InputDialogWithComboHistory(window.getShell(), Messages.LookupHandler_DIALOG_TITLE, Messages.LookupHandler_DIALOG_LABEL, HOST_DOMAIN_TLD_PORT, inputs, VALIDATOR);
        if (dialog.open() == 0) {
            String input = dialog.getValue();
            try {
                String[] copyOfPreviousInput;
                URI uri = URI.create(input);
                InetAddress.getByName(uri.getHost());
                LookupJob job = new LookupJob(uri);
                job.setUser(false);
                job.schedule();
                if (inputs != null) {
                    copyOfPreviousInput = new String[inputs.length + 1];
                    copyOfPreviousInput[0] = input;
                    int i = 0;
                    while (i < inputs.length) {
                        copyOfPreviousInput[i + 1] = inputs[i];
                        ++i;
                    }
                } else {
                    copyOfPreviousInput = new String[]{input};
                }
                LinkedHashSet<String> aSet = new LinkedHashSet<String>(Arrays.asList(copyOfPreviousInput));
                dialogSettings.put(MANUAL_LOOKUP_HANDLER, aSet.toArray(new String[aSet.size()]));
            }
            catch (ContainerCreateException e) {
                throw new ExecutionException(Messages.LookupHandler_EXEC_FAILED, (Throwable)e);
            }
            catch (IDCreateException e) {
                throw new ExecutionException(Messages.LookupHandler_EXEC_FAILED, (Throwable)e);
            }
            catch (UnknownHostException e) {
                Status status = new Status(1, "org.eclipse.ecf.discovery.ui.userinput", Messages.LookupHandler_UNKNOWN_HOSTNAME);
                ErrorDialog.openError(null, (String)Messages.LookupHandler_UNKNOWN_HOSTNAME, (String)NLS.bind((String)Messages.LookupHandler_HOSTNAME_UNABLE_TO_RESOLVE, (Object)input), (IStatus)status);
            }
        }
        return null;
    }

    private class LookupJob
    extends Job {
        private UserInputDiscoveryLocator container;
        private IServiceTypeID serviceTypeID;
        private URI uri;

        public LookupJob(URI anURI) throws ContainerCreateException, IDCreateException {
            super(Messages.LookupHandler_RESOLVING);
            this.uri = anURI;
            this.container = (UserInputDiscoveryLocator)ContainerFactory.getDefault().createContainer("ecf.discovery.userinput.locator");
            Namespace namespace = IDFactory.getDefault().getNamespaceByName(this.uri.getScheme());
            if (namespace != null) {
                this.serviceTypeID = (IServiceTypeID)namespace.createInstance(new Object[]{this.uri});
            }
        }

        protected IStatus run(IProgressMonitor arg0) {
            this.container.fireServiceResolved(this.uri, this.serviceTypeID);
            return Status.OK_STATUS;
        }
    }

    private static class MyInputValidator
    implements IInputValidator {
        private MyInputValidator() {
        }

        public String isValid(String newText) {
            URI uri = null;
            try {
                uri = new URI(newText);
            }
            catch (URISyntaxException e) {
                return Messages.LookupHandler_INVALID_HOSTNAME;
            }
            int p = uri.getPort();
            if (p > 65565 || p < 1) {
                return Messages.LookupHandler_INVALID_PORT;
            }
            return null;
        }
    }
}

